~VERSION INFORMATION
VERS.           2.0   :CWLS Log ASCII Standard - VERSION 2.0
WRAP.           NO    :One Line per depth step
PROD.  Schlumberger   :LAS Producer
PROG.  DLIS to ASCII 17C0-154                          :LAS Program name and version
CREA.        2010/05/17 15:00                          :LAS Creation date {YYYY/MM/DD hh:mm}
DLIS_CREA.  2010-May-15 20:19                          :DLIS Creation date and time {YYYY-MMM-DD hh:mm}
SOURCE.     AIT_TLD_MCFL_CNL_015PUP.DLIS               :DLIS File Name
FILE-ID.     AIT_TLD_MCFL_CNL_015PUP                   :File Identification Number
#--------------------------------------------------
~WELL INFORMATION
#MNEM.UNIT      DATA             DESCRIPTION
#---- ------ --------------   -----------------------------
STRT .M      2276.5512       :START DEPTH     
STOP .M      2404.8720       :STOP DEPTH     
STEP .M       0.1524         :STEP     
NULL .          -999.25      :NULL VALUE
COMP .        Nalcor Energy Oil and Gas                :COMPANY
WELL .        Nalcor et al Seamus 1                    :WELL
FLD  .        Parson's Pond                            :FIELD
LOC  .        Latitude: 49.98 N                        :LOCATION
CNTY .        Stoneham #11                             :COUNTY
STAT .        Newfoundland                             :STATE
CTRY .                                                 :COUNTRY
API  .                                                 :API NUMBER
UWI  .                                                 :UNIQUE WELL ID
DATE .        15-May-2010                              :LOG DATE {DD-MMM-YYYY}
SRVC .        Schlumberger                             :SERVICE COMPANY
LATI .DEG     46 DEG 23 MIN 57.8 S                     :LATITUDE
LONG .DEG     48 DEG 27 MIN 52.1 S                     :LONGITUDE
GDAT .                                                 :GeoDetic Datum
SECT .        49.98 N                                  :Section
TOWN .        57.70 W                                  :Township
#-----------------------------------------------------------------------------
~PARAMETER INFORMATION
#MNEM.UNIT    VALUE                      DESCRIPTION
#---- -----   --------------------       ------------------------
RUN  .          Run 1                    :RUN NUMBER
PDAT .        Ground Level               :Permanent Datum
EPD  .M          20.690001               :Elevation of Permanent Datum above Mean Sea Level
LMF  .          Kelly Bushing            :Logging Measured From (Name of Logging Elevation Reference)
APD  .M           6.299999               :Elevation of Depth Reference (LMF) above Permanent Datum
#-----------------------------------------------------------------------------
~CURVE INFORMATION
#MNEM.UNIT   API CODE                                  DESCRIPTION
#---- -----  --------                                  -----------------------
DEPT .M                                                :DEPTH (BOREHOLE) {F10.4}
AT10 .OHMM                                             :Array Induction Two Foot Resistivity A10 {F13.4}
AT20 .OHMM                                             :Array Induction Two Foot Resistivity A20 {F13.4}
AT30 .OHMM                                             :Array Induction Two Foot Resistivity A30 {F13.4}
AT60 .OHMM                                             :Array Induction Two Foot Resistivity A60 {F13.4}
AT90 .OHMM                                             :Array Induction Two Foot Resistivity A90 {F13.4}
ATCO90.MM/M                                            :Array Induction Two Foot Conductivity A90 {F13.4}
BS   .MM                                               :Bit Size {F13.4}
DPHI_DOL.V/V                                           :Density Porosity (matrix Dolomite) {F13.4}
DPHI_LIM.V/V                                           :Density Porosity (matrix Limestone) {F13.4}
DPHI_SAN.V/V                                           :Density Porosity (matrix Sandstone) {F13.4}
GDEV .DEG                                              :HGNS Deviation {F13.4}
GR   .GAPI                                             :Gamma-Ray {F13.4}
HCAL .MM                                               :HRCC Cal. Caliper {F13.4}
HDRA .K/M3                                             :HRDD Density Correction {F13.4}
HTEM .DEGC                                             :HTC Temperature {F13.4}
NPOR_DOL.V/V                                           :Enhanced Thermal Neutron Porosity (matrix Dolomite) {F13.4}
NPOR_LIM.V/V                                           :Enhanced Thermal Neutron Porosity (matrix Limestone) {F13.4}
NPOR_SAN.V/V                                           :Enhanced Thermal Neutron Porosity (matrix Sandstone) {F13.4}
PEFZ .                                                 :HRDD Standard Resolution Formation Photoelectric Factor {F13.4}
RHOZ .K/M3                                             :HRDD Standard Resolution Formation Density {F13.4}
RXOZ .OHMM                                             :MCFL Standard Resolution Invaded Zone Resistivity {F13.4}
SP   .MV                                               :SP Shifted {F13.4}
TENS .LBF                                              :Cable Tension {F13.4}
#-----------------------------------------------------------------------------
# 
#     DEPT        AT10         AT20         AT30         AT60         AT90        ATCO90        BS         DPHI_DOL     DPHI_LIM     DPHI_SAN       GDEV         GR           HCAL         HDRA         HTEM       NPOR_DOL     NPOR_LIM     NPOR_SAN       PEFZ         RHOZ         RXOZ         SP           TENS
#
~A  
 2276.5512      47.0465       0.5230    1317.7804    1950.0000      46.7232      21.4026     216.0000      -0.8998      -1.0554      -1.1301      15.9756      43.4580     229.2714    1607.4679      49.9441       0.2434       0.2762       0.3266      10.0000    4525.7451       0.0638      87.8750    3426.0000
 2276.7036      47.0465       0.5230    1317.7804    1950.0000      46.7232      21.4026     216.0000      -0.8998      -1.0554      -1.1301      15.9637      44.1550     229.5505    1607.4679      49.9441       0.2434       0.2762       0.3266      10.0000    4525.7451       0.0638      88.8750    3412.0000
 2276.8560      47.0465       0.5230    1317.7804    1950.0000      46.7232      21.4026     216.0000      -0.8998      -1.0554      -1.1301      15.9536      44.5939     229.5505    1607.4679      49.9441       0.2905       0.3303       0.3780      10.0000    4525.7451       0.0650     102.0625    3411.0000
 2277.0084      47.0465       0.5230    1317.7804    1950.0000      46.7232      21.4026     216.0000      -0.8998      -1.0554      -1.1301      15.9518      41.0728     229.2714    1607.4679      49.9441       0.2599       0.2947       0.3446      10.0000    4525.7451       0.0642      87.8750    3416.0000
 2277.1608      47.0465       0.5230    1317.7804    1950.0000      46.7232      21.4026     216.0000      -0.8998      -1.0554      -1.1301      15.9329      40.6500     229.8296    1607.4679      49.9441       0.2079       0.2356       0.2870      10.0000    4525.7451       0.0643      95.4375    3395.0000
 2277.3132      47.0465       0.5230    1317.7804    1950.0000      46.7232      21.4026     216.0000      -0.8998      -1.0554      -1.1301      15.9184      37.5169     229.2714    1607.4679      49.9441       0.1593       0.1802       0.2315      10.0000    4525.7451       0.0669      96.8125    3396.0000
 2277.4656      47.0465       0.5230    1317.7804    1950.0000      46.7232      21.4026     216.0000      -0.8998      -1.0554      -1.1301      15.9253      37.3814     229.2714    1600.1870      49.9441       0.1398       0.1585       0.2089      10.0000    4514.6733       0.0655      82.5625    3400.0000
 2277.6180      62.3191       0.5209    1218.9587    1950.0000      36.5354      27.3707     216.0000      -0.8860      -1.0404      -1.1146      15.8872      35.4777     229.2714    1591.9080      49.9441       0.1478       0.1676       0.2183      10.0000    4489.0889       0.0652      87.9375    3394.0000
 2277.7704     118.9481       0.5170    1059.4960    1688.0975      31.1441      32.1088     216.0000      -0.8687      -1.0217      -1.0952      15.8846      37.9154     229.5505    1594.9945      49.9441       0.1850       0.2097       0.2612      10.0000    4457.1406       0.0625      86.1250    3411.0000
 2277.9228     242.2411       0.5140     964.8316    1163.2926      28.0540      35.6456     216.0000      -0.8522      -1.0038      -1.0767      15.8412      39.2356     229.2714    1604.0454      49.9441       0.2294       0.2586       0.3107      10.0000    4426.4834       0.0638      87.8750    3431.0000
 2278.0752     521.0922       0.5122     920.5856     658.3690      30.7762      32.4926     216.0000      -0.8411      -0.9919      -1.0643      15.8802      42.8966     229.5505    1599.8611      49.9441       0.1945       0.2199       0.2718      10.0000    4406.1226       0.0626      92.5000    3395.0000
 2278.2276    1738.6827       0.5113     871.2852     349.5117      51.6325      19.3676     216.0000      -0.8346      -0.9848      -1.0570      15.8585      42.6257     229.8296    1598.0382      49.9441       0.1600       0.1816       0.2326      10.0000    4393.9990       0.0689      95.1875    3416.0000
 2278.3800    1950.0000       0.5110     788.2642     194.6904      43.5384      22.9682     216.0000      -0.8334      -0.9835      -1.0556      15.8389      43.0690     229.5505    1582.0870      49.9441       0.2090       0.2354       0.2878      10.0000    4391.7798       0.0727      94.0000    3411.0000
 2278.5324    1950.0000       0.5117     681.7192     120.3171      24.4966      40.8220     216.0000      -0.8378      -0.9882      -1.0605      15.8472      38.8708     229.2714    1577.3077      49.9441       0.1838       0.2081       0.2597      10.0000    4399.8540       0.0723      91.3125    3388.0000
 2278.6848    1950.0000       0.5145     571.7625      85.8782      18.6695      53.5633     216.0000      -0.8493      -1.0007      -1.0734      15.8721      39.4125     228.9923    1573.1432      49.9441       0.1706       0.1940       0.2449      10.0000    4421.1924       0.0693      93.0000    3413.0000
 2278.8372    1950.0000       0.5206     482.5768      59.6967      13.4743      74.2153     216.0000      -0.8638      -1.0164      -1.0898      15.8399      39.5782     229.2714    1590.4164      49.9441       0.2235       0.2537       0.3046      10.0000    4448.1187       0.0640      81.0000    3412.0000
 2278.9896    1950.0000       0.5301     399.8959      52.6706      15.3955      64.9540     216.0000      -0.8745      -1.0280      -1.1017      15.7919      39.7136     229.5505    1637.9447      49.9441       0.2364       0.2695       0.3192      10.0000    4467.8691       0.0666      86.7500    3387.0000
 2279.1420    1950.0000       0.5407     307.8421      65.6738      22.8721      43.7213     216.0000      -0.8779      -1.0316      -1.1055      15.8086      40.5665     229.2714    1714.0143      49.9441       0.2553       0.2930       0.3405      10.0000    4474.1079       0.0715      89.9375    3400.0000
 2279.2944    1950.0000       0.5494     228.0040      77.8125      26.1535      38.2358     216.0000      -0.8726      -1.0259      -1.0996      15.7963      42.0230     229.2714    1748.7085      49.9441       0.3700       0.4206       0.4618      10.0000    4464.3286       0.0762      84.3750    3403.0000
 2279.4468    1950.0000       0.5539     159.1692      92.3473      19.7400      50.6585     216.0000      -0.8694      -1.0224      -1.0959      15.7735      44.7316     229.2714    1718.6907      49.9441       0.3644       0.4175       0.4567      10.0000    4458.3018       0.0757      88.5625    3406.0000
 2279.5992    1780.7163       0.5534     110.0215      93.3683      10.8415      92.2382     216.0000      -0.8670      -1.0198      -1.0933      15.7583      44.1405     229.2714    1666.2688      49.9441       0.2893       0.3338       0.3778      10.0000    4453.8789       0.0798      87.8750    3403.0000
 2279.7516     643.5989       0.5502      65.4676      67.7075       9.1487     109.3051     216.0000      -0.8654      -1.0181      -1.0915      15.7490      45.6302     228.9923    1663.4874      49.9441       0.2863       0.3290       0.3742      10.0000    4451.0288       0.0799      94.1250    3408.0000
 2279.9040     267.5408       0.5495      49.7387      44.9367      11.1095      90.0132     216.0000      -0.8811      -1.0351      -1.1091      15.7336      45.5431     228.9923    1716.9867      49.9441       0.3085       0.3539       0.3979      10.0000    4479.9917       0.0800      85.5000    3407.0000
 2280.0564    1921.8319       0.5492      48.2492      43.1543      13.6659      73.1747     216.0000      -0.9126      -1.0692      -1.1444      15.7287      47.9898     229.0853    1713.2139      49.9441       0.3703       0.4245       0.4628      10.0000    4538.3174       0.0759      86.0000    3416.0000
 2280.2088     258.0101       0.5496      27.9626      26.3149      12.5627      79.6006     216.0000      -0.9465      -1.1059      -1.1825      15.7252      46.0408     228.9923    1615.4390      49.9441       0.3342       0.3821       0.4249      10.0000    4601.0864       0.0762      79.3125    3414.0000
 2280.3612      18.6086       0.5455      23.1272      18.8092      13.4637      74.2736     216.0000      -0.9615      -1.1221      -1.1993      15.7361      42.3500     229.2714    1467.2604      49.9441       0.2396       0.2738       0.3230      10.0000    4628.7998       0.0761      86.6250    3405.0000
 2280.5136      12.6177       0.4854       4.3505       3.8383       3.1371     318.7654     216.0000      -0.9615      -1.1221      -1.1993      15.7154      34.2243     228.7132    1345.7620      49.9441       0.1843       0.2090       0.2604      10.0000    4628.7998       0.0734      81.6250    3389.0000
 2280.6660       8.8296       0.5221       7.6077       4.9212       3.9675     252.0508     216.0000      -0.9615      -1.1221      -1.1993      15.6829      29.5148     228.4341    1339.3629      49.9441       0.1620       0.1834       0.2347      10.0000    4628.7998       0.0716      83.0000    3392.0000
 2280.8184       9.2332       0.5440      27.2021      27.9426      14.0610      71.1185     216.0000      -0.9615      -1.1221      -1.1993      15.6987      27.6048     228.7132    1426.5339      49.9441       0.1558       0.1763       0.2275      10.0000    4628.7998       0.0692      80.3125    3436.0000
 2280.9708      12.1996       0.5551      36.0577      27.0309      16.7810      59.5913     216.0000      -0.9615      -1.1221      -1.1993      15.6947      30.1805     228.1550    1559.1908      49.9441       0.1746       0.1972       0.2490      10.0000    4628.7998       0.0698      84.8125    3444.0000
 2281.1232      16.3784       0.5552      62.7752      41.1915      14.7030      68.0131     216.0000      -0.9613      -1.1219      -1.1991      15.6872      33.8760     228.7132    1655.9506      49.9441       0.1702       0.1924       0.2440      10.0000    4628.4438       0.0653      81.6250    3492.0000
 2281.2756      28.5817       0.5465      83.6405      43.6279      11.2553      88.8473     216.0000      -0.9571      -1.1173      -1.1943      15.6776      35.5011     228.4341    1681.6273      49.9441       0.1496       0.1694       0.2203      10.0000    4620.6665       0.0648      86.1250    3507.0000
 2281.4280      46.9959       0.5413     181.3628      70.1468       6.7279     148.6348     216.0000      -0.9500      -1.1096      -1.1863      15.6748      36.6662     228.4341    1685.7059      49.9441       0.1567       0.1773       0.2285      10.0000    4607.4692       0.0626      85.6875    3483.0000
 2281.5804      91.2848       0.5353     453.8341     107.3988       9.2821     107.7339     216.0000      -0.9483      -1.1078      -1.1845      15.6626      36.3950     228.7132    1697.9237      49.9441       0.1807       0.2038       0.2559      10.0000    4604.3457       0.0640      86.0625    3496.0000
 2281.7328     199.7996       0.5307    1214.3995     187.9275      23.7203      42.1580     216.0000      -0.9525      -1.1124      -1.1892      15.6449      38.1338     228.7132    1700.6473      49.9441       0.1691       0.1915       0.2429      10.0000    4612.1230       0.0654      87.8750    3519.0000
 2281.8852     517.4506       0.5264    1927.7112     339.9949      34.1436      29.2881     216.0000      -0.9596      -1.1201      -1.1972      15.6273      37.3724     228.1550    1708.6820      49.9441       0.1745       0.1979       0.2492      10.0000    4625.3203       0.0689      80.8750    3520.0000
 2282.0376    1524.7939       0.5207    1950.0000     608.3387      39.2008      25.5097     216.0000      -0.9615      -1.1221      -1.1993      15.6280      36.4084     228.1550    1713.2966      49.9441       0.1903       0.2158       0.2673      10.0000    4628.7998       0.0700      89.1875    3519.0000
 2282.1900    1950.0000       0.5137    1934.3779    1028.3848      25.3425      39.4594     216.0000      -0.9615      -1.1221      -1.1993      15.6080      36.2606     228.1550    1716.1324      49.9441       0.2146       0.2426       0.2944      10.0000    4628.7998       0.0725      74.4375    3498.0000
 2282.3424    1950.0000       0.5064    1813.1119    1390.0880      21.9114      45.6384     216.0000      -0.9615      -1.1221      -1.1993      15.6119      36.0041     228.1550    1700.6366      49.9441       0.2199       0.2488       0.3003      10.0000    4628.7998       0.0685      73.8125    3508.0000
 2282.4948    1950.0000       0.5008    1595.0624    1458.9688      21.5749      46.3503     216.0000      -0.9615      -1.1221      -1.1993      15.6112      37.6631     228.4341    1676.8627      49.9441       0.2032       0.2300       0.2816      10.0000    4628.7998       0.0609      78.1250    3499.0000
 2282.6472    1950.0000       0.4984    1311.2019    1133.8121      32.6842      30.5959     216.0000      -0.9615      -1.1221      -1.1993      15.5915      36.7492     228.4341    1668.0999      49.9441       0.1875       0.2119       0.2638      10.0000    4628.7998       0.0606      78.1250    3468.0000
 2282.7996    1950.0000       0.4998    1045.2898     841.1848      30.4811      32.8072     216.0000      -0.9615      -1.1221      -1.1993      15.5650      39.1330     228.7132    1670.9459      49.9441       0.1443       0.1637       0.2143      10.0000    4628.7998       0.0608      80.6875    3495.0000
 2282.9520    1950.0000       0.5046     856.7674     645.2838      31.5823      31.6633     216.0000      -0.9615      -1.1221      -1.1993      15.5593      37.6095     228.1550    1673.7676      49.9441       0.1679       0.1901       0.2415      10.0000    4628.7998       0.0683      86.5625    3505.0000
 2283.1044    1950.0000       0.5116     757.8113     539.4019      32.7183      30.5639     216.0000      -0.9615      -1.1221      -1.1993      15.5581      38.0801     228.4341    1661.2518      49.9441       0.2164       0.2443       0.2963      10.0000    4628.7998       0.0694      78.8750    3494.0000
 2283.2568    1950.0000       0.5197     739.5352     502.5668      28.6721      34.8771     216.0000      -0.9615      -1.1221      -1.1993      15.5559      36.2236     228.4341    1678.0503      49.9441       0.1944       0.2201       0.2718      10.0000    4628.7998       0.0737      78.1250    3525.0000
 2283.4092    1950.0000       0.5272     789.5057     530.1022      32.6692      30.6098     216.0000      -0.9615      -1.1221      -1.1993      15.5332      36.5834     228.7132    1696.9349      49.9441       0.1684       0.1907       0.2421      10.0000    4628.7998       0.0685      80.8750    3488.0000
 2283.5616    1950.0000       0.5333     878.0207     620.0070      29.3556      34.0650     216.0000      -0.9615      -1.1221      -1.1993      15.5308      36.5191     228.1550    1707.5813      49.9441       0.1668       0.1886       0.2401      10.0000    4628.7998       0.0604      79.5625    3460.0000
 2283.7140    1950.0000       0.5370     921.9577     783.1779      29.0482      34.4255     216.0000      -0.9615      -1.1221      -1.1993      15.5086      36.3040     228.1550    1691.6987      49.9441       0.1622       0.1834       0.2348      10.0000    4628.7998       0.0560      81.0000    3498.0000
 2283.8664    1950.0000       0.5382     829.9213    1006.7532      31.7704      31.4758     216.0000      -0.9615      -1.1221      -1.1993      15.5010      38.3818     228.4341    1676.1835      49.9441       0.1584       0.1790       0.2304      10.0000    4628.7998       0.0595      82.6875    3483.0000
 2284.0188    1950.0000       0.5371     659.3795    1221.4390      33.0520      30.2553     216.0000      -0.9615      -1.1221      -1.1993      15.4924      37.9870     228.4341    1676.5597      49.9441       0.1444       0.1635       0.2142      10.0000    4628.7998       0.0657      84.0000    3495.0000
 2284.1712    1950.0000       0.5348     519.4095    1324.7864      29.0297      34.4475     216.0000      -0.9569      -1.1171      -1.1941      15.5151      38.3375     228.1550    1682.8809      49.9441       0.1658       0.1881       0.2392      10.0000    4620.3213       0.0683      86.1875    3514.0000
 2284.3236    1950.0000       0.5320     443.2884    1324.2668      23.5115      42.5323     216.0000      -0.9482      -1.1077      -1.1843      15.4985      40.5252     228.7132    1697.7281      49.9441       0.2056       0.2336       0.2846      10.0000    4604.1392       0.0706      83.0000    3491.0000
 2284.4760    1950.0000       0.5308     424.8799    1268.5167      22.5804      44.2861     216.0000      -0.9430      -1.1021      -1.1786      15.4636      44.2354     228.4341    1728.9224      49.9441       0.2579       0.2936       0.3427      10.0000    4594.6294       0.0685      82.4375    3493.0000
 2284.6284    1950.0000       0.5317     471.2089    1207.8630      27.9447      35.7850     216.0000      -0.9476      -1.1071      -1.1837      15.4601      49.1108     228.4341    1733.2847      49.9441       0.3556       0.4009       0.4462      10.0000    4603.1084       0.0646      78.4375    3514.0000
 2284.7808    1950.0000       0.5339     585.1750    1142.3613      38.4575      26.0027     216.0000      -0.9564      -1.1165      -1.1935      15.4652      47.5052     228.4341    1736.0105      49.9441       0.2876       0.3283       0.3752      10.0000    4619.2910       0.0608      82.1250    3472.0000
 2284.9332    1950.0000       0.5364     795.0864    1076.3363      37.9817      26.3285     216.0000      -0.9587      -1.1191      -1.1962      15.4628      46.2389     228.1550    1732.4286      49.9441       0.2525       0.2900       0.3375      10.0000    4623.6670       0.0609      83.3125    3495.0000
 2285.0856    1950.0000       0.5389    1111.3054    1014.3151      25.9349      38.5581     216.0000      -0.9497      -1.1093      -1.1860      15.4689      44.9652     228.4341    1748.3518      49.9441       0.2491       0.2852       0.3335      10.0000    4606.9082       0.0632      86.4375    3462.0000
 2285.2380    1950.0000       0.5413    1476.4291     963.9700      25.9597      38.5213     216.0000      -0.9436      -1.1027      -1.1792      15.4212      43.9768     228.1550    1744.2677      49.9441       0.2733       0.3118       0.3597      10.0000    4595.6025       0.0641      82.6875    3477.0000
 2285.3904    1950.0000       0.5438    1761.7874     919.9901      27.3101      36.6165     216.0000      -0.9460      -1.1053      -1.1819      15.3949      46.5959     228.1550    1718.9333      49.9441       0.3019       0.3428       0.3901      10.0000    4600.0767       0.0658      87.8750    3540.0000
 2285.5428    1950.0000       0.5463    1920.0856     875.2167      26.5485      37.6669     216.0000      -0.9550      -1.1151      -1.1920      15.4610      42.5878     228.7132    1679.2853      49.9441       0.2727       0.3108       0.3590      10.0000    4616.8354       0.0656      78.8125    3509.0000
 2285.6952    1950.0000       0.5487    1950.0000     827.6201      23.5478      42.4669     216.0000      -0.9612      -1.1217      -1.1989      15.4751      39.4237     228.1550    1678.8087      49.9441       0.2298       0.2623       0.3121      10.0000    4628.1411       0.0633      80.2500    3522.0000
 2285.8476    1950.0000       0.5504    1893.3486     766.9654      24.3928      40.9957     216.0000      -0.9615      -1.1221      -1.1993      15.4201      38.1606     228.4341    1683.7585      49.9441       0.2038       0.2326       0.2829      10.0000    4628.7998       0.0599      78.1250    3519.0000
 2286.0000    1950.0000       0.5507    1808.6989     697.2371      31.4191      31.8277     216.0000      -0.9615      -1.1221      -1.1993      15.4043      41.2755     228.4341    1685.8695      49.9441       0.2173       0.2470       0.2978      10.0000    4628.7998       0.0626      80.6250    3499.0000
 2286.1524    1950.0000       0.5489    1715.4459     624.2099      30.9406      32.3200     216.0000      -0.9615      -1.1221      -1.1993      15.3513      45.4280     228.4341    1675.8625      49.9441       0.2290       0.2598       0.3107      10.0000    4628.7998       0.0678      83.3125    3510.0000
 2286.3048    1950.0000       0.5453    1636.8640     566.3038      25.6727      38.9519     216.0000      -0.9615      -1.1221      -1.1993      15.2979      42.9710     228.1550    1683.9469      49.9441       0.2394       0.2719       0.3223      10.0000    4628.7998       0.0701      85.5000    3484.0000
 2286.4572    1950.0000       0.5409    1582.9298     534.7226      21.3703      46.7940     216.0000      -0.9580      -1.1183      -1.1954      15.3906      43.6112     228.1550    1694.8452      49.9441       0.2088       0.2375       0.2883      10.0000    4622.3574       0.0725      82.6250    3495.0000
 2286.6096    1950.0000       0.5375    1552.7861     531.2473      20.7580      48.1741     216.0000      -0.9507      -1.1104      -1.1872      15.4147      43.3000     228.1550    1684.5400      49.9441       0.2199       0.2501       0.3007      10.0000    4608.8096       0.0695      87.8750    3530.0000
 2286.7620    1950.0000       0.5357    1501.9050     531.9271      27.9248      35.8105     216.0000      -0.9413      -1.1002      -1.1766      15.4169      43.5805     228.4341    1667.5115      49.9441       0.2338       0.2645       0.3158      10.0000    4591.3271       0.0843      74.6875    3507.0000
 2286.9144    1950.0000       0.5356    1397.8075     515.4180      26.4062      37.8698     216.0000      -0.9387      -1.0974      -1.1737      15.3815      43.0757     228.4341    1695.1177      49.9441       0.2102       0.2408       0.2904      10.0000    4586.5771       0.0993      78.1250    3515.0000
 2287.0668    1950.0000       0.5364    1258.1364     481.0089      30.6224      32.6558     216.0000      -0.9459      -1.1052      -1.1818      15.4799      43.4074     228.4341    1747.4670      49.9441       0.2658       0.3055       0.3521      10.0000    4599.9375       0.1203      89.9375    3523.0000
 2287.2192    1950.0000       0.5371    1137.6564     454.4996      24.4580      40.8863     216.0000      -0.9554      -1.1154      -1.1924      15.4102      47.3252     228.4341    1787.0250      49.9441       0.3648       0.4169       0.4569      10.0000    4617.4194       0.0892      87.8750    3518.0000
 2287.3716    1950.0000       0.5369    1079.6420     463.0528      30.3812      32.9151     216.0000      -0.9614      -1.1220      -1.1992      15.2729      48.4087     227.8759    1792.8715      49.9441       0.4079       0.4664       0.5014      10.0000    4628.6128       0.0783      87.8750    3524.0000
 2287.5240    1950.0000       0.5365    1101.5771     521.3616      23.2022      43.0994     216.0000      -0.9615      -1.1221      -1.1993      15.2595      49.5703     228.1550    1766.0895      49.9441       0.3433       0.3936       0.4347      10.0000    4628.7998       0.0792      87.8750    3500.0000
 2287.6764    1950.0000       0.5362    1207.8984     652.6456      31.6438      31.6018     216.0000      -0.9554      -1.1155      -1.1924      15.2948      45.7951     228.7132    1743.3179      49.9441       0.2945       0.3410       0.3836      10.0000    4617.5156       0.0717      82.0000    3483.0000
 2287.8288    1950.0000       0.5366    1383.3511     876.3131      33.0227      30.2822     216.0000      -0.9426      -1.1016      -1.1780      15.3912      45.3888     228.4341    1720.3579      49.9441       0.3050       0.3523       0.3947      10.0000    4593.7568       0.0629      79.6250    3486.0000
 2287.9812    1950.0000       0.5375    1574.0443    1194.4246      36.1747      27.6437     216.0000      -0.9335      -1.0918      -1.1679      15.3793      43.5958     228.4341    1716.0887      49.9441       0.3541       0.4071       0.4462      10.0000    4577.0620       0.0622      77.1250    3474.0000
 2288.1336    1950.0000       0.5385    1699.4224    1529.4093      34.3547      29.1081     216.0000      -0.9389      -1.0977      -1.1739      15.4468      46.0050     228.7132    1723.3096      49.9441       0.3555       0.4081       0.4476      10.0000    4586.9854       0.0672      75.1875    3500.0000
 2288.2860    1950.0000       0.5390    1683.2080    1754.2330      36.6053      27.3184     216.0000      -0.9518      -1.1115      -1.1883      15.3342      45.4633     228.4341    1740.4167      49.9441       0.3033       0.3495       0.3927      10.0000    4610.7441       0.0719      78.1250    3526.0000
 2288.4384    1950.0000       0.5385    1535.2068    1802.5978      40.5219      24.6780     216.0000      -0.9608      -1.1213      -1.1984      15.3526      46.1691     228.1550    1769.8884      49.9441       0.2868       0.3311       0.3751      10.0000    4627.4385       0.0711      78.1250    3483.0000
 2288.5908    1950.0000       0.5372    1341.8621    1687.7809      42.1976      23.6980     216.0000      -0.9615      -1.1221      -1.1993      15.2906      46.1476     228.1550    1809.5472      49.9441       0.3145       0.3612       0.4044      10.0000    4628.7998       0.0690      72.9375    3512.0000
 2288.7432    1950.0000       0.5361    1174.8052    1480.6923      35.5931      28.0953     216.0000      -0.9615      -1.1221      -1.1993      15.2441      46.6893     228.1550    1822.6451      49.9441       0.3518       0.4032       0.4435      10.0000    4628.7998       0.0636      76.8125    3504.0000
 2288.8956    1950.0000       0.5362    1083.0690    1254.3953      31.8789      31.3687     216.0000      -0.9615      -1.1221      -1.1993      15.3313      48.0719     228.4341    1780.1542      49.9441       0.4146       0.4748       0.5083      10.0000    4628.7998       0.0606      71.0625    3493.0000
 2289.0480    1950.0000       0.5383    1077.6357    1050.7621      28.7435      34.7905     216.0000      -0.9615      -1.1221      -1.1993      15.2811      44.9905     228.1550    1705.0096      49.9441       0.3175       0.3641       0.4074      10.0000    4628.7998       0.0658      74.6250    3517.0000
 2289.2004    1950.0000       0.5411    1160.8284     896.9692      26.4241      37.8442     216.0000      -0.9615      -1.1221      -1.1993      15.3457      41.5627     228.1550    1646.6877      49.9441       0.2449       0.2783       0.3284      10.0000    4628.7998       0.0691      63.9375    3501.0000
 2289.3528    1950.0000       0.5443    1320.8003     792.0632      28.3029      35.3321     216.0000      -0.9615      -1.1221      -1.1993      15.2509      36.6589     228.1550    1638.3364      49.9441       0.1566       0.1778       0.2287      10.0000    4628.7998       0.0699      69.5625    3531.0000
 2289.5052    1950.0000       0.5462    1530.2236     733.3735      22.0946      45.2599     216.0000      -0.9605      -1.1210      -1.1981      15.1789      36.7675     227.5968    1633.4196      49.9441       0.1490       0.1687       0.2196      10.0000    4626.8433       0.0705      68.3750    3525.0000
 2289.6576    1950.0000       0.5466    1733.3895     700.7748      25.5727      39.1042     216.0000      -0.9604      -1.1209      -1.1980      15.2085      37.0961     227.5968    1627.0059      49.9441       0.1596       0.1806       0.2319      10.0000    4626.7178       0.0651      76.1250    3510.0000
 2289.8100    1950.0000       0.5458    1878.4735     653.3290      23.4815      42.5868     216.0000      -0.9604      -1.1209      -1.1980      15.2642      38.7489     227.5968    1630.9280      49.9441       0.1777       0.2005       0.2524      10.0000    4626.7178       0.0614      68.3750    3495.0000
 2289.9624    1950.0000       0.5446    1950.0000     584.0378      24.5180      40.7864     216.0000      -0.9602      -1.1207      -1.1979      15.2498      36.6089     227.5968    1645.4565      49.9441       0.1609       0.1822       0.2334      10.0000    4626.4561       0.0590      79.1250    3505.0000
 2290.1148    1950.0000       0.5433    1950.0000     517.0796      27.2607      36.6829     216.0000      -0.9560      -1.1162      -1.1931      15.1649      34.7858     227.5968    1642.4373      49.9441       0.1636       0.1847       0.2363      10.0000    4618.6426       0.0636      65.1875    3472.0000
 2290.2672    1950.0000       0.5416    1950.0000     480.5625      23.3353      42.8536     216.0000      -0.9504      -1.1101      -1.1868      15.1630      29.4660     227.3177    1602.0310      49.9441       0.1360       0.1538       0.2042      10.0000    4608.1895       0.0663      81.4375    3500.0000
 2290.4196    1950.0000       0.5392    1950.0000     493.3635      28.8909      34.6130     216.0000      -0.9417      -1.1007      -1.1771      15.2042      27.8409     227.5968    1568.2531      49.9441       0.1107       0.1253       0.1741      10.0000    4592.1919       0.0678      74.7500    3483.0000
 2290.5720    1950.0000       0.5363    1950.0000     568.5229      31.5925      31.6531     216.0000      -0.9300      -1.0880      -1.1639      15.2397      30.8671     227.5968    1570.1990      49.9441       0.1331       0.1505       0.2007      10.0000    4570.4893       0.0674      63.4375    3503.0000
 2290.7244    1950.0000       0.5334    1848.6074     718.2742      37.5584      26.6252     216.0000      -0.9166      -1.0735      -1.1489      15.1831      37.8327     227.0386    1572.5808      49.9441       0.1732       0.1954       0.2473      10.0000    4545.7192       0.0621      78.1250    3498.0000
 2290.8768    1950.0000       0.5310    1637.9904     855.7268      38.6324      25.8850     216.0000      -0.9103      -1.0667      -1.1418      15.0996      39.9996     227.5968    1567.6384      49.9441       0.2191       0.2475       0.2994      10.0000    4534.0059       0.0591      76.1875    3495.0000
 2291.0292    1083.0115       0.5294    1344.8275     731.1178      39.2009      25.5096     216.0000      -0.9133      -1.0699      -1.1452      15.1011      39.9102     227.5968    1545.8662      49.9441       0.2127       0.2411       0.2924      10.0000    4539.5698       0.0615      78.1250    3498.0000
 2291.1816     233.4134       0.5281    1045.2510     432.7763      40.2184      24.8642     216.0000      -0.9202      -1.0774      -1.1530      15.1279      36.2193     227.5968    1544.1757      49.9441       0.1816       0.2053       0.2571      10.0000    4552.3765       0.0678      78.1250    3495.0000
 2291.3340      61.9023       0.5267     789.5824     220.3185      44.0368      22.7083     216.0000      -0.9211      -1.0784      -1.1540      15.1168      37.5736     227.5968    1529.3519      49.9441       0.1440       0.1628       0.2136      10.0000    4554.0313       0.0690      78.1250    3508.0000
 2291.4864      21.4203       0.5246     570.5308     112.5379      35.9755      27.7967     216.0000      -0.9124      -1.0690      -1.1443      15.0896      35.9667     227.5968    1510.3557      49.9441       0.1251       0.1414       0.1912      10.0000    4538.0322       0.0678      68.3750    3523.0000
 2291.6388       8.8699       0.5220     397.7898      72.4677      30.6521      32.6242     216.0000      -0.8960      -1.0512      -1.1258      14.9243      37.8487     227.3177    1488.1101      49.9441       0.1287       0.1456       0.1956      10.0000    4507.6128       0.0637      76.4375    3508.0000
 2291.7912       4.1698       0.5197     264.9282      49.1100      22.6364      44.1766     216.0000      -0.8776      -1.0313      -1.1052      14.9316      36.6479     227.5968    1479.3116      49.9441       0.1536       0.1734       0.2246      10.0000    4473.5361       0.0624      76.8125    3534.0000
 2291.9436       2.1997       0.5188     168.2400      20.9746      14.2669      70.0921     216.0000      -0.8632      -1.0157      -1.0890      15.0054      36.3128     227.3177    1471.5798      49.9441       0.1472       0.1666       0.2175      10.0000    4446.8955       0.0654      76.5000    3539.0000
 2292.0960       1.2877       0.5259     109.2569      15.3998      14.7669      67.7192     216.0000      -0.8538      -1.0056      -1.0785      14.9438      40.6465     227.8759    1471.3507      49.9441       0.1570       0.1777       0.2289      10.0000    4429.5425       0.0650      78.1250    3516.0000
 2292.2484       0.8252       0.5437      78.7901      13.2861      11.7940      84.7892     216.0000      -0.8465      -0.9977      -1.0704      14.9807      44.6000     227.5968    1466.8096      49.9441       0.1804       0.2050       0.2561      10.0000    4416.0874       0.0632      78.1250    3531.0000
 2292.4008       0.5667       0.5918      58.6600      13.5663       8.9833     111.3180     216.0000      -0.8361      -0.9864      -1.0587      14.8776      47.5978     227.8759    1459.8411      49.9441       0.2521       0.2891       0.3370      10.0000    4396.8154       0.0621      81.6875    3509.0000
 2292.5532       0.4227       0.6890      35.7593       4.8557       5.2842     189.2439     216.0000      -0.8223      -0.9715      -1.0432      14.9027      46.6782     228.1550    1457.7012      49.9441       0.4249       0.4833       0.5182      10.0000    4371.2993       0.0685      76.4375    3505.0000
 2292.7056       0.3383       0.8895      71.9522       5.7749       6.2541     159.8951     216.0000      -0.8092      -0.9573      -1.0285      15.0331      47.8529     228.4341    1474.2759      49.9441       0.3961       0.4492       0.4886      10.0000    4346.9883       0.0670      76.5625    3532.0000
 2292.8580       0.2889       1.2936      85.1482      21.9896      23.8410      41.9445     216.0000      -0.8022      -0.9498      -1.0207      15.0366      48.8845     229.2714    1486.6152      49.9441       0.2557       0.2929       0.3408      10.0000    4334.1406       0.0677      72.1875    3535.0000
 2293.0104       0.2595       2.1268     255.9093      39.5083      45.1437      22.1515     216.0000      -0.8030      -0.9507      -1.0216      14.8595      48.3344     229.8296    1479.0151      49.9441       0.2263       0.2584       0.3082      10.0000    4335.6338       0.0720      71.9375    3534.0000
 2293.1628       0.2402       3.9853     444.8114     332.0361     362.6728       2.7573     216.0000      -0.8109      -0.9592      -1.0304      14.7499      50.0950     230.1087    1459.3831      49.9441       0.2253       0.2573       0.3070      10.0000    4350.1533       0.0712      69.5000    3536.0000
 2293.3152       0.2241       8.9809     222.5333     266.5329    1950.0000       0.5000     216.0000      -0.8236      -0.9729      -1.0447      14.7459      49.7783     230.1087    1452.2252      49.9441       0.2323       0.2645       0.3146      10.0000    4373.6841       0.0671      68.3750    3511.0000
 2293.4676       0.2067      29.9398     267.5393      22.7009    1950.0000       0.5000     216.0000      -0.8391      -0.9897      -1.0620      14.7128      49.4875     230.3878    1467.3042      49.9441       0.2431       0.2764       0.3264      10.0000    4402.3696       0.0651      68.3750    3542.0000
 2293.6200       0.1868    1816.3613      25.9551       7.8564      15.8656      63.0294     216.0000      -0.8505      -1.0020      -1.0748      14.7214      45.7062     230.9460    1479.8141      49.9441       0.2594       0.2942       0.3441      10.0000    4423.4473       0.0669      68.3750    3543.0000
 2293.7724       0.1682    1950.0000       9.1861       4.8020       5.9726     167.4300     216.0000      -0.8491      -1.0005      -1.0732      14.7522      45.1082     230.9460    1471.4386      49.9441       0.2313       0.2634       0.3135      10.0000    4420.8091       0.0662      68.3750    3522.0000
 2293.9248       0.1546    1950.0000       5.0419       3.4523       3.1577     316.6850     216.0000      -0.8566      -1.0086      -1.0817      14.7996      43.4370     231.5042    1470.2949      49.9441       0.2187       0.2485       0.2994      10.0000    4434.7739       0.0654      65.1875    3560.0000
 2294.0772       0.1461      61.6947       3.5672       2.8258       2.0610     485.2095     216.0000      -0.8915      -1.0464      -1.1208      14.7935      40.1761     231.7833    1463.8972      49.9441       0.2189       0.2491       0.2997      10.0000    4499.2930       0.0615      68.3750    3533.0000
 2294.2296       0.1481       4.3512       3.3669       2.3447       1.6695     598.9789     216.0000      -0.9336      -1.0920      -1.1680      14.7345      37.6919     232.3415    1412.1163      49.9441       0.2081       0.2362       0.2874      10.0000    4577.2383       0.0653      64.9375    3519.0000
 2294.3820       0.1995       1.6917       6.1139       3.8824       1.8145     551.1206     216.0000      -0.9615      -1.1221      -1.1993      14.6684      32.8626     233.1788    1301.4751      49.9441       0.1865       0.2116       0.2630       9.9941    4628.7998       0.0705      61.5625    3525.0000
 2294.5344       0.2183       1.2008       4.1515       2.3798       1.7039     586.8948     216.0000      -0.9615      -1.1221      -1.1993      14.5413      32.5722     236.5280    1222.4694      49.9441       0.1902       0.2153       0.2670       9.8923    4628.7998       0.0776      58.5625    3487.0000
 2294.6868       0.3235       0.9425       3.8374       2.5857       1.6602     602.3270     216.0000      -0.8209      -0.9699      -1.0416      14.6828      37.9003     235.9698    1088.7563      49.9441       0.2434       0.2721       0.3253       9.4817    4368.6143       0.0691      59.1250    3483.0000
 2294.8392       0.5017       0.6154      10.8072       3.1099       2.3263     429.8669     216.0000      -0.4640      -0.5839      -0.6415      14.7861      44.5363     235.1325     723.2416      49.9441       0.1553       0.1753       0.2266       8.5225    3708.4612       0.0970      58.5625    3519.0000
 2294.9916       0.6567       0.4175       2.6288       1.4560       1.1477     871.2929     216.0000      -0.0613      -0.1482      -0.1899      14.7298      48.3434     235.9698     332.9291      49.9441       0.0747       0.0843       0.1303       7.1941    2963.3538       0.2096      52.1250    3526.0000
 2295.1440       0.6926       0.3401       2.1123       0.4797       0.3852    2596.3271     216.0000       0.1760       0.1085       0.0761      14.6341      47.3698     248.8084      99.5278      49.9441       0.0928       0.1051       0.1524       6.0384    2524.4631       2.5273      53.1875    3536.0000
 2295.2964       0.6679       0.3259       1.7058       0.9025       0.7046    1419.1753     216.0000       0.2065       0.1416       0.1103      14.4867      49.7938     261.0888     131.9005      49.9441       0.1368       0.1546       0.2050       5.4126    2467.9492      10.3585      53.4375    3527.0000
 2295.4488       0.7936       0.3997       5.1942       1.9087       1.4914     670.4968     216.0000       0.1999       0.1344       0.1029      14.5337      55.2843     263.6007     158.8712      49.9441       0.1685       0.1901       0.2419       5.2604    2480.2126       9.9907      52.9375    3495.0000
 2295.6012       1.0290       0.5609       8.5883       6.0719       4.6822     213.5765     216.0000       0.2364       0.1739       0.1438      14.5273      58.2647     266.3917     142.5810      49.9441       0.2322       0.2608       0.3134       5.3005    2412.6753       8.6066      52.3125    3547.0000
 2295.7536       1.4252       0.8582      15.9507       6.0832       6.5420     152.8582     216.0000       0.2571       0.1963       0.1671      14.6489      60.0165     265.5544     139.2140      49.9441       0.1858       0.2104       0.2620       5.4175    2374.3440       7.1335      54.8125    3530.0000
 2295.9060       1.9492       1.3754       5.0645       5.1620       2.2656     441.3774     216.0000       0.2710       0.2114       0.1827      14.6535      53.9256     265.5544     144.6671      49.9441       0.1388       0.1570       0.2075       5.6135    2348.5637       6.8719      51.8125    3495.0000
 2296.0584       3.3045       1.9345       8.2348       9.5653       5.6602     176.6721     216.0000       0.2942       0.2364       0.2086      14.6743      49.0748     266.3917     155.3288      49.9441       0.1071       0.1213       0.1698       5.9311    2305.7837       6.8912      54.6875    3498.0000
 2296.2108       5.4389       4.0447      13.4166      14.9824       5.7932     172.6164     216.0000       0.3335       0.2790       0.2527      14.6010      45.2007     275.6021     165.8895      49.9441       0.0977       0.1106       0.1585       6.3360    2232.9956       6.7584      48.8125    3500.0000
 2296.3632      14.3969       9.5100      18.5453      22.3344       6.8392     146.2149     216.0000       0.4136       0.3656       0.3426      14.4531      46.6672     301.8375     136.1299      49.9441       0.1356       0.1534       0.2038       6.7154    2084.7600       3.9887      50.0625    3486.0000
 2296.5156      57.5406      22.0045      37.5344      75.7450      13.4660      74.2611     216.0000       0.4543       0.4096       0.3881      14.4891      51.2905     345.6563      94.5178      49.9441       0.2108       0.2376       0.2899       6.7786    2009.6273       2.6374      52.3750    3486.0000
 2296.6680      91.6497      43.3902     211.9251     144.2946      30.0864      33.2376     216.0000       0.4731       0.4299       0.4092      14.4086      49.7671     342.3071      41.5125      49.9441       0.2446       0.2747       0.3271       6.5642    1974.8141       1.9800      53.8750    3515.0000
 2296.8204     101.5247      48.0987      73.0067      99.2665      39.1829      25.5214     216.0000       0.4252       0.3781       0.3555      14.6377      51.2669     360.1695      19.1736      49.9441       0.1974       0.2222       0.2747       6.0684    2063.3682       2.0073      55.6250    3517.0000
 2296.9728      51.6846      34.0367      71.0821     177.9998      56.8651      17.5855     216.0000       0.3330       0.2784       0.2521      14.7264      51.9591     364.9142      50.3137      49.9441       0.1322       0.1495       0.1997       5.7316    2233.9785       3.1471      58.1250    3519.0000
 2297.1252      43.2570      30.5199      74.9334     307.8604      58.6820      17.0410     216.0000       0.2729       0.2134       0.1848      14.6557      54.7088     383.8930      97.6682      49.9441       0.1345       0.1521       0.2024       5.6877    2345.0562       5.4590      55.6875    3495.0000
 2297.2776      52.2870      32.3367      89.5148     388.0269     119.0994       8.3963     216.0000       0.2500       0.1886       0.1591      14.4644      53.6023     312.4433     168.5188      49.9441       0.1373       0.1554       0.2058       6.0638    2387.5366      12.1084      48.8125    3501.0000
 2297.4300      50.6922      41.7137      78.1875     327.9430     150.1723       6.6590     216.0000       0.2713       0.2116       0.1830      14.4327      49.3881     311.6060     222.9033      49.9441       0.1490       0.1688       0.2196       6.5148    2348.1113      11.9055      51.3125    3488.0000
 2297.5824      81.4137      46.6578     115.6953     308.7495     125.3877       7.9753     216.0000       0.2975       0.2399       0.2123      14.5022      48.6382     364.9142     243.8312      49.9441       0.1431       0.1617       0.2124       6.8857    2299.7109      12.5396      53.6250    3496.0000
 2297.7348     152.9289      91.0490     190.3801     430.1416     161.2232       6.2026     216.0000       0.3511       0.2979       0.2724      14.5879      51.0915     356.5412     195.1792      49.9441       0.1383       0.1568       0.2072       7.1040    2200.5134       5.8686      51.6875    3504.0000
 2297.8872     177.8734      88.8946     555.8011     788.6726     439.5129       2.2752     216.0000       0.4135       0.3654       0.3424      14.5244      54.7161     378.0319     107.9147      49.9441       0.1759       0.1990       0.2506       7.1649    2085.1160       3.1731      48.8125    3485.0000
 2298.0396     147.9472      72.9232     909.3118    1112.7549     215.1239       4.6485     216.0000       0.4304       0.3837       0.3613      14.4142      57.1128     363.2396      59.3718      49.9441       0.2792       0.3147       0.3651       7.1231    2053.8293       2.9544      46.1250    3499.0000
 2298.1920     117.7794      49.9680     248.3315     344.0225     281.4314       3.5533     216.0000       0.4047       0.3559       0.3325      14.5274      56.8610     386.6840      82.4237      49.9441       0.2751       0.3108       0.3609       7.0519    2101.3525       3.1723      38.0625    3488.0000
 2298.3444      61.9328      35.7247     160.7179     222.6719      80.5311      12.4176     216.0000       0.3903       0.3404       0.3164      14.6259      55.5071     405.6628     131.0464      49.9441       0.2311       0.2608       0.3126       7.1060    2127.9585       3.6462      25.6250    3483.0000
 2298.4968      46.8141      28.7267     118.4803     162.1808      91.4115      10.9395     216.0000       0.4046       0.3558       0.3324      14.5840      54.4854     357.9367     154.0836      49.9441       0.1567       0.1772       0.2284       7.1676    2101.5569       2.8042       9.7500    3495.0000
 2298.6492      74.5927      29.7277     121.7535     136.4595     102.7779       9.7297     216.0000       0.4102       0.3619       0.3387      14.4998      54.5151     361.5650     158.9606      49.9441       0.1175       0.1330       0.1823       7.1200    2091.0730       2.6364       2.7500    3486.0000
 2298.8016      68.7048      42.4260     109.3560     107.7904      96.3024      10.3840     216.0000       0.4073       0.3588       0.3354      14.4950      55.5293     357.0994     150.6001      49.9441       0.1212       0.1372       0.1867       6.9577    2096.5215       2.7341      -3.7500    3508.0000
 2298.9540      48.1236      37.2925      99.0383      90.5237      86.1014      11.6142     216.0000       0.3758       0.3247       0.3001      14.5223      54.0294     361.5650     174.4359      49.9441       0.1526       0.1723       0.2235       6.8038    2154.8008       3.0066      -9.9375    3530.0000
 2299.1064      46.5544      40.6006     116.2425      95.4411      90.5059      11.0490     216.0000       0.3564       0.3037       0.2784      14.6504      51.4227     363.9839     201.2035      49.9441       0.1471       0.1663       0.2172       6.7530    2190.6399       4.0258     -16.8125    3501.0000
 2299.2588      39.2144      57.3376     128.4153     156.0459     129.1959       7.7402     216.0000       0.3689       0.3173       0.2924      14.6759      49.6615     369.9380     202.1854      49.9441       0.1381       0.1563       0.2068       6.7864    2167.4661       4.7086     -20.7500    3507.0000
 2299.4112      48.8288      73.5850     174.2583     104.7130      96.7996      10.3306     216.0000       0.3847       0.3344       0.3102      14.5619      51.8078     366.0306     176.1892      49.9441       0.1606       0.1814       0.2328       6.7609    2138.2522       4.1578     -24.2500    3498.0000
 2299.5636      47.3961      86.1877     270.2149     203.3076     111.0696       9.0034     216.0000       0.3802       0.3295       0.3051      14.6041      59.1640     359.8904     144.2969      49.9441       0.1946       0.2190       0.2715       6.6008    2146.6216       3.4533     -29.1875    3464.0000
 2299.7160      34.0927      62.2596     173.8351     172.4506     150.8193       6.6304     216.0000       0.3300       0.2751       0.2488      14.4548      62.3897     356.5412     153.0657      49.9441       0.2284       0.2549       0.3085       6.3321    2239.5078       3.6448     -29.3125    3487.0000
 2299.8684      31.2287      35.0992      96.8123     122.4871      41.7856      23.9317     216.0000       0.2658       0.2057       0.1768      14.5904      66.6296     338.1205     202.7073      49.9441       0.1374       0.1552       0.2056       6.1127    2358.2197       5.5519     -29.3125    3460.0000
 2300.0208      45.6763      33.6512     108.8031     181.2200      85.1837      11.7393     216.0000       0.1974       0.1317       0.1001      14.5570      67.5045     301.2793     263.6266      49.9441       0.0657       0.0739       0.1190       5.9287    2484.8760       8.7491     -30.4375    3446.0000
 2300.1732      49.0405      43.1313     140.1858     226.9370     128.2266       7.7987     216.0000       0.1416       0.0713       0.0376      14.4591      69.4053     312.7224     300.8699      49.9441       0.0903       0.1024       0.1493       5.7282    2588.0039      19.0519     -33.8750    3475.0000
 2300.3256      57.9654      41.8568     129.7007     247.2076     157.9993       6.3291     216.0000       0.1151       0.0427       0.0078      14.5068      68.5440     269.4618     292.7215      49.9441       0.1235       0.1401       0.1891       5.4962    2637.0684      18.6401     -33.1250    3451.0000
 2300.4780      32.0067      35.7453     116.6916     248.9111     178.5142       5.6018     216.0000       0.1140       0.0415       0.0066      14.5712      67.6427     276.4393     261.8596      49.9441       0.0842       0.0962       0.1419       5.3214    2639.0947      17.2113     -34.8125    3523.0000
 2300.6304      31.8849      31.4149      73.2264     170.5095     192.1505       5.2043     216.0000       0.1243       0.0526       0.0182      14.5946      67.6460     288.4407     243.2592      49.9441       0.0513       0.0585       0.1008       5.2869    2619.9844      17.5630     -30.7500    3517.0000
 2300.7828      27.6343      32.7060      62.4842     165.8821     101.9073       9.8128     216.0000       0.1332       0.0623       0.0282      14.6523      63.9960     275.0439     267.0786      49.9441       0.0687       0.0789       0.1227       5.4085    2603.4951      25.6746     -34.5000    3517.0000
 2300.9352      37.2857      72.1880     142.5431     221.0401     148.2333       6.7461     216.0000       0.1348       0.0640       0.0300      14.6521      62.1720     275.8812     335.0432      49.9441       0.0774       0.0890       0.1335       5.6348    2600.5352      37.0265     -34.5000    3515.0000
 2301.0876      49.6555     114.5301     259.4452     383.7101     290.9309       3.4372     216.0000       0.1584       0.0895       0.0564      14.6545      63.4200     283.4169     373.7221      49.9441       0.0770       0.0884       0.1330       5.8900    2557.0186      25.3676     -30.1250    3501.0000
 2301.2400      89.1629     168.9633     760.1732     310.5156     224.7949       4.4485     216.0000       0.1850       0.1183       0.0863      14.6211      73.5928     283.9751     354.4898      49.9441       0.1121       0.1274       0.1756       5.9946    2507.6763      10.6990     -29.3125    3550.0000
 2301.3924     107.2986     146.2643     348.9120     155.7263     165.0795       6.0577     216.0000       0.1967       0.1309       0.0993      14.5015      74.8441     278.3931     296.7024      49.9441       0.1309       0.1482       0.1978       5.9014    2486.1887       9.2175     -29.3125    3574.0000
 2301.5448      85.3857      89.1276     154.2633      59.3928      55.1068      18.1466     216.0000       0.1818       0.1148       0.0826      14.3990      75.0388     281.5562     248.8098      49.9441       0.0888       0.1006       0.1476       5.6577    2513.6787      11.9995     -28.6875    3488.0000
 2301.6972      65.8290      66.0101      97.4200      34.9799      38.5353      25.9503     216.0000       0.1640       0.0956       0.0627      14.3924      68.1406     302.9539     224.4844      49.9441       0.0730       0.0826       0.1281       5.4540    2546.5244      29.8652     -27.8125    3530.0000
 2301.8496      83.8193      87.0354     101.3419      57.6942      51.5985      19.3804     216.0000       0.1782       0.1109       0.0786      14.5575      68.2657     278.1140     198.8127      49.9441       0.1169       0.1323       0.1815       5.3965    2520.3821      28.7340     -29.0625    3581.0000
 2302.0020      70.9095     136.4716     249.2518     101.7886      81.8680      12.2148     216.0000       0.2238       0.1602       0.1297      14.6836      67.0436     293.1854     167.1090      49.9441       0.1274       0.1444       0.1936       5.4349    2436.0029       9.1515     -25.7500    3557.0000
 2302.1544      59.9571     150.4612     314.7322     193.2198     116.3288       8.5963     216.0000       0.2339       0.1711       0.1410      14.5831      71.1432     272.8111     161.9439      49.9441       0.0946       0.1079       0.1545       5.4320    2417.3726       7.5842     -23.1250    3591.0000
 2302.3068      56.4117     128.1298     205.7762     125.0604     104.2428       9.5930     216.0000       0.2274       0.1642       0.1338      14.4031      73.7710     263.6007     161.2403      49.9441       0.0831       0.0951       0.1405       5.3766    2429.2817       7.6766     -20.8125    3605.0000
 2302.4592      47.4261      69.3049     128.6795     136.5529      52.8859      18.9086     216.0000       0.2010       0.1356       0.1042      14.4032      75.7708     283.9751     168.8163      49.9441       0.1126       0.1280       0.1762       5.3219    2478.0791      13.3335     -19.5625    3532.0000
 2302.6116      57.7430      42.2276      83.4031      67.9872      53.8618      18.5660     216.0000       0.2205       0.1567       0.1260      14.4689      72.6755     275.8812     150.5921      49.9441       0.1291       0.1461       0.1957       5.3669    2442.1133      15.6459     -19.5625    3519.0000
 2302.7640      53.0232      67.6080     189.2698     111.2228     113.2586       8.8294     216.0000       0.2490       0.1875       0.1580      14.5385      73.3965     270.5782     145.4010      49.9441       0.0951       0.1078       0.1552       5.5251    2389.3291      15.9971     -17.6250    3530.0000
 2302.9164      52.3747      69.6537     191.6432     177.4135     118.4902       8.4395     216.0000       0.2680       0.2081       0.1793      14.4617      74.3964     271.9737     156.7616      49.9441       0.0988       0.1121       0.1597       5.7215    2354.1409      15.1873     -17.2500    3577.0000
 2303.0688      45.7107      54.2200     208.9562     234.4759     159.8041       6.2577     216.0000       0.2688       0.2089       0.1801      14.3655      74.6433     264.4380     189.1971      49.9441       0.1050       0.1190       0.1672       5.8975    2352.7883      10.5142     -15.3750    3618.0000
 2303.2212      40.0412      48.8862     198.5297     305.9525     203.3339       4.9180     216.0000       0.2948       0.2370       0.2093      14.2828      68.6139     266.6708     202.3006      49.9441       0.1105       0.1252       0.1738       6.0737    2304.6899       9.1425     -12.9375    3659.0000
 2303.3736      37.2381      46.0445     247.6624     417.7684     208.6474       4.7928     216.0000       0.3176       0.2617       0.2349      14.2280      65.7657     278.1140     200.8264      49.9441       0.0917       0.1040       0.1511       6.1340    2262.4341       6.7750     -15.0625    3767.0000
 2303.5260      39.7418      52.0922     328.1299     569.4434     231.7108       4.3157     216.0000       0.3048       0.2479       0.2206      14.2878      63.7396     314.6761     175.1349      49.9441       0.0870       0.0990       0.1453       5.9115    2286.0281       5.7597     -17.8125    3702.0000
 2303.6784      46.3632      65.4526     437.1976     578.2201     203.1730       4.9219     216.0000       0.2503       0.1889       0.1595      14.3774      65.3944     305.1867     124.1248      49.9441       0.1021       0.1161       0.1636       5.2853    2386.9014       5.1281     -17.4375    3618.0000
 2303.8308      52.4283      84.5488    1273.2189    1083.3378     340.4627       2.9372     216.0000       0.1752       0.1076       0.0752      14.3320      62.5164     285.9287      69.2041      49.9441       0.1173       0.1331       0.1817       4.4348    2525.9285       8.1293     -18.1250    3570.0000
 2303.9832      56.0018     103.9485    1846.9427     776.5397     191.8350       5.2128     216.0000       0.1486       0.0789       0.0454      14.2684      66.7660     279.5095      27.2715      49.9441       0.1479       0.1673       0.2175       3.9526    2575.0889      19.8632     -19.5625    3567.0000
 2304.1356      55.1917     110.5830    1123.3608     173.8622      89.5571      11.1661     216.0000       0.1324       0.0613       0.0272      14.2343      65.2485     273.0901      68.0349      49.9441       0.1085       0.1240       0.1713       4.1182    2605.1309     132.6003     -31.6250    3643.0000
 2304.2880      46.8537      90.9937     575.5943     169.4178      75.1671      13.3037     216.0000       0.1142       0.0417       0.0068      14.0663      63.2255     270.2061     195.5285      49.9441       0.0544       0.0627       0.1048       4.8198    2638.7544     116.3112     -29.3125    3698.0000
 2304.4404      43.7309      96.4507     626.9822     143.8014      89.9412      11.1184     216.0000       0.0824       0.0073      -0.0288      14.1829      57.7261     270.5782     344.6119      49.9441       0.0367       0.0425       0.0822       5.5026    2697.5618     111.9497     -26.9375    3746.0000
 2304.5928      42.1062      85.4052     452.5472     108.1881      81.4686      12.2747     216.0000       0.0719      -0.0041      -0.0406      14.6707      55.6396     270.2991     418.1125      49.9441       0.0383       0.0442       0.0842       5.9395    2717.0605      71.9577     -27.1875    3798.0000
 2304.7452      36.7678      74.0711     314.1606      73.5691      69.8273      14.3210     216.0000       0.0885       0.0138      -0.0220      14.8333      58.7642     273.3693     392.6559      49.9441       0.0624       0.0721       0.1148       6.1543    2686.3572      21.1248     -26.1875    3781.0000
 2304.8976      35.0053      56.5904     201.8685     112.5090      70.9453      14.0954     216.0000       0.1558       0.0867       0.0535      14.1727      59.2642     281.4631     302.2158      49.9441       0.1013       0.1162       0.1626       6.3194    2561.7346      19.7625     -27.5000    3701.0000
 2305.0500      27.4697      34.8719     170.3260     104.5764     100.8643       9.9143     216.0000       0.2179       0.1539       0.1231      14.1186      60.7699     266.3917     250.5207      49.9441       0.0820       0.0938       0.1391       6.4929    2446.8696      10.8962     -25.2500    3751.0000
 2305.2024      24.8347      28.3504      72.8955      55.8905      47.4366      21.0808     216.0000       0.3260       0.2709       0.2444      13.9819      58.1452     280.6259     200.6538      49.9441       0.0596       0.0685       0.1114       6.7818    2246.8147       6.5238     -23.0000    3726.0000
 2305.3548      18.8592      20.8954      89.2799     115.4162      71.0571      14.0732     216.0000       0.4048       0.3561       0.3327      13.9564      55.6658     292.3481     168.4243      49.9441       0.0574       0.0669       0.1087       7.0808    2101.1145       3.1167     -30.7500    3792.0000
 2305.5072      16.1106      19.5731      85.4317     145.5142      96.3131      10.3828     216.0000       0.4550       0.4104       0.3890      13.9850      56.7878     310.3966     109.5520      49.9441       0.0605       0.0703       0.1126       7.1524    2008.2035       2.3508     -28.6250    3793.0000
 2305.6596      15.3557      18.6035      81.1947     180.4819     134.0921       7.4576     216.0000       0.4543       0.4097       0.3882      13.8900      58.2645     361.5650      68.0019      49.9441       0.0691       0.0795       0.1233       7.0318    2009.4677       2.1810     -29.3125    3742.0000
 2305.8120      13.6731      21.7311      56.1276     218.9602     200.2036       4.9949     216.0000       0.4420       0.3963       0.3743      13.8529      66.5231     367.7052      38.2916      49.9441       0.0971       0.1100       0.1577       6.8930    2032.3796       2.2561     -29.1875    3696.0000
 2305.9644      19.4853      29.8117      93.1380     201.4541     217.4118       4.5996     216.0000       0.4041       0.3553       0.3319      13.8332      69.9016     368.2634      18.3294      49.9441       0.2684       0.2994       0.3524       6.4128    2102.3855       2.4867     -29.3125    3688.0000
 2306.1168      25.8256      46.8004      96.1825     323.7707     427.7696       2.3377     216.0000       0.3021       0.2450       0.2175      13.8506      75.7991     368.5425      21.9364      49.9441       0.4065       0.4471       0.4961       5.6205    2291.1130       3.9257     -29.3125    3723.0000
 2306.2692      28.9676      68.3921     191.0106     442.9066     993.8386       1.0062     216.0000       0.2188       0.1548       0.1241      13.8216      75.0194     385.8467      14.8373      49.9441       0.1592       0.1804       0.2315       4.7018    2445.2092       8.8230     -25.1250    3727.0000
 2306.4216      29.0112      72.4126     266.2093     596.7863    1707.4716       0.5857     216.0000       0.1815       0.1145       0.0823      13.7649      76.6482     291.7899      14.2326      49.9441       0.0814       0.0919       0.1387       4.2532    2514.2625      12.3539     -33.1875    3662.0000
 2306.5740      22.8517      57.2150     221.4188     269.5303     317.8222       3.1464     216.0000       0.2125       0.1480       0.1171      13.9583      74.8012     290.6735      -1.4608      49.9441       0.0857       0.0969       0.1439       4.2194    2456.8455      11.1242     -34.5625    3674.0000
 2306.7264      19.4190      35.3270      70.1616     141.1733     218.1697       4.5836     216.0000       0.2196       0.1558       0.1251      13.8519      76.0815     307.7916      18.0097      49.9441       0.1442       0.1628       0.2135       4.3875    2443.6631      15.8148     -31.6250    3686.0000
 2306.8788      23.4496      45.4502     140.9999     139.6591     151.3158       6.6087     216.0000       0.1965       0.1307       0.0991      13.7979      76.9249     324.7237      79.8755      49.9441       0.2166       0.2422       0.2955       4.6679    2486.4509      55.0545     -31.4375    3741.0000
 2307.0312      28.4723      62.1405     194.7876     232.3299     227.6430       4.3928     216.0000       0.1629       0.0944       0.0615      13.6943      79.8967     335.3295     147.4950      49.9441       0.1417       0.1604       0.2110       4.8710    2548.5808      35.9248     -31.0625    3724.0000
 2307.1836      32.4239      68.6529     267.3152     279.5667     169.1393       5.9123     216.0000       0.1462       0.0763       0.0427      13.7158      79.1664     292.9063     168.0303      49.9441       0.1319       0.1496       0.1997       4.8419    2579.5828      20.5194     -30.0000    3684.0000
 2307.3360      35.9958      76.4128     279.9362     215.7734     139.3329       7.1771     216.0000       0.1524       0.0830       0.0496      13.6140      75.4168     287.0452     130.5645      49.9441       0.1536       0.1733       0.2246       4.5454    2568.1375      20.1543     -29.3125    3674.0000
 2307.4884      35.0212      69.6447     348.4091     228.2568     127.4197       7.8481     216.0000       0.1661       0.0978       0.0650      13.6190      67.9403     286.7661      88.9776      49.9441       0.1372       0.1555       0.2051       4.2125    2542.7239      29.0321     -30.3125    3700.0000
 2307.6408      38.2178      83.4466     484.3650     317.3427     143.3412       6.9764     216.0000       0.1803       0.1132       0.0810      13.8346      59.9061     287.3243      69.7820      49.9441       0.0729       0.0866       0.1283       4.0026    2516.3726      45.6997     -36.6875    3788.0000
 2307.7932      41.6847     105.0052     581.5511     383.3943     163.6742       6.1097     216.0000       0.1866       0.1200       0.0880      13.7039      52.9248     286.7661      61.6980      49.9441       0.0080       0.0109       0.0447       3.9612    2504.8489      40.0584     -33.5000    3750.0000
 2307.9456      43.5168     122.9369    1302.9099     685.1850     311.3662       3.2117     216.0000       0.1843       0.1175       0.0854      13.4913      48.5277     287.8825      46.6845      49.9441       0.0058       0.0087       0.0417       3.9569    2509.0537      29.4835     -33.2500    3679.0000
 2308.0980      45.0100     126.7581     866.8804     377.6442     139.7131       7.1575     216.0000       0.1817       0.1147       0.0825      13.4746      48.8951     274.2066      40.1344      49.9441       0.0344       0.0424       0.0796       4.0772    2513.8323      33.1787     -33.7500    3663.0000
 2308.2504      41.5421     100.8361     286.2008     183.9701      95.9907      10.4177     216.0000       0.1768       0.1094       0.0770      13.4102      53.6265     286.7661      73.9853      49.9441       0.0316       0.0386       0.0759       4.4083    2523.0068      38.2171     -34.0625    3621.0000
 2308.4028      45.6057     114.1620     364.6396     403.1911     103.2279       9.6873     216.0000       0.1618       0.0932       0.0602      13.3923      60.2170     294.3018     134.8853      49.9441       0.0446       0.0528       0.0925       4.8906    2550.6772      75.1900     -31.3125    3693.0000
 2308.5552      53.9165     160.9548     504.3273     343.9104     153.3452       6.5212     216.0000       0.1203       0.0483       0.0137      13.3461      61.6871     295.9764     202.8537      49.9441       0.0886       0.1019       0.1472       5.3018    2627.3892      69.4687     -39.0625    3697.0000
 2308.7076      59.1576     158.4154     612.6321     301.0124     225.6852       4.4310     216.0000       0.1006       0.0270      -0.0084      13.5238      60.6181     284.7194     223.5212      49.9441       0.1018       0.1160       0.1632       5.5172    2663.8376      71.5844     -44.3125    3691.0000
 2308.8600      68.3570     142.3884     473.4294     228.3153     185.4276       5.3929     216.0000       0.0926       0.0183      -0.0174      13.5487      60.0146     275.3229     212.0790      49.9441       0.0897       0.1021       0.1486       5.5333    2678.7598      49.7192     -42.0625    3709.0000
 2309.0124      69.4369     193.0692     541.0847     185.9969     198.1511       5.0467     216.0000       0.1057       0.0325      -0.0027      13.3864      60.9119     266.3917     162.5452      49.9441       0.0932       0.1060       0.1528       5.3760    2654.4126      22.8680     -44.0625    3803.0000
 2309.1648      72.6272     306.5296     513.8640     143.9611     257.0282       3.8906     216.0000       0.1120       0.0393       0.0044      13.3337      61.2398     272.5320     101.8846      49.9441       0.0980       0.1113       0.1587       5.0604    2642.7766      19.3718     -44.8750    3969.0000
 2309.3172      83.7103     298.7178     869.1151     137.6654     183.1821       5.4590     216.0000       0.1182       0.0460       0.0114      13.2058      60.3773     270.5782      44.9791      49.9441       0.1099       0.1247       0.1730       4.7181    2631.2720      24.1051     -44.1875    3960.0000
 2309.4696      88.4062     182.7446     372.0069     194.2865     255.1702       3.9190     216.0000       0.1108       0.0380       0.0030      13.2070      58.4745     264.7171      30.8580      49.9441       0.1083       0.1229       0.1711       4.6581    2644.9893      58.6260     -44.5000    3929.0000
 2309.6220      64.8369     143.4530     151.8125      73.0458     116.6639       8.5716     216.0000       0.1243       0.0526       0.0181      13.3300      59.2659     260.5306      43.8237      49.9441       0.0999       0.1134       0.1609       4.8935    2620.0718     130.2117     -48.6250    3860.0000
 2309.7744      47.9119      69.9766     103.9125     139.9152     111.7506       8.9485     216.0000       0.1443       0.0742       0.0406      13.4234      56.9118     251.3203      69.6306      49.9441       0.1012       0.1148       0.1625       5.2861    2583.0469      18.4968     -48.8125    3775.0000
 2309.9268      66.1191     103.6829     211.8066     202.7217     245.0578       4.0807     216.0000       0.1508       0.0813       0.0479      13.2838      58.8146     252.4367      85.0751      49.9441       0.0980       0.1111       0.1588       5.4591    2570.9438      11.7746     -47.5625    3724.0000
 2310.0792      97.1664     196.0695     320.1513     302.1611     320.1490       3.1235     216.0000       0.1202       0.0482       0.0136      13.1589      60.2304     262.4843      75.3894      49.9441       0.0912       0.1045       0.1504       5.3375    2627.5525      11.6017     -48.1250    3673.0000
 2310.2316     102.9589     249.7579    1115.7531    1440.4043    1230.0996       0.8129     216.0000       0.0842       0.0092      -0.0268      13.1396      62.9594     248.5293      49.6027      49.9441       0.0792       0.0927       0.1359       5.0256    2694.1875      34.2559     -48.8125    3740.0000
 2310.3840     105.7725     373.5335    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.0724      -0.0035      -0.0400      13.2999      61.4595     247.5060      15.8944      49.9441       0.0288       0.0348       0.0722       4.7351    2716.0359     301.8412     -48.8125    3908.0000
 2310.5364     105.6932     542.1162    1950.0000    1950.0000    1950.0000       0.5003     216.0000       0.0716      -0.0045      -0.0410      13.0649      57.3938     246.8547       2.8808      49.9441       0.0308       0.0371       0.0748       4.5445    2717.6250     485.0725     -50.7500    3882.0000
 2310.6888     104.7800     747.0408    1626.9022    1510.4838    1243.1343       0.8044     216.0000       0.0754      -0.0003      -0.0367      13.0469      57.3232     247.1338      -0.6731      49.9441       0.0516       0.0609       0.1014       4.4867    2710.4858     634.8347     -51.0000    3760.0000
 2310.8412     104.9903     803.2418    1434.5415     848.3115     551.7341       1.8125     216.0000       0.0756      -0.0001      -0.0364      13.0328      58.5731     247.4129      -2.3782      49.9441       0.0469       0.0556       0.0955       4.4473    2710.1272     863.2477     -51.1875    3784.0000
 2310.9936     106.4105     961.5250    1558.3826     774.2879     643.9096       1.5530     216.0000       0.0748      -0.0010      -0.0374      12.9711      58.4231     248.2502      -4.0679      49.9441       0.0406       0.0484       0.0874       4.4185    2711.6416    1027.9508     -51.3125    3868.0000
 2311.1460     108.9873    1121.4374    1950.0000     861.3776     562.5759       1.7775     216.0000       0.0702      -0.0059      -0.0425      12.9007      56.2160     247.6920      -3.5071      49.9441       0.0484       0.0576       0.0974       4.3816    2720.1418    1037.5372     -50.6250    3903.0000
 2311.2984     107.5649    1101.3573     766.9311     538.2902     361.3769       2.7672     216.0000       0.0708      -0.0053      -0.0418      12.9475      54.5911     247.1338      -4.4744      49.9441       0.0502       0.0596       0.0997       4.3733    2719.0015    1023.0318     -52.8125    3838.0000
 2311.4508     107.8987     547.7858     619.4662     386.8971     280.4229       3.5660     216.0000       0.0755      -0.0002      -0.0366      12.9888      58.6907     245.7383      -6.9616      49.9441       0.0475       0.0563       0.0962       4.3770    2710.3975    1141.3917     -48.8125    3795.0000
 2311.6032     118.1641     685.0284    1397.9907     539.9515     350.9402       2.8495     216.0000       0.0779       0.0024      -0.0339      13.0652      60.7184     242.6682      -8.9571      49.9441       0.0462       0.0548       0.0946       4.3510    2705.9033    1229.5194     -54.6250    3714.0000
 2311.7556     134.4182    1126.8192    1901.7046     699.0354     421.4335       2.3729     216.0000       0.0768       0.0012      -0.0352      13.2034      60.7868     242.1100      -9.0539      49.9441       0.0488       0.0578       0.0979       4.3034    2708.0051    1002.8306     -54.8125    3698.0000
 2311.9080     141.3165    1164.4629    1950.0000     677.0931     426.4211       2.3451     216.0000       0.0725      -0.0034      -0.0399      12.9021      60.2112     242.1100      -6.4843      49.9441       0.0493       0.0586       0.0985       4.2503    2715.8198     949.7025     -54.5625    3766.0000
 2312.0604     144.5169    1061.8447    1910.3777     454.6606     353.3878       2.8298     216.0000       0.0732      -0.0027      -0.0391      12.1660      60.8327     242.1100      -5.1939      49.9441       0.0425       0.0508       0.0899       4.2232    2714.5879     901.6389     -53.5000    3829.0000
 2312.2128     143.8713     903.6039    1881.0149     447.2501     347.8353       2.8749     216.0000       0.0812       0.0060      -0.0302      12.0040      64.5395     242.6682      -6.3975      49.9441       0.0459       0.0546       0.0942       4.2453    2699.8247    1127.8407     -54.6875    3927.0000
 2312.3652     140.7270     767.5523    1787.8724     428.5946     327.1673       3.0565     216.0000       0.0889       0.0143      -0.0215      12.7335      64.1636     243.2264      -8.3756      49.9441       0.0539       0.0633       0.1043       4.2594    2685.4807    1053.2832     -54.0000    3962.0000
 2312.5176     136.1000     653.3276    1859.6940     411.4085     351.3044       2.8465     216.0000       0.0911       0.0167      -0.0191      12.8476      64.6919     243.2264      -8.0872      49.9441       0.0588       0.0686       0.1104       4.2544    2681.5269     960.1661     -56.3750    3911.0000
 2312.6700     129.5397     551.8555    1735.4817     488.5871     352.9059       2.8336     216.0000       0.0878       0.0131      -0.0228      12.9979      61.2171     243.7846      -7.2265      49.9441       0.0581       0.0678       0.1096       4.1801    2687.5889     891.6269     -57.7500    3784.0000
 2312.8224     121.2602     481.2272    1652.4390     443.7766     312.0549       3.2046     216.0000       0.0881       0.0135      -0.0224      13.0255      62.8657     244.0637      -6.9337      49.9441       0.0559       0.0653       0.1068       4.1172    2686.9592     799.6635     -53.9375    3744.0000
 2312.9748     111.6166     413.8029    1572.2795     409.1370     263.2412       3.7988     216.0000       0.0908       0.0164      -0.0194      12.8758      58.5912     244.3428      -6.4125      49.9441       0.0574       0.0672       0.1087       4.0509    2681.9941     781.5298     -58.6250    3647.0000
 2313.1272     100.0181     338.9812    1140.9353     326.7226     194.0853       5.1524     216.0000       0.0942       0.0200      -0.0156      12.6905      60.1890     244.9010      -4.8797      49.9441       0.0566       0.0665       0.1078       3.9921    2675.8035     739.8002     -53.4375    3677.0000
 2313.2796      92.9046     345.0139    1177.1658     278.2263     167.3957       5.9739     216.0000       0.0959       0.0219      -0.0137      12.6456      56.6839     246.0174      -4.0426      49.9441       0.0519       0.0617       0.1018       3.9225    2672.5227     757.4607     -54.1250    3851.0000
 2313.4320      88.8612     357.5386    1497.1183     487.2405     241.1622       4.1466     216.0000       0.0962       0.0222      -0.0134      12.6006      57.3295     245.4592      -4.6082      49.9441       0.0368       0.0447       0.0826       3.8556    2672.0642     781.2878     -48.8125    3815.0000
 2313.5844      85.1321     372.7397    1868.6350     859.0831     294.9691       3.3902     216.0000       0.0913       0.0169      -0.0188      12.6505      55.8478     245.4592      -3.8800      49.9441       0.0341       0.0417       0.0792       3.7640    2681.0347     740.5605     -50.6875    3800.0000
 2313.7368      79.5544     325.1972    1950.0000    1693.5920     331.2154       3.0192     216.0000       0.0973       0.0234      -0.0121      12.7362      51.8238     245.4592      -3.3913      49.9441       0.0384       0.0467       0.0847       3.7343    2670.0264     719.8934     -55.8750    3670.0000
 2313.8892      73.6625     262.8093    1886.0752    1177.5450     329.5525       3.0344     216.0000       0.1243       0.0526       0.0181      12.6405      50.8629     246.0174      -2.2564      49.9441       0.0395       0.0477       0.0861       3.7591    2620.1023     707.5486     -52.1250    3709.0000
 2314.0416      67.8698     212.7259    1929.7443    1340.0317     264.1074       3.7863     216.0000       0.1535       0.0842       0.0509      12.2857      48.3405     244.9010      24.4431      49.9441       0.0365       0.0444       0.0823       3.9455    2566.0518     622.2883     -49.7500    3686.0000
 2314.1940      62.6731     181.0929    1950.0000    1658.3584     353.1158       2.8319     216.0000       0.1579       0.0889       0.0558      12.3235      47.9549     257.7396      78.7208      49.9441       0.0321       0.0398       0.0766       4.1830    2557.9285     600.8239     -48.8125    3615.0000
 2314.3464      58.3245     164.3204    1950.0000    1864.7053     430.0128       2.3255     216.0000       0.1449       0.0749       0.0413      12.4030      48.9159     259.9724     131.0739      49.9441       0.0326       0.0412       0.0775       4.4059    2581.9297     565.1210     -48.8125    3660.0000
 2314.4988      54.8082     157.8155    1950.0000    1950.0000     462.9804       2.1599     216.0000       0.1333       0.0624       0.0283      12.4924      50.3939     260.2515     152.2725      49.9441       0.0308       0.0398       0.0753       4.4964    2603.3406     628.4341     -48.8125    3596.0000
 2314.6512      51.9615     158.3782    1950.0000    1950.0000     481.2374       2.0780     216.0000       0.1344       0.0636       0.0295      12.5995      48.0266     260.2515     144.3560      49.9441       0.0177       0.0238       0.0580       4.4946    2601.3071     630.9689     -48.8125    3661.0000
 2314.8036      49.6167     164.7500    1950.0000    1950.0000     419.2505       2.3852     216.0000       0.1312       0.0600       0.0259      12.5204      43.9326     260.1585     140.2500      49.9441       0.0209       0.0277       0.0622       4.4761    2607.3296     631.2927     -47.0000    3637.0000
 2314.9560      47.6761     177.3291    1950.0000    1950.0000     365.3187       2.7373     216.0000       0.1267       0.0552       0.0208      12.5218      39.7016     259.9724     146.6548      49.9441       0.0222       0.0291       0.0639       4.4856    2615.6472     630.7462     -45.5000    3661.0000
 2315.1084      46.1496     197.2051    1950.0000    1950.0000     346.0284       2.8899     216.0000       0.1275       0.0561       0.0217      11.9952      42.6874     259.9724     154.6349      49.9441       0.0208       0.0278       0.0621       4.5081    2614.1333     630.9852     -44.5625    3654.0000
 2315.2608      45.0709     221.6521    1868.5291    1859.6359     388.3841       2.5748     216.0000       0.1296       0.0584       0.0242      12.0493      43.5154     260.2515     160.3339      49.9441       0.0226       0.0296       0.0644       4.5360    2610.1526     631.0952     -42.1875    3676.0000
 2315.4132      44.4298     235.7011    1708.1349    1668.2659     481.8819       2.0752     216.0000       0.1314       0.0603       0.0262      12.3495      44.3746     259.9724     158.6049      49.9441       0.0314       0.0402       0.0760       4.5479    2606.8479     628.4343     -39.3125    3721.0000
 2315.5656      44.1026     217.3423    1522.6204    1439.7606     687.0754       1.4554     216.0000       0.1250       0.0534       0.0189      12.3892      45.3980     259.9724     160.7356      49.9441       0.0272       0.0347       0.0703       4.5636    2618.7573     554.1392     -40.3750    3760.0000
 2315.7180      43.7574     169.6553    1764.9537    1697.2914    1189.7297       0.8405     216.0000       0.1170       0.0447       0.0100      12.2550      44.6437     259.9724     164.0589      49.9441       0.0233       0.0302       0.0653       4.5893    2633.4968     410.6105     -39.0625    3763.0000
 2315.8704      42.4770     122.2169     940.4720     759.6782     612.4069       1.6329     216.0000       0.1090       0.0361       0.0010      12.2027      41.6455     259.9724     176.7690      49.9441       0.0215       0.0276       0.0628       4.6910    2648.3013     420.9866     -38.6875    3727.0000
 2316.0228      40.4919      95.9012     718.9008     514.4138     498.9876       2.0041     216.0000       0.1081       0.0351      -0.0000      12.1741      39.1066     258.2978     196.6758      49.9441       0.0210       0.0259       0.0619       4.9111    2650.0610      73.6225     -36.5000    3703.0000
 2316.1752      38.3254      71.6043     492.5103     337.1711     344.7180       2.9009     216.0000       0.1216       0.0496       0.0151      11.9596      37.7835     262.4843     219.8792      49.9441       0.0516       0.0621       0.1017       5.2411    2625.1045      51.2435     -36.5625    3676.0000
 2316.3276      38.3334      75.3998     580.2883     323.3367     363.2767       2.7527     216.0000       0.1188       0.0467       0.0120      11.8722      40.8899     266.6708     257.9505      49.9441       0.0547       0.0655       0.1055       5.5529    2630.2134      33.9379     -32.4375    3652.0000
 2316.4800      39.4790      84.2462     623.0168     396.8674     323.3845       3.0923     216.0000       0.1173       0.0451       0.0104      12.0306      48.0754     278.3931     275.5954      49.9441       0.0463       0.0556       0.0948       5.7405    2632.9170      32.6578     -29.3125    3630.0000
 2316.6324      41.0351     103.5529     786.4517     558.6670     401.4456       2.4910     216.0000       0.1145       0.0420       0.0071      12.0770      60.5222     287.8825     274.2598      49.9441       0.0469       0.0557       0.0955       5.7748    2638.2361      29.9065     -36.2500    3679.0000
 2316.7848      41.1424     116.6837     540.0391     291.8711     222.4917       4.4945     216.0000       0.1229       0.0510       0.0165      12.0565      71.4422     282.3004     251.6637      49.9441       0.0633       0.0739       0.1161       5.7075    2622.7075      27.8186     -29.3125    3671.0000
 2316.9372      41.5212     125.8868     821.0804     474.8152     466.8280       2.1421     216.0000       0.1016       0.0280      -0.0073      11.8568      75.5975     285.3705     255.5671      49.9441       0.0527       0.0617       0.1028       5.5648    2662.0918      30.0217     -29.3125    3667.0000
 2317.0896      40.9642     108.9863     842.7869     603.2967     269.6844       3.7080     216.0000       0.0733      -0.0026      -0.0391      11.6743      78.5044     293.1854     273.6859      49.9441       0.0621       0.0720       0.1145       5.4292    2714.4409      39.1085     -29.3125    3637.0000
 2317.2420      41.7324     109.2243     801.5532     567.2907     265.8579       3.7614     216.0000       0.0511      -0.0266      -0.0639      11.7341      79.4348     288.1616     298.6081      49.9441       0.0852       0.0975       0.1431       5.3540    2755.4553      71.9193     -29.3125    3613.0000
 2317.3944      42.1570      97.8497     766.8266     492.9160     288.9597       3.4607     216.0000       0.0595      -0.0175      -0.0545      11.8795      79.5124     280.3468     304.7998      49.9441       0.1172       0.1327       0.1818       5.3657    2739.9607     123.9223     -25.6250    3646.0000
 2317.5468      40.8403      85.9134     687.0598     398.1807     281.1743       3.5565     216.0000       0.0704      -0.0057      -0.0423      11.8885      77.7082     280.0677     303.0162      49.9441       0.1360       0.1537       0.2039       5.3985    2719.8032     107.3659     -27.1875    3612.0000
 2317.6992      40.1507      83.7020     593.5635     310.4970     255.9537       3.9070     216.0000       0.0815       0.0063      -0.0298      11.7529      76.0269     282.5796     288.9132      49.9441       0.1011       0.1147       0.1625       5.4046    2699.2263      92.2996     -29.3125    3614.0000
 2317.8516      39.3842      82.8707     452.4986     211.7046     179.4886       5.5714     216.0000       0.0904       0.0159      -0.0198      11.5274      74.9050     282.3004     274.3595      49.9441       0.0922       0.1048       0.1517       5.3839    2682.7412      82.9462     -27.9375    3525.0000
 2318.0040      36.4818      82.7754     473.6095     170.5052     151.9345       6.5818     216.0000       0.1089       0.0359       0.0009      11.7486      73.3307     282.0214     263.4695      49.9441       0.0965       0.1096       0.1568       5.3976    2648.5632      42.9708     -27.2500    3463.0000
 2318.1564      34.8698      84.0132     555.8364     245.2890     184.6176       5.4166     216.0000       0.1505       0.0810       0.0476      11.7326      74.3157     292.3481     243.5052      49.9441       0.0849       0.0964       0.1427       5.4822    2571.4995      23.4068     -25.8125    3539.0000
 2318.3088      32.6896      82.7656     787.2972     307.0660     208.7298       4.7909     216.0000       0.1895       0.1232       0.0913      11.6860      73.3104     310.7687     228.7037      49.9441       0.0996       0.1129       0.1607       5.6047    2499.3760      16.7001     -24.1250    3684.0000
 2318.4612      29.1870      62.5346     762.2926     368.5875     239.1891       4.1808     216.0000       0.2054       0.1404       0.1091      11.6400      75.5318     307.9777     217.7472      49.9441       0.1571       0.1772       0.2281       5.6461    2469.9177      14.9717     -24.3750    3784.0000
 2318.6136      24.7408      46.4622     394.3112     171.9621     175.8251       5.6875     216.0000       0.1704       0.1024       0.0698      11.6462      73.3522     315.7925     240.0455      49.9441       0.0863       0.0982       0.1444       5.5717    2534.8455      15.7059     -24.8125    3743.0000
 2318.7660      23.0718      34.6554     411.1687     142.4657      94.8016      10.5483     216.0000       0.1395       0.0690       0.0352      11.6070      74.3575     318.0253     254.6132      49.9441       0.0753       0.0860       0.1309       5.4666    2591.9729      20.9152     -24.8125    3608.0000
 2318.9184      21.8547      29.3350     443.4259     200.0649     141.3215       7.0761     216.0000       0.1312       0.0600       0.0259      11.5607      70.5095     309.8384     260.1046      49.9441       0.0873       0.0994       0.1457       5.4487    2607.3347      28.8507     -24.7500    3609.0000
 2319.0708      20.6848      27.6396     468.2496     234.8909     170.2482       5.8738     216.0000       0.1782       0.1109       0.0786      11.4253      72.9211     309.3732     225.2924      49.9441       0.0810       0.0921       0.1379       5.5509    2520.3726      17.2041     -25.1875    3661.0000
 2319.2232      20.2348      28.4344     538.2852     290.7105     211.9139       4.7189     216.0000       0.2207       0.1569       0.1263      11.2064      76.1702     301.0932     189.4343      49.9441       0.0796       0.0903       0.1362       5.6586    2441.6240      10.1154     -24.8125    3662.0000
 2319.3756      20.8921      32.8517     697.9103     413.3684     281.0492       3.5581     216.0000       0.2247       0.1612       0.1307      11.2712      82.6203     308.2568     165.6742      49.9441       0.1124       0.1272       0.1760       5.6399    2434.3772       8.3227     -24.5000    3631.0000
 2319.5280      21.1129      40.6192     922.1341     594.7081     339.9971       2.9412     216.0000       0.1653       0.0970       0.0641      11.4133      84.3609     317.0950     183.1343      49.9441       0.1645       0.1852       0.2369       5.4503    2544.1919      10.7483     -29.3125    3627.0000
 2319.6804      21.4684      53.0423    1186.9191     796.7849     335.0379       2.9847     216.0000       0.1006       0.0270      -0.0084      11.4242      82.5724     331.9803     223.6140      49.9441       0.1530       0.1726       0.2238       5.2410    2663.8721      19.3255     -24.4375    3590.0000
 2319.8328      21.7921      70.9733    1384.7382     934.6636     316.5093       3.1595     216.0000       0.0529      -0.0247      -0.0619      11.4152      81.4981     324.1655     283.1592      49.9441       0.1670       0.1880       0.2399       5.1447    2752.1833      39.4313     -26.0000    3643.0000
 2319.9852      22.0614      95.1292    1350.8219     715.4866     196.9949       5.0763     216.0000       0.0426      -0.0358      -0.0735      11.3658      78.6573     312.1642     315.5167      49.9441       0.1488       0.1681       0.2191       5.1882    2771.2261      60.1984     -26.8125    3646.0000
 2320.1376      22.5138     127.0033    1119.0234     726.6186     152.4917       6.5577     216.0000       0.0511      -0.0266      -0.0639      11.3064      79.4897     314.9552     284.3323      49.9441       0.1113       0.1260       0.1749       5.2189    2755.4451      23.2350     -27.6250    3567.0000
 2320.2900      22.9016     165.9447     944.3785     608.2233     127.0578       7.8704     216.0000       0.0870       0.0122      -0.0237      11.1111      77.6890     319.9790     191.1037      49.9441       0.1055       0.1194       0.1678       5.1449    2689.1304      12.8291     -26.3125    3503.0000
 2320.4424      23.4793     222.0052    1950.0000    1950.0000     177.9694       5.6189     216.0000       0.1331       0.0621       0.0280      11.1903      80.5764     316.7228      82.1631      49.9441       0.1059       0.1202       0.1682       4.9510    2603.8030       9.2411     -23.4375    3379.0000
 2320.5948      23.1765     318.2895    1220.2054    1017.7040     127.6155       7.8360     216.0000       0.1675       0.0994       0.0666      11.4537      81.1588     316.6298      27.0174      49.9441       0.0906       0.1029       0.1496       4.8593    2540.0359      10.7006     -29.3125    3257.0000
 2320.7472      25.8688     377.2140     944.8349     704.3516     144.1554       6.9370     216.0000       0.1680       0.0999       0.0671      11.7381      81.3065     316.9089      45.2330      49.9440       0.1041       0.1184       0.1660       4.9939    2539.2415      17.0075     -29.3125    3448.0000
 2320.8996      28.0813     402.9765    1064.3943     716.3497     147.5199       6.7787     216.0000       0.1510       0.0815       0.0481      11.9326      77.4314     320.5372     110.4887      49.9441       0.1166       0.1322       0.1810       5.2671    2570.6643      27.2061     -30.4375    4157.0000
 2321.0520      29.5471     267.6296    1950.0000    1931.6575     467.9079       2.1372     216.0000       0.1539       0.0846       0.0513      12.0478      72.8772     314.6761     162.1962      49.9441       0.1096       0.1243       0.1726       5.4999    2565.3091      36.2550     -26.6875    4752.0000
 2321.2044      29.7960     151.2451    1122.9125     926.0918     817.6629       1.2230     216.0000       0.1641       0.0957       0.0628      11.7171      69.2217     312.7224     171.7556      49.9441       0.0834       0.0945       0.1409       5.5176    2546.4136      27.8251     -24.8750    4663.0000
 2321.3568      27.4975      92.9553     275.3318     226.2920     271.7521       3.6798     216.0000       0.1722       0.1044       0.0718      11.3210      68.3570     303.7912     140.0633      49.9441       0.0990       0.1123       0.1599       5.3759    2531.5183      40.8919     -26.0000    4552.0000
 2321.5092      23.0096      48.7576     185.2677     155.0939     213.3106       4.6880     216.0000       0.1734       0.1057       0.0732      11.2779      70.7290     313.0015      85.4242      49.9441       0.1095       0.1242       0.1725       5.1339    2529.1799      60.1138     -23.1875    4487.0000
 2321.6616      21.9927      38.7751     134.6548     112.1814     157.9233       6.3322     216.0000       0.1746       0.1070       0.0746      11.1028      69.9786     309.3732      41.3229      49.9441       0.0990       0.1125       0.1598       4.9053    2526.9880      58.2019     -27.5000    4375.0000
 2321.8140      21.1079      26.3959     105.2814      88.9303     110.8669       9.0198     216.0000       0.1780       0.1107       0.0783      11.0433      69.7923     309.3732      18.6214      49.9441       0.0925       0.1055       0.1520       4.8296    2520.7773      46.6933     -23.8125    4276.0000
 2321.9664      18.3941      23.9312     120.9321      95.7971      88.0771      11.3537     216.0000       0.1662       0.0980       0.0652      10.9513      67.9753     306.3031      50.5393      49.9441       0.0846       0.0964       0.1423       4.9425    2542.4785      47.1121     -25.3125    4213.0000
 2322.1188      18.5626      26.0848     157.6558     119.4017      70.0696      14.2715     216.0000       0.2105       0.1459       0.1148      11.1893      64.2177     299.6047      67.9474      49.9441       0.0886       0.1010       0.1472       5.2028    2460.5068      21.2770     -25.8125    4092.0000
 2322.2712      20.1769      30.8733     210.6002     134.1097      57.3794      17.4278     216.0000       0.2569       0.1960       0.1668      11.1789      63.3303     292.6272      84.4939      49.9441       0.0906       0.1033       0.1497       5.4266    2374.7837       8.6906     -26.0000    4025.0000
 2322.4236      22.5457      38.8396     299.4111     149.1003      67.7161      14.7675     216.0000       0.3000       0.2427       0.2152      11.1040      60.8516     290.3944      66.1719      49.9441       0.0914       0.1041       0.1506       5.4726    2295.0020       5.8837     -23.8750    3923.0000
 2322.5760      26.3939      58.1057    1455.5542     168.1557      52.0146      19.2254     216.0000       0.2905       0.2324       0.2044      11.3310      66.4271     296.0694      52.2656      49.9441       0.1082       0.1226       0.1709       5.3447    2312.6577       5.9605     -29.3125    3829.0000
 2322.7284      30.4481      88.6469     380.9733     205.3153      73.0445      13.6903     216.0000       0.2410       0.1788       0.1490      11.0846      69.4414     301.0002      77.0028      49.9441       0.1417       0.1600       0.2107       5.2452    2404.1860       8.3267     -28.5000    3746.0000
 2322.8808      33.4611     141.5991     993.3680     160.7809      59.1340      16.9107     216.0000       0.1850       0.1183       0.0862      11.2484      72.8927     302.3957     126.6854      49.9441       0.1753       0.1985       0.2500       5.2137    2507.7419      12.1590     -22.8125    3829.0000
 2323.0332      36.1752     183.2806    1092.5242     223.1241      77.6974      12.8704     216.0000       0.1495       0.0798       0.0464      11.0949      72.8927     309.3732     177.0122      49.9441       0.1904       0.2159       0.2674       5.2845    2573.4956      13.4197     -26.5625    3916.0000
 2323.1856      33.7902     123.3010     366.8370     205.1447      90.3139      11.0725     216.0000       0.1652       0.0969       0.0640      11.2343      68.4546     321.9327     176.0199      49.9441       0.1920       0.2176       0.2691       5.2983    2544.3479      10.9828     -21.2500    3999.0000
 2323.3380      35.9940      73.9305     160.8537     136.2851      82.6367      12.1012     216.0000       0.1836       0.1167       0.0846      11.1284      68.4546     295.6973     152.3640      49.9441       0.1978       0.2241       0.2757       5.2134    2510.3660      10.3264     -21.3750    3925.0000
 2323.4904      41.6227      41.2667      89.0886      59.9032      51.8183      19.2982     216.0000       0.1590       0.0902       0.0571      11.0765      68.3316     299.9768     134.4652      49.9441       0.1937       0.2194       0.2710       4.9427    2555.7932      12.8718     -19.5625    3860.0000
 2323.6428      38.8842      56.6631     146.2755      81.5078      63.0572      15.8586     216.0000       0.1395       0.0691       0.0352      11.0585      71.3826     307.4195     113.2166      49.9441       0.1930       0.2188       0.2703       4.6142    2591.8892      21.4835     -24.5625    3759.0000
 2323.7952      44.2636      89.1883     197.3428     162.2291      82.3791      12.1390     216.0000       0.1308       0.0597       0.0255      11.1998      67.4882     316.7228     124.8064      49.9441       0.1951       0.2213       0.2727       4.4853    2607.9973      27.5161     -19.5625    3767.0000
 2323.9476      65.6168      95.2377     417.6454     361.9924      94.6315      10.5673     216.0000       0.1558       0.0866       0.0534      11.1403      64.6054     299.0465     160.6638      49.9441       0.2097       0.2380       0.2892       4.7003    2561.8381      52.7701     -19.5625    4053.0000
 2324.1000      73.7509     101.7796     236.9008     230.7428      82.9570      12.0544     216.0000       0.1472       0.0774       0.0439      11.2084      60.7409     304.6285     235.7986      49.9441       0.2224       0.2517       0.3032       5.0773    2577.5986      31.0368     -19.5625    4072.0000
 2324.2524      56.1889      82.9063     150.8201     182.5405      38.8752      25.7233     216.0000       0.1144       0.0419       0.0071      10.7209      62.4021     282.5796     285.5706      49.9441       0.1967       0.2237       0.2747       5.3222    2638.3386      50.8658     -19.5625    4021.0000
 2324.4048      51.5844      55.4801      81.5767     156.7236      36.9415      27.0698     216.0000       0.0874       0.0127      -0.0232      10.6352      63.1747     282.8586     282.7222      49.9441       0.2078       0.2353       0.2869       5.3576    2688.2932      45.9105     -19.5625    3949.0000
 2324.5572      45.4723     162.4640      98.1532     104.1920      56.4740      17.7072     216.0000       0.0916       0.0172      -0.0185      10.5386      67.0392     279.5095     262.5442      49.9441       0.1993       0.2257       0.2773       5.4315    2680.5928      91.0052     -19.5625    3854.0000
 2324.7096      75.6047     264.3767      98.0382     155.6331      78.3390      12.7650     216.0000       0.1487       0.0790       0.0456      10.5313      69.1547     279.1374     243.5300      49.9441       0.1827       0.2072       0.2586       5.7003    2574.8406      76.5813     -19.5625    3783.0000
 2324.8620      86.6665     149.6960      75.4784      88.8434     106.2667       9.4103     216.0000       0.1938       0.1277       0.0960      10.8486      73.0602     282.3004     275.3329      49.9441       0.1947       0.2205       0.2721       6.0807    2491.5479      40.0667     -19.5625    3691.0000
 2325.0144      38.3789      38.8199      31.5465      86.3979      49.1990      20.3256     216.0000       0.2256       0.1622       0.1317      10.8808      75.0942     255.2277     303.1878      49.9441       0.2126       0.2404       0.2922       6.3550    2432.7122      24.2568     -17.9375    3805.0000
 2325.1668      26.6750      33.3133      20.0368      36.8523      33.8617      29.5319     216.0000       0.2275       0.1642       0.1338      10.8463      78.2571     248.8084     327.4574      49.9441       0.2138       0.2424       0.2937       6.4561    2429.1809      19.1875     -16.9375    3908.0000
 2325.3192      20.9066      14.1090      13.8624      23.5536      20.8287      48.0107     216.0000       0.2274       0.1641       0.1338      10.7975      78.2088     246.8547     332.7558      49.9441       0.1892       0.2152       0.2662       6.4729    2429.3064      18.2693     -19.5625    3815.0000
 2325.4716      19.1777      14.4064      21.7961      52.2302      47.9217      20.8674     216.0000       0.2269       0.1636       0.1332      10.6661      79.4292     245.8313     334.6455      49.9441       0.1984       0.2250       0.2764       6.4733    2430.1794      17.9682     -16.5000    3733.0000
 2325.6240      23.7225      19.4005      29.7698      54.0651      43.4634      23.0079     216.0000       0.2237       0.1602       0.1297      10.7113      77.7096     245.1801     339.9503      49.9441       0.1722       0.1945       0.2462       6.4646    2436.0725      17.8570     -19.5625    3692.0000
 2325.7764      26.8005      26.3972      44.1457      67.1646      50.8446      19.6678     216.0000       0.2201       0.1563       0.1256      10.6317      74.7070     244.9010     345.6259      49.9441       0.1439       0.1627       0.2135       6.4400    2442.8113      17.8402     -19.5625    3757.0000
 2325.9288      45.3161      39.8530      89.6959      77.6810     105.2299       9.5030     216.0000       0.2190       0.1551       0.1243      10.5325      77.9613     244.9010     350.9061      49.9441       0.1373       0.1552       0.2056       6.3990    2444.8535      17.8649     -18.9375    3935.0000
 2326.0812      54.7936      60.8562     685.3762      77.4902      60.8518      16.4334     216.0000       0.2157       0.1515       0.1207      10.5636      77.4477     244.9010     358.9060      49.9441       0.1278       0.1445       0.1945       6.3459    2450.8867      17.8649     -17.6250    3989.0000
 2326.2336      55.8459      80.6367    1950.0000     138.0713      66.8072      14.9684     216.0000       0.2062       0.1412       0.1100      10.6369      78.8262     244.6219     368.0627      49.9441       0.1346       0.1521       0.2023       6.2755    2468.5674      17.6535     -18.5000    3903.0000
 2326.3860      58.1117      91.3698    1950.0000      87.8587      47.0559      21.2513     216.0000       0.1509       0.0813       0.0479      10.6602      74.7583     244.9010     408.3400      49.9441       0.1199       0.1356       0.1850       6.1259    2570.8940      16.1118     -18.8750    3834.0000
 2326.5384      57.4236      78.9325     425.2921     175.8320      74.6665      13.3929     216.0000       0.0866       0.0118      -0.0241      10.8142      75.0077     244.9010     447.2578      49.9441       0.1191       0.1347       0.1841       5.9465    2689.7532      14.8456     -17.5000    3952.0000
 2326.6908      58.7752      69.9286     214.0681     120.6650      51.5122      19.4129     216.0000       0.0349      -0.0441      -0.0821      10.9368      74.1957     305.1867     472.9390      49.9441       0.1321       0.1493       0.1993       5.7786    2785.4197      14.0515     -19.2500    3910.0000
 2326.8432      40.5455      40.4826     141.4747     123.0784      35.7725      27.9544     216.0000       0.0317      -0.0476      -0.0857      10.6432      79.0643     305.5216     462.1840      49.9441       0.1400       0.1585       0.2084       5.7020    2791.3557      14.1442     -17.6875    3943.0000
 2326.9956      30.5984      32.3007      95.1890     134.6347      41.4471      24.1272     216.0000       0.0404      -0.0382      -0.0759      10.6274      81.2511     305.2983     448.8499      49.9441       0.0556       0.0632       0.1062       5.6781    2775.2788      14.1812     -17.3125    3782.0000
 2327.1480      44.3850      37.0828     122.1709     175.2432      57.4317      17.4120     216.0000       0.0433      -0.0350      -0.0727      10.2910      86.5295     305.2154     446.7900      49.9441       0.0599       0.0684       0.1117       5.6742    2769.8838      14.2000     -16.1250    3827.0000
 2327.3004      50.9218      61.0806     201.6265     246.8536     101.1836       9.8830     216.0000       0.0440      -0.0343      -0.0719      10.1671      77.9997     305.0272     449.6560      49.9441       0.0849       0.0972       0.1427       5.6927    2768.5815      14.3996     -16.9375    3734.0000
 2327.4528      49.0049      89.2123     232.7580     332.2960     117.1100       8.5390     216.0000       0.0406      -0.0380      -0.0757      10.0670      79.6775     305.0937     452.6091      49.9441       0.0856       0.0981       0.1436       5.6978    2774.9331      14.8033     -14.8125    3661.0000
 2327.6052      48.4262     128.9309     288.4861     424.0786     142.4233       7.0213     216.0000       0.0411      -0.0374      -0.0751      10.1805      75.6172     304.9406     449.7678      49.9441       0.0718       0.0827       0.1266       5.7099    2773.9897      15.2272     -14.1250    3560.0000
 2327.7576      42.9494     119.6544     293.4778     451.4015     140.3794       7.1236     216.0000       0.0410      -0.0375      -0.0753      10.3540      75.3723     304.6285     440.7849      49.9441       0.0713       0.0817       0.1260       5.6974    2774.1738      15.4009     -18.3125    3572.0000
 2327.9100      38.1095     114.8391     273.1212     474.3575     198.9887       5.0254     216.0000       0.0445      -0.0338      -0.0714      10.3286      67.6433     304.6285     433.7821      49.9441       0.0765       0.0873       0.1324       5.7115    2767.7283      15.4655     -16.5000    3609.0000
 2328.0624      36.9714     102.9126     242.1954     395.8931     317.4139       3.1505     216.0000       0.0443      -0.0340      -0.0716      10.0922      66.3527     304.6285     431.3295      49.9441       0.1035       0.1175       0.1653       5.7227    2768.1238      15.5349     -16.9375    3805.0000
 2328.2148      34.0021      70.7826     225.0174     684.6381     147.7450       6.7684     216.0000       0.0485      -0.0294      -0.0669       9.6080      72.4960     304.6285     430.5344      49.9441       0.0968       0.1097       0.1573       5.7504    2760.3484      15.6094     -17.3125    3829.0000
 2328.3672      34.0221      57.7757     216.3964     354.8863     154.6371       6.4668     216.0000       0.0507      -0.0270      -0.0643       9.3698      77.9877     304.6285     427.0384      49.9441       0.1200       0.1358       0.1851       5.7524    2756.1392      15.6780     -15.8750    3788.0000
 2328.5196      27.1520      47.1478     192.6791     238.5007     160.5204       6.2297     216.0000       0.0557      -0.0216      -0.0587       9.0970      79.4813     304.6285     421.3989      49.9441       0.1725       0.1940       0.2461       5.7422    2746.9243      15.7001     -17.5000    3717.0000
 2328.6720      25.4138      32.1576     156.8877     145.6553     154.8791       6.4566     216.0000       0.0607      -0.0162      -0.0532       9.4235      69.8867     304.6285     414.1502      49.9441       0.2169       0.2421       0.2954       5.7479    2737.7825      15.6607     -19.5625    3596.0000
 2328.8244      26.0930      28.8012     122.3501      86.9710     113.5455       8.8070     216.0000       0.0637      -0.0130      -0.0498       9.9135      62.3611     304.6285     405.2360      49.9441       0.0763       0.0872       0.1322       5.7520    2732.1948      15.5654     -19.5625    3618.0000
 2328.9768      21.5046      35.6931     144.9120      57.5944      90.0797      11.1013     216.0000       0.0761       0.0005      -0.0359       9.9870      58.7068     304.6285     388.1922      49.9441       0.0224       0.0248       0.0633       5.8124    2709.1592      15.4668     -19.5625    3801.0000
 2329.1292      19.3086      45.0788     143.0835      39.2305     118.5839       8.4328     216.0000       0.0948       0.0207      -0.0149      10.0393      60.7370     304.6285     365.6714      49.9441       0.0406       0.0464       0.0872       5.9146    2674.6094      15.4256     -18.9375    4000.0000
 2329.2816      16.4357      36.4298     262.1720      37.9276      43.1367      23.1821     216.0000       0.1552       0.0860       0.0528      10.0765      74.4052     304.6285     321.8951      49.9441       0.0905       0.1028       0.1495       6.1228    2562.8940      12.3453     -19.5625    3998.0000
 2329.4340      14.0488      27.7205     126.9351      99.4097      75.7748      13.1970     216.0000       0.2555       0.1946       0.1653      10.0626      78.8715     303.5121     258.3206      49.9441       0.1731       0.1950       0.2470       6.4036    2377.3142       6.0330     -19.5625    3900.0000
 2329.5864      11.0450      19.9533      53.0185      24.7534      23.7020      42.1905     216.0000       0.3583       0.3058       0.2805       9.6394      88.0072     297.9301     193.1969      49.9441       0.3279       0.3636       0.4155       6.6388    2187.1572       3.5573     -18.2500    3757.0000
 2329.7388       8.6853      11.8804      30.7939      28.2494      18.7400      53.3619     216.0000       0.4095       0.3612       0.3380       9.6278      90.2039     311.6060     141.2684      49.9441       0.3229       0.3593       0.4106       6.6717    2092.3591       2.7556     -26.5625    3844.0000
 2329.8912       9.5844      13.3398      43.0405      58.6676      33.1878      30.1316     216.0000       0.3465       0.2930       0.2673       9.6182      90.2039     318.0253     140.2979      49.9441       0.1710       0.1943       0.2453       6.3945    2208.9729       3.0402     -22.6250    3771.0000
 2330.0436      14.4908      15.4974      70.6728      73.5086      49.9122      20.0352     216.0000       0.2521       0.1908       0.1614       9.5520      92.6400     328.0729     157.7280      49.9441       0.1488       0.1694       0.2198       5.9852    2383.6763       4.8388     -21.2500    3852.0000
 2330.1960      14.4651      20.8662     100.3280     131.9574      80.5770      12.4105     216.0000       0.2299       0.1668       0.1365       9.8195      81.0302     334.7714     158.7124      49.9441       0.1868       0.2119       0.2633       5.7166    2424.7021       9.5114     -20.8125    3795.0000
 2330.3484      15.0032      30.4938     169.0766     251.9405     139.0843       7.1899     216.0000       0.3437       0.2900       0.2641       9.3158      75.1428     301.2793     109.9327      49.9441       0.1533       0.1735       0.2245       5.8250    2214.1558       5.7838     -20.4375    3725.0000
 2330.5008      15.1451      42.2211     313.2163     430.8458     263.2732       3.7983     216.0000       0.3962       0.3468       0.3230       9.4341      67.0222     290.1153     104.8799      49.9441       0.1240       0.1403       0.1900       5.9368    2116.9846       4.0264     -21.3750    3699.0000
 2330.6532      16.1463      60.3169     570.1205     481.7118     448.1177       2.2316     216.0000       0.3345       0.2800       0.2539       9.3787      68.8690     291.7899     146.2085      49.9441       0.0899       0.1017       0.1490       5.8463    2231.1475       4.4134     -23.4375    3710.0000
 2330.8056      17.2759      87.5235     872.2365     366.7775     540.8004       1.8491     216.0000       0.1974       0.1317       0.1001       9.5172      72.3203     360.7277     202.7991      49.9441       0.1004       0.1137       0.1618       5.4700    2484.8074      12.1749     -22.3750    3781.0000
 2330.9580      19.0092     123.3558    1062.5869     258.4606     469.1198       2.1317     216.0000       0.1385       0.0679       0.0340       9.5005      68.6660     401.1972     208.2839      49.9441       0.2245       0.2505       0.3041       5.1949    2593.8523      43.8632     -25.0625    3828.0000
 2331.1104      21.7445     197.9311     508.6842     181.1342     205.3253       4.8703     216.0000       0.1314       0.0603       0.0262       9.4906      65.4116     404.5464     203.0866      49.9441       0.2461       0.2738       0.3277       5.1731    2606.8462      43.6773     -25.4375    3866.0000
 2331.2628      24.6543     299.9032    1950.0000     224.4600     271.1030       3.6886     216.0000       0.1344       0.0636       0.0295       9.1743      58.9463     406.2211     209.6052      49.9441       0.1301       0.1471       0.1970       5.3576    2601.2793      36.1999     -28.0000    3873.0000
 2331.4152      27.7748     398.0452    1279.5226     139.4465     214.0164       4.6725     216.0000       0.1620       0.0934       0.0604       9.2789      53.4649     405.6628     210.1831      49.9441       0.0702       0.0799       0.1246       5.6573    2550.3274      23.8293     -27.3750    3798.0000
 2331.5676      30.0518     387.7219    1950.0000     143.4525     128.0596       7.8089     216.0000       0.2214       0.1577       0.1271       9.1847      53.3881     411.2449     199.6391      49.9441       0.0531       0.0607       0.1031       5.9934    2440.3218      11.9499     -24.8750    3687.0000
 2331.7200      31.1527     275.9544    1950.0000     112.3335      84.0231      11.9015     216.0000       0.2790       0.2200       0.1916       9.6544      57.4172     310.2105     193.4853      49.9441       0.0696       0.0793       0.1239       6.2729    2333.8120       7.6926     -25.9375    3797.0000
 2331.8724      31.0677     187.9008    1088.8280      84.4740      51.6458      19.3626     216.0000       0.3255       0.2702       0.2437       9.7219      65.7409     331.1430     180.7413      49.9441       0.0757       0.0862       0.1314       6.4380    2247.8823       4.7381     -28.0625    3771.0000
 2332.0248      31.7081     132.0146     733.7454      88.3797      42.9389      23.2889     216.0000       0.3177       0.2619       0.2350       9.7330      66.8347     300.4420     188.5314      49.9441       0.1217       0.1379       0.1870       6.4444    2262.2231       4.2700     -26.5000    3662.0000
 2332.1772      30.2244      92.0801     624.2434      87.4223      36.9126      27.0911     216.0000       0.3175       0.2617       0.2348       9.6457      61.7885     294.0227     190.1152      49.9441       0.1599       0.1810       0.2313       6.4487    2262.5452       5.2706     -27.6875    3592.0000
 2332.3296      29.8711      78.2983     390.5735      59.6284      32.6359      30.6411     216.0000       0.2863       0.2278       0.1997       9.2245      55.4951     299.0465     229.1737      49.9441       0.0512       0.0583       0.1006       6.4859    2320.4192       9.0327     -26.5000    3507.0000
 2332.4820      30.8765      76.7103     354.7048      62.0377      34.8069      28.7300     216.0000       0.2790       0.2200       0.1916       9.2077      52.0012     266.1126     265.6095      49.9441       0.0403       0.0446       0.0866       6.6066    2333.7942      10.2757     -24.4375    3402.0000
 2332.6344      36.4744     113.5565     612.3711      96.8692      43.6479      22.9106     216.0000       0.3082       0.2515       0.2243       9.2355      54.0352     305.7449     279.3357      49.9441       0.1427       0.1612       0.2119       6.7901    2279.8665       6.6193     -29.3125    3322.0000
 2332.7868      38.8337     125.0212     794.2008     193.2727      58.8385      16.9957     216.0000       0.3726       0.3213       0.2966       9.1731      61.9996     315.2343     261.0587      49.9441       0.2324       0.2597       0.3131       6.9922    2160.6055       3.9786     -29.3125    3207.0000
 2332.9392      42.1100     144.8485    1031.1040     180.3120      59.8642      16.7045     216.0000       0.3825       0.3319       0.3076       9.2324      69.7762     286.7661     264.0152      49.9441       0.1656       0.1865       0.2382       7.0120    2142.4209       3.3764     -26.5625    3143.0000
 2333.0916      45.8211     160.1615    1338.3302     209.2948      59.3486      16.8496     216.0000       0.2871       0.2287       0.2007       9.0631      73.8441     277.8349     321.8705      49.9441       0.1450       0.1638       0.2147       6.7128    2318.8440       4.2887     -22.4375    3037.0000
 2333.2440      50.4309     177.2013    1609.9305     257.5956      65.0446      15.3741     216.0000       0.1789       0.1116       0.0793       9.1291      77.2486     318.5835     368.6690      49.9441       0.1784       0.2006       0.2529       6.2903    2519.0908       7.5397     -28.7500    2934.0000
 2333.3964      56.4757     198.5586    1836.8431     298.7598      66.5466      15.0271     216.0000       0.1375       0.0669       0.0330       9.2451      70.6901     345.0981     366.2026      49.9441       0.1087       0.1231       0.1716       6.0245    2595.6089      12.7119     -28.2500    2775.0000
 2333.5488      64.7484     230.4210    1866.1163     240.8117      70.2077      14.2434     216.0000       0.1357       0.0650       0.0310       9.1290      68.0459     363.5187     351.7838      49.9441       0.0370       0.0410       0.0824       5.9713    2598.9055      13.1443     -29.0000    5374.0000
 2333.7012      76.5346     270.9555    1585.9708     182.4003      70.5988      14.1646     216.0000       0.1211       0.0491       0.0145       9.0806      60.1667     340.9116     367.5115      49.9441       0.0819       0.0931       0.1391       6.0155    2626.0244      10.8792     -29.3125    5322.0000
 2333.8536      91.7690     290.1171    1477.1620     147.8401      74.3535      13.4493     216.0000       0.1076       0.0346      -0.0006       8.9439      57.7305     351.5174     381.0050      49.9441       0.1591       0.1793       0.2305       6.0936    2650.9163      13.7928     -28.2500    5220.0000
 2334.0060     110.4905     242.0917    1950.0000     165.3773      57.0556      17.5268     216.0000       0.1318       0.0607       0.0266       8.7259      58.1292     350.9591     361.0594      49.9441       0.1468       0.1657       0.2166       6.2386    2606.1362      13.5050     -29.3125    5153.0000
 2334.1584     114.6315     151.7335    1938.3295     177.2212      45.4589      21.9979     216.0000       0.1981       0.1324       0.1009       8.4014      57.4817     352.0755     303.4370      49.9441       0.1462       0.1650       0.2158       6.4183    2483.5217      10.1727     -29.3125    5051.0000
 2334.3108      92.2365      81.4912     718.1375     162.2178      43.1878      23.1547     216.0000       0.2481       0.1865       0.1569       8.7484      56.8727     390.0332     269.2046      49.9441       0.1306       0.1477       0.1977       6.5254    2391.0535       6.7742     -34.4375    4941.0000
 2334.4632      68.5973      46.7640     738.9194     143.3914      48.7085      20.5303     216.0000       0.2716       0.2120       0.1833       8.6837      57.8978     426.3163     254.6387      49.9441       0.1152       0.1304       0.1796       6.4980    2347.4939       6.0760     -28.1875    4905.0000
 2334.6156      40.7478      36.2311     130.1356     130.1534      27.7284      36.0642     216.0000       0.2553       0.1944       0.1651       9.1502      60.5792     323.0491     271.7393      49.9441       0.1601       0.1807       0.2322       6.3480    2377.6497       6.6817     -28.6875    4830.0000
 2334.7680      39.2072      25.6092     147.9192     199.7865      23.7532      42.0996     216.0000       0.2351       0.1725       0.1424       9.3031      63.6244     288.9989     291.1475      49.9441       0.1493       0.1685       0.2196       6.2421    2415.1016       7.1331     -29.0000    4756.0000
 2334.9204      42.1250      26.0772     135.7266     305.3133      64.7801      15.4368     216.0000       0.2107       0.1461       0.1150       9.3142      67.0373     285.0915     309.7229      49.9441       0.1203       0.1361       0.1854       6.2462    2460.2009       7.2938     -29.3125    4664.0000
 2335.0728      54.2566      27.0300      95.2263     512.1611      82.9383      12.0572     216.0000       0.1994       0.1338       0.1023       8.7979      67.6475     294.0227     324.0221      49.9441       0.0959       0.1089       0.1561       6.4058    2481.1873       6.6142     -29.3125    4568.0000
 2335.2252      59.2385      27.7866      72.9665     863.2638     124.2493       8.0483     216.0000       0.2148       0.1506       0.1197       8.7437      73.3039     312.4433     325.3262      49.9441       0.0668       0.0755       0.1203       6.6618    2452.5559       5.6798     -27.9375    4474.0000
 2335.3776      41.4812      25.0932      47.8524    1247.5424     198.7271       5.0320     216.0000       0.2657       0.2056       0.1767       8.7124      75.9929     337.8414     311.2271      49.9441       0.0894       0.1013       0.1483       6.9613    2358.4954       4.3240     -29.3125    4382.0000
 2335.5300      18.6711      15.0264      30.3762    1081.5255     273.5593       3.6555     216.0000       0.3342       0.2797       0.2535       8.7446      77.0099     354.8666     272.7826      49.9441       0.1511       0.1705       0.2216       7.2207    2231.7246       3.3962     -25.0625    4314.0000
 2335.6824      13.0856       8.7911      14.1934     598.3138     294.1826       3.3992     216.0000       0.3509       0.2978       0.2722       8.9294      74.1521     347.0518     252.5448      49.9441       0.1811       0.2037       0.2560       7.2867    2200.8359       3.2271     -30.6875    4206.0000
 2335.8348       7.5759       7.6692      11.2257     284.7781     212.1359       4.7140     216.0000       0.3482       0.2948       0.2692       8.8483      70.2876     348.7264     232.8746      49.9441       0.1968       0.2210       0.2737       7.2360    2205.8259       3.6685     -25.4375    4096.0000
 2335.9872      13.0095      12.7091      26.9321     140.6669     169.3140       5.9062     216.0000       0.3556       0.3029       0.2775       8.8070      70.6616     264.4380     210.4326      49.9441       0.1790       0.2023       0.2541       7.1296    2192.1082       3.5440     -29.3125    3963.0000
 2336.1396      30.1696      29.5075      43.0252      87.6769     124.7259       8.0176     216.0000       0.3543       0.3014       0.2760       8.6886      70.2991     266.1126     214.7298      49.9441       0.1207       0.1371       0.1865       7.0734    2194.6028       3.8810     -25.8750    3951.0000
 2336.2920      37.1646      62.9161     218.4216      67.8816     136.5924       7.3210     216.0000       0.3575       0.3049       0.2797       8.6438      70.5025     292.3481     227.3749      49.9441       0.1489       0.1690       0.2197       7.0483    2188.5505       4.2905     -28.0000    3960.0000
 2336.4444      48.9920     126.9799     796.3553      51.7579      60.5189      16.5238     216.0000       0.3305       0.2757       0.2494       8.5995      74.9557     276.1603     265.2964      49.9441       0.2739       0.3059       0.3585       7.0360    2238.5354       8.7365     -26.6250    3886.0000
 2336.5968      57.8063     108.1153     326.0151      47.8992      82.3122      12.1489     216.0000       0.3490       0.2958       0.2701       8.5381      80.0310     288.4407     252.9784      49.9441       0.2035       0.2299       0.2818       7.0417    2204.2661       9.8039     -28.9375    3782.0000
 2336.7492      45.6298     104.3853     127.4365      34.1209      42.8954      23.3125     216.0000       0.3260       0.2709       0.2443       8.5835      86.3363     298.7674     269.5737      49.9441       0.1332       0.1511       0.2012       6.9550    2246.8252      10.5798     -25.8125    3743.0000
 2336.9016      63.5649     104.4345     148.2965      36.6824      42.9496      23.2831     216.0000       0.2835       0.2249       0.1967       8.6543      84.7747     303.2330     303.2141      49.9441       0.1591       0.1796       0.2310       6.8125    2325.4465      13.2941     -25.9375    3720.0000
 2337.0540      48.0330      78.3938     246.5426      43.9204      45.5953      21.9321     216.0000       0.2099       0.1452       0.1141       8.6940      85.3837     311.8851     370.0304      49.9441       0.1372       0.1550       0.2053       6.6241    2461.6960      16.3559     -24.4375    3799.0000
 2337.2064      55.8335      81.6895     249.5553      67.6681      54.3886      18.3862     216.0000       0.1657       0.0974       0.0646       8.9749      77.6547     293.4644     416.2336      49.9441       0.1206       0.1365       0.1858       6.5442    2543.3740      25.2382     -19.5625    4035.0000
 2337.3588      58.1047      82.0499     310.5964     104.8097      94.7394      10.5553     216.0000       0.1747       0.1072       0.0747       8.4949      73.1258     285.0915     425.2067      49.9441       0.0728       0.0823       0.1278       6.6173    2526.7585      23.7230     -19.5625    4145.0000
 2337.5112      59.6556      71.7656     347.7173     167.0362      64.4992      15.5041     216.0000       0.2610       0.2005       0.1714       8.6437      70.2836     263.8798     372.6394      49.9441       0.0976       0.1106       0.1583       6.8307    2367.1245      10.6245     -19.0000    4189.0000
 2337.6636      48.4308      56.6618     162.0870     110.0506      33.0046      30.2988     216.0000       0.3284       0.2734       0.2470       8.0852      74.7583     274.2066     328.9088      49.9441       0.1670       0.1879       0.2396       6.9906    2242.4167       6.2631     -19.5625    4118.0000
 2337.8160      63.9467      74.0043     261.2576     168.0826      57.0941      17.5150     216.0000       0.3149       0.2588       0.2318       8.0615      77.8414     274.7647     332.8011      49.9441       0.1645       0.1852       0.2366       6.8724    2267.5259       6.3595     -19.3750    4055.0000
 2337.9684      81.2515     116.7225     390.6655     302.6972     109.2945       9.1496     216.0000       0.2520       0.1907       0.1613       8.0318      72.1570     282.8586     356.0045      49.9441       0.0749       0.0853       0.1304       6.5187    2383.8618      10.9375     -19.5625    3964.0000
 2338.1208      81.3017     157.8903     758.9855     553.1906     195.8943       5.1048     216.0000       0.1944       0.1285       0.0968       8.3802      65.6483     272.8111     358.2063      49.9441       0.0619       0.0715       0.1142       6.0619    2490.2874      28.8110     -17.5625    3789.0000
 2338.2732      75.8214     225.4046     995.8665     711.5024     294.4369       3.3963     216.0000       0.1698       0.1018       0.0691       8.6003      57.6929     277.8349     320.3311      49.9441       0.0464       0.0545       0.0947       5.6611    2535.9116      44.0898     -19.2500    3866.0000
 2338.4256      74.8373     263.7078     895.6507     538.6727     297.8039       3.3579     216.0000       0.1507       0.0812       0.0478       8.5532      53.2265     261.6470     291.4486      49.9441       0.0353       0.0421       0.0806       5.3720    2571.1982      60.6872     -17.2500    3820.0000
 2338.5780      69.3307     263.0273     569.6714     279.1754     173.8777       5.7512     216.0000       0.1448       0.0747       0.0411       8.3894      50.3790     256.6232     275.9185      49.9441       0.0397       0.0479       0.0863       5.2483    2582.1895      84.9412     -18.5625    3853.0000
 2338.7304      80.8551     429.3228    1950.0000     459.4157     221.7719       4.5091     216.0000       0.1488       0.0791       0.0456       8.3013      47.3619     261.6470     281.2462      49.9441       0.0397       0.0484       0.0865       5.2724    2574.7937      97.5734     -16.6250    3895.0000
 2338.8828      85.2307     447.1273    1943.8230     518.5276     246.1456       4.0626     216.0000       0.1490       0.0793       0.0458       8.0798      47.4263     256.6232     290.6957      49.9441       0.0349       0.0426       0.0802       5.3308    2574.3494      88.4874     -17.2500    3774.0000
 2339.0352      89.7351     372.7887    1950.0000     342.5229     202.4395       4.9397     216.0000       0.1488       0.0791       0.0456       8.1914      52.1044     256.6232     283.8919      49.9441       0.0426       0.0513       0.0901       5.3298    2574.7561      66.2659     -14.1875    3844.0000
 2339.1876      92.3901     291.3611    1327.3234     258.7543     170.9737       5.8489     216.0000       0.1465       0.0766       0.0430       8.1129      49.8431     250.7621     257.1537      49.9441       0.0464       0.0551       0.0949       5.2493    2579.0027      52.6498     -13.7500    3815.0000
 2339.3400      92.2543     232.1346     972.3611     348.8063     208.3138       4.8004     216.0000       0.1476       0.0779       0.0443       8.1025      49.3727     250.2039     229.6228      49.9441       0.0508       0.0597       0.1004       5.1405    2576.8530      48.1818     -13.0625    3861.0000
 2339.4924      90.8501     198.4138     835.5730     315.0926     197.6611       5.0592     216.0000       0.1642       0.0957       0.0628       8.0721      41.0334     258.2978     213.7904      49.9441       0.0522       0.0619       0.1022       5.1212    2546.3213      56.6621     -11.5625    3888.0000
 2339.6448      91.2114     179.9738     589.7745     253.2372     177.3145       5.6397     216.0000       0.1854       0.1187       0.0867       8.1536      44.7185     261.6470     220.9547      49.9441       0.0466       0.0557       0.0951       5.2462    2506.9729      64.8446     -12.7500    3918.0000
 2339.7972      97.3755     250.3520     494.5886     253.9274     155.1443       6.4456     216.0000       0.1865       0.1199       0.0879       8.3455      45.7302     263.3217     256.3472      49.9441       0.0350       0.0421       0.0802       5.4757    2505.0393      75.1454      -9.7500    3875.0000
 2339.9496     102.3230     258.6357     635.4202     252.1664     146.7422       6.8147     216.0000       0.1656       0.0973       0.0645       8.3629      45.5268     267.2290     307.4927      49.9441       0.0415       0.0496       0.0885       5.6865    2543.6184      79.5278      -9.7500    3900.0000
 2340.1020     114.1390     312.7784     950.6879     598.3067     176.4598       5.6670     216.0000       0.1583       0.0894       0.0563       8.2011      44.2779     263.8798     342.6978      49.9441       0.0450       0.0534       0.0930       5.8536    2557.1658      65.9986      -9.7500    3968.0000
 2340.2544     105.2163     280.9203     566.6582     335.1495     156.7812       6.3783     216.0000       0.1722       0.1044       0.0719       8.1234      48.1386     267.7872     353.3146      49.9441       0.0523       0.0615       0.1023       5.9633    2531.3933      35.9703      -9.7500    4073.0000
 2340.4068      92.0699     213.6475     332.8304     247.0191     106.2647       9.4105     216.0000       0.1845       0.1178       0.0857       7.9169      58.9186     264.4380     358.2013      49.9441       0.0661       0.0766       0.1195       6.0155    2508.5901      21.9515      -9.7500    3989.0000
 2340.5592     113.2687     262.4727     443.5312     267.2567     134.4668       7.4368     216.0000       0.1855       0.1188       0.0868       7.8273      66.6761     264.9962     357.6648      49.9441       0.0796       0.0917       0.1362       5.9610    2506.8318      16.9083      -8.5000    3958.0000
 2340.7116     114.0881     266.7498     403.4614     226.6674     166.8005       5.9952     216.0000       0.1726       0.1048       0.0723       8.0239      65.8641     264.1589     350.6143      49.9441       0.0851       0.0976       0.1430       5.8161    2530.7517      15.9253      -7.5625    3861.0000
 2340.8640     115.3066     408.5809     335.2545     248.0844     223.7424       4.4694     216.0000       0.1526       0.0832       0.0499       8.1427      61.2459     262.2052     319.5088      49.9441       0.0958       0.1099       0.1560       5.5509    2567.6968      18.5572      -7.5000    3734.0000
 2341.0164     130.2346     523.8735     393.4616     326.8405     359.4020       2.7824     216.0000       0.1419       0.0716       0.0379       8.1694      55.5185     254.9486     277.1633      49.9441       0.0681       0.0781       0.1220       5.2853    2587.5085      27.7395      -9.1875    3746.0000
 2341.1688     108.5208     177.4305     261.5706     257.9167     247.7793       4.0359     216.0000       0.1486       0.0789       0.0454       7.9087      56.1275     247.1338     235.3663      49.9441       0.0589       0.0679       0.1105       5.1191    2575.0620      37.3888      -6.1875    3788.0000
 2341.3212      75.6779     136.6443     107.9057     139.2331     113.8048       8.7870     216.0000       0.1786       0.1113       0.0790       8.0115      57.4914     251.3203     211.8745      49.9441       0.0532       0.0616       0.1033       5.1825    2519.6143      46.3516      -4.0000    3877.0000
 2341.4736      47.8993      60.4236      75.6404     104.3632      92.2761      10.8370     216.0000       0.2197       0.1559       0.1252       7.7651      60.5746     251.5994     220.5210      49.9441       0.0523       0.0602       0.1021       5.4532    2443.4863      39.2492      -4.1875    3827.0000
 2341.6260      65.2341      78.1312     132.7819     234.6789     211.0524       4.7382     216.0000       0.2522       0.1910       0.1616       8.0091      59.9656     254.9486     258.4083      49.9441       0.0803       0.0922       0.1370       5.7842    2383.4260      16.6602      -3.5000    3834.0000
 2341.7784      80.8650      81.6692     204.3434     245.0725     221.4635       4.5154     216.0000       0.2502       0.1889       0.1594       7.8427      63.9879     253.2740     307.6840      49.9441       0.1081       0.1229       0.1707       5.9519    2387.0564      14.5657      -3.1875    3853.0000
 2341.9308     109.1464     123.2983     281.5207     270.1156     251.1723       3.9813     216.0000       0.2257       0.1623       0.1318       8.0279      62.8047     268.9037     320.2333      49.9441       0.1227       0.1393       0.1881       5.8762    2432.4812      14.0859      -6.4375    3805.0000
 2342.0832     118.6427     186.4962     480.5942     234.5604     215.5858       4.6385     216.0000       0.1823       0.1154       0.0832       7.9672      63.2108     263.6007     303.5238      49.9441       0.0959       0.1090       0.1562       5.5774    2512.6768      20.4801      -2.7500    3788.0000
 2342.2356     116.3658     254.3991    1859.2247     218.4513     181.5053       5.5095     216.0000       0.1665       0.0983       0.0655       7.8039      61.2224     261.3680     268.3902      49.9441       0.0918       0.1046       0.1511       5.2961    2541.9578      20.5508      -4.1250    3770.0000
 2342.3880      98.9792     346.2758     995.0966     295.6306     303.9968       3.2895     216.0000       0.1491       0.0794       0.0459       7.7094      59.9648     259.6933     263.4576      49.9441       0.0912       0.1041       0.1503       5.1362    2574.2173      31.1600      -1.7500    3736.0000
 2342.5404      94.9034     293.6833     479.8502     223.7845     250.9326       3.9851     216.0000       0.1432       0.0730       0.0393       7.8519      56.9196     246.5756     276.3157      49.9441       0.0637       0.0731       0.1164       5.1376    2585.1497      42.9333      -1.6875    3727.0000
 2342.6928      82.8186     291.4500     354.7949     198.8603     192.0554       5.2068     216.0000       0.1381       0.0676       0.0337       7.7319      51.1933     246.0174     296.8373      49.9441       0.0590       0.0685       0.1107       5.2184    2594.4622      57.5333      -2.6250    3784.0000
 2342.8452      81.2427     229.3389     313.4769     198.3795     150.7015       6.6356     216.0000       0.1339       0.0630       0.0290       7.8533      54.0774     248.2502     310.4324      49.9441       0.0550       0.0645       0.1057       5.2648    2602.2268      50.6296      -1.7500    3892.0000
 2342.9976      84.9932     188.4978     270.3255     185.0744     131.3346       7.6141     216.0000       0.1250       0.0534       0.0190       7.8552      55.7015     248.8084     313.9706      49.9441       0.0551       0.0647       0.1059       5.2546    2618.6692      53.1550      -3.0625    3976.0000
 2343.1500      87.2939     189.8360     342.5455     231.9037     146.0109       6.8488     216.0000       0.1113       0.0385       0.0035       7.7559      57.7667     254.1113     307.5004      49.9441       0.0467       0.0548       0.0952       5.1905    2644.1665      52.3424      -0.6875    3988.0000
 2343.3024      93.1818     194.2689     418.4238     263.7209     166.5768       6.0032     216.0000       0.1094       0.0365       0.0014       7.6963      57.3233     254.3904     299.2270      49.9441       0.0523       0.0612       0.1023       5.1398    2647.6497      56.7790      -1.3750    4001.0000
 2343.4548      95.4161     207.3071     475.4387     304.5590     195.9149       5.1043     216.0000       0.1205       0.0485       0.0139       7.8165      55.6992     261.3680     304.3656      49.9441       0.0558       0.0655       0.1067       5.1481    2627.1355      53.9953      -1.3125    3886.0000
 2343.6072      90.9707     205.6966     469.3303     279.2340     211.8122       4.7212     216.0000       0.1292       0.0579       0.0236       7.7915      62.1607     258.8560     330.1890      49.9441       0.0594       0.0693       0.1112       5.1932    2611.0215      55.4082      -4.5000    3798.0000
 2343.7596      85.4636     193.3354     413.5776     276.2415     217.6045       4.5955     216.0000       0.1186       0.0464       0.0117       7.9606      57.0758     252.1576     362.1790      49.9441       0.0675       0.0783       0.1214       5.2112    2630.6587      55.2954      -1.0625    3825.0000
 2343.9120      82.2772     179.4826     349.0433     246.7248     201.2569       4.9688     216.0000       0.1091       0.0361       0.0011       7.9398      63.2089     252.1576     355.3214      49.9441       0.0695       0.0798       0.1237       5.1302    2648.2561      57.5696      -2.3125    3827.0000
 2344.0644      84.0519     197.8093     285.9651     209.3411     191.3891       5.2250     216.0000       0.0925       0.0183      -0.0174       7.9551      55.6644     258.5769     318.0554      49.9441       0.0771       0.0884       0.1331       4.9280    2678.7839      61.9075      -1.5625    3869.0000
 2344.2168      79.0305     184.0767     351.1145     234.1821     200.7377       4.9816     216.0000       0.0866       0.0118      -0.0242       7.4701      61.7662     246.5756     267.6070      49.9441       0.0810       0.0927       0.1379       4.6997    2689.8584      81.9493      -0.3750    3875.0000
 2344.3692      79.8449     190.4038     285.0863     195.0427     171.4066       5.8341     216.0000       0.0876       0.0129      -0.0230       7.2040      57.6983     248.2502     243.3393      49.9441       0.0826       0.0944       0.1398       4.5763    2687.8721      95.1403      -1.2500    3798.0000
 2344.5216      84.7517     216.4848     355.0154     210.8392     187.8483       5.3234     216.0000       0.1026       0.0291      -0.0062       7.2675      59.9152     244.3428     243.0875      49.9441       0.0831       0.0950       0.1405       4.6082    2660.2454     103.0442      -1.9375    3783.0000
 2344.6740      79.4167     207.8335     298.2629     200.4391     172.8374       5.7858     216.0000       0.1111       0.0383       0.0033       7.2062      56.6609     251.0412     252.2047      49.9441       0.0864       0.0987       0.1446       4.6707    2644.5537      71.2182      -4.3125    3714.0000
 2344.8264      79.8858     180.4009     263.3388     171.6700     145.3694       6.8790     216.0000       0.1037       0.0304      -0.0049       7.7573      58.8591     240.9936     248.4994      49.9441       0.0820       0.0938       0.1392       4.6320    2658.0801      60.4362      -1.7500    3735.0000
 2344.9788      80.1855     165.7108     252.8115     172.4845     136.2248       7.3408     216.0000       0.1007       0.0271      -0.0083       7.4476      62.7656     248.2502     216.1794      49.9441       0.0730       0.0834       0.1281       4.4733    2663.6223      47.6866      -4.3125    3790.0000
 2345.1312      79.3165     170.7292     258.4752     196.3786     141.2723       7.0785     216.0000       0.1035       0.0301      -0.0052       7.9121      66.6301     245.7383     171.7217      49.9441       0.0836       0.0959       0.1412       4.2710    2658.5400      48.3780      -0.3125    3791.0000
 2345.2836      79.5387     186.4002     281.5295     224.6339     152.3468       6.5640     216.0000       0.1270       0.0555       0.0212       7.9402      65.8557     244.9010     119.4809      49.9441       0.0807       0.0929       0.1376       4.0941    2615.0737      49.0443      -5.1875    3762.0000
 2345.4360      82.3076     206.1842     313.8598     211.6636     157.9700       6.3303     216.0000       0.1416       0.0713       0.0376       7.8179      60.3743     245.4592      88.5034      49.9441       0.0638       0.0738       0.1166       3.9834    2588.0142      52.7095      -4.1250    3779.0000
 2345.5884      87.2257     229.6457     345.9695     219.2487     167.6982       5.9631     216.0000       0.1518       0.0824       0.0490       7.3773      51.4005     243.2264      75.1629      49.9441       0.0602       0.0703       0.1122       3.9316    2569.1558      42.5784      -3.8125    3764.0000
 2345.7408      82.0496     217.4955     463.4467     310.3651     224.5367       4.4536     216.0000       0.1495       0.0799       0.0464       7.2320      48.4328     244.3428      79.1535      49.9441       0.0470       0.0553       0.0955       3.9363    2573.4492      41.1653      -4.1875    3807.0000
 2345.8932      87.7194     244.8020     464.4002     332.9694     240.6864       4.1548     216.0000       0.1530       0.0836       0.0503       7.2705      48.2298     246.5756      90.4126      49.9441       0.0491       0.0585       0.0983       4.0129    2566.9934      46.9672      -3.7500    3783.0000
 2346.0456      87.7873     224.2417     453.4716     344.0827     272.7523       3.6663     216.0000       0.1542       0.0850       0.0517       7.3903      54.5594     244.9010     109.7591      49.9441       0.0439       0.0524       0.0917       4.1615    2564.6975      65.7431      -4.3125    3764.0000
 2346.1980      77.5564     131.1046     291.8708     251.5524     196.8515       5.0800     216.0000       0.1435       0.0734       0.0397       7.5399      54.0694     238.7608     132.0836      49.9441       0.0409       0.0487       0.0878       4.2973    2584.5107      60.5345      -4.0625    3795.0000
 2346.3504      77.0263     137.2802     305.8942     268.0343     225.9023       4.4267     216.0000       0.1434       0.0733       0.0396       7.6578      53.2573     243.5055     141.5894      49.9441       0.0403       0.0475       0.0869       4.4052    2584.6218      60.2673      -5.8750    3805.0000
 2346.5028      84.7272     180.5601     432.8483     405.5283     346.6909       2.8844     216.0000       0.1590       0.0901       0.0571       7.4454      46.7247     246.5756     146.9991      49.9441       0.0522       0.0609       0.1020       4.5456    2555.8562      42.9712      -2.7500    3781.0000
 2346.6552      78.4103     175.5819     391.0397     345.0806     292.1385       3.4230     216.0000       0.1711       0.1033       0.0707       7.3454      52.6364     250.4830     173.4929      49.9441       0.0671       0.0773       0.1208       4.7578    2533.3767      35.1087      -5.3750    3772.0000
 2346.8076      71.6420     143.7080     283.3201     241.6016     212.2840       4.7107     216.0000       0.1641       0.0957       0.0628       7.3315      57.1027     248.2502     222.9705      49.9441       0.0994       0.1133       0.1603       4.9964    2546.3542      29.0737      -3.1875    3775.0000
 2346.9600      72.0076     148.8613     269.3431     212.4787     186.8755       5.3512     216.0000       0.1280       0.0566       0.0223       7.4878      67.7032     254.3904     296.1483      49.9441       0.1129       0.1279       0.1765       5.1538    2613.1567      33.3732      -2.3750    3800.0000
 2347.1124      73.6900     156.3314     284.3128     227.1224     198.8126       5.0299     216.0000       0.1019       0.0284      -0.0070       7.4606      71.1478     248.2502     350.3654      49.9441       0.1210       0.1370       0.1863       5.2427    2661.4858      37.9671      -1.8750    3796.0000
 2347.2648      86.7482     205.0668     297.0824     293.6499     240.6154       4.1560     216.0000       0.0951       0.0210      -0.0146       7.3007      76.4262     249.0875     353.2200      49.9441       0.1233       0.1396       0.1889       5.2274    2674.0708      22.0104      -3.1250    3783.0000
 2347.4172      91.3983     256.7055     382.0292     292.0672     227.4457       4.3967     216.0000       0.1049       0.0316      -0.0036       7.0755      74.1493     249.3666     293.2854      49.9441       0.1307       0.1479       0.1976       5.0507    2655.9175      15.5853      -2.0625    3821.0000
 2347.5696     105.0363     271.0966     552.2408     260.6797     204.7348       4.8844     216.0000       0.1116       0.0388       0.0039       7.1613      70.4882     245.4592     206.2347      49.9441       0.1004       0.1141       0.1616       4.7049    2643.5774      17.0921      -4.1250    3780.0000
 2347.7220     113.4974     422.2856     792.4213     803.1802     295.1569       3.3880     216.0000       0.1114       0.0387       0.0037       7.1710      61.9961     263.8798     132.8876      49.9441       0.0640       0.0730       0.1169       4.3237    2643.8569      38.3099      -4.5625    3815.0000
 2347.8744      99.7863     328.7705     790.6318     439.9988     489.8117       2.0416     216.0000       0.1205       0.0485       0.0139       7.3316      64.1568     251.0412      79.2899      49.9441       0.0695       0.0792       0.1237       4.0250    2627.1360      29.7727      -3.1875    3827.0000
 2348.0268      98.2034     222.5482     480.5047     272.6656     261.3609       3.8261     216.0000       0.1340       0.0631       0.0290       7.5479      62.5296     244.9010      52.2239      49.9441       0.1204       0.1366       0.1854       3.8978    2602.1724      30.4363      -3.0000    3820.0000
 2348.1792     111.9633     139.1133     292.2857     185.4271     182.2248       5.4877     216.0000       0.1385       0.0680       0.0341       7.4666      63.9161     256.6232      66.0315      49.9441       0.1154       0.1310       0.1795       3.9828    2593.7468      34.4522      -3.1875    3831.0000
 2348.3316     103.3291     122.8256     239.0058     174.7635     158.7719       6.2983     216.0000       0.1559       0.0868       0.0536       7.1015      64.5977     252.7158     100.9428      49.9441       0.0710       0.0806       0.1255       4.2977    2561.5430      69.5017      -4.0000    3827.0000
 2348.4840      84.7586     124.5319     185.7581     148.9703     120.3627       8.3082     216.0000       0.1797       0.1126       0.0803       7.0841      66.4282     258.8560     144.6085      49.9441       0.0601       0.0683       0.1120       4.7374    2517.4863      24.1569      -1.9375    3818.0000
 2348.6364      63.7186      95.0848     109.9853     109.3468      91.8033      10.8928     216.0000       0.1878       0.1213       0.0894       7.1983      72.9741     258.8560     185.7965      49.9441       0.0950       0.1081       0.1550       5.1154    2502.5085      11.8439      -2.0625    3845.0000
 2348.7888      41.7617      60.0912      76.2024     100.5039      61.8120      16.1781     216.0000       0.1792       0.1120       0.0797       7.0464      76.0194     260.5306     215.1806      49.9441       0.1165       0.1321       0.1809       5.3673    2518.4871      11.9981      -0.7500    3863.0000
 2348.9412      44.4689      91.5052     119.0116     116.0091      78.5859      12.7249     216.0000       0.1641       0.0957       0.0628       7.2534      82.8797     266.1126     239.0568      49.9441       0.1271       0.1438       0.1936       5.5027    2546.3677      10.8678       0.0000    3877.0000
 2349.0936      56.1328     123.4993     321.6521     185.4115     118.7441       8.4215     216.0000       0.1891       0.1227       0.0908       7.1070      86.9476     272.8111     226.6698      49.9441       0.1625       0.1834       0.2349       5.5971    2500.1584      12.9446       0.0000    3882.0000
 2349.2460      54.4901     128.5796     376.9788     347.8170     197.5460       5.0621     216.0000       0.2151       0.1508       0.1199       7.2637      88.9943     296.8137     215.0891      49.9441       0.2012       0.2261       0.2788       5.6619    2452.0925       8.6617       0.0000    3839.0000
 2349.3984      57.0938      96.5699     270.9012     268.6107     173.4459       5.7655     216.0000       0.2232       0.1596       0.1290       7.0304      86.6087     292.3481     214.3452      49.9441       0.1869       0.2104       0.2627       5.6720    2437.1096       8.3516       0.0000    3829.0000
 2349.5508      48.4165      71.7807     208.8833     151.4396     132.6537       7.5384     216.0000       0.2091       0.1444       0.1133       6.9714      87.0155     307.9777     219.3790      49.9441       0.1446       0.1633       0.2141       5.5974    2463.1055       8.8226       0.0000    3835.0000
 2349.7032      59.9595      85.6595     311.5697     218.6844     210.3533       4.7539     216.0000       0.1793       0.1121       0.0798       6.9938      86.1869     262.4843     206.5828      49.9441       0.1550       0.1749       0.2262       5.3856    2518.3745       8.5914       0.0000    3791.0000
 2349.8556      68.8022     107.9789     323.6456     273.6370     223.5511       4.4733     216.0000       0.1718       0.1040       0.0714       7.0274      87.3544     268.3454     144.1426      49.9441       0.1244       0.1408       0.1905       5.0595    2532.1223      10.7407       0.0000    3812.0000
 2350.0080      60.5105     106.7618     776.7889     552.1673     466.0567       2.1457     216.0000       0.1612       0.0925       0.0595       7.0439      80.2356     252.1576      83.3871      49.9441       0.1297       0.1469       0.1969       4.6810    2551.8076      12.9783       0.0000    3812.0000
 2350.1604      48.8342     101.9580     203.5014     182.6482     300.0419       3.3329     216.0000       0.1778       0.1105       0.0781       7.0136      75.1602     256.6232      55.9103      49.9441       0.1254       0.1419       0.1917       4.5009    2521.1011      27.0194       0.0000    3816.0000
 2350.3128      39.9233      88.9297     303.2890     285.9409     133.7671       7.4757     216.0000       0.2204       0.1566       0.1259       7.0030      73.3330     263.3217      66.5114      49.9441       0.0995       0.1126       0.1607       4.6157    2442.2942      14.3369       0.0000    3816.0000
 2350.4652      33.5850      76.1175     218.8761     243.0662     110.2237       9.0725     216.0000       0.2443       0.1825       0.1527       7.0273      77.0511     267.7872      95.9575      49.9441       0.1379       0.1559       0.2064       4.8338    2397.9949       7.3216       0.6875    3803.0000
 2350.6176      30.5507      54.5116     157.7327     182.2555      90.6220      11.0349     216.0000       0.2318       0.1689       0.1387       7.0356      81.2927     256.0650     102.8535      49.9441       0.2567       0.2861       0.3396       4.8343    2421.2224       7.1281       1.5625    3758.0000
 2350.7700      33.6384      67.5001     193.5354     152.7738     125.7545       7.9520     216.0000       0.2045       0.1394       0.1081       6.9925      83.9485     265.2753      86.8123      49.9441       0.1337       0.1514       0.2017       4.6182    2471.6343      13.4019       1.8125    3757.0000
 2350.9224      38.0302      87.5312     183.2188     127.8150     127.0988       7.8679     216.0000       0.1913       0.1251       0.0933       6.8828      83.4847     248.5293      68.1994      49.9441       0.1186       0.1342       0.1836       4.3959    2496.0042      21.8744       1.8125    3759.0000
 2351.0748      36.9710      69.0463     265.0073     110.9807      99.3283      10.0676     216.0000       0.1856       0.1190       0.0869       6.9223      82.8974     252.9949      56.4125      49.9441       0.1465       0.1654       0.2161       4.2262    2506.5562      10.3675       3.7500    3823.0000
 2351.2272      26.5594      57.5025     237.0225     296.4288     196.1067       5.0993     216.0000       0.1584       0.0894       0.0563       6.5382      78.6175     246.0174      46.8907      49.9441       0.1489       0.1679       0.2188       3.9862    2557.0500      10.5973       2.3750    3787.0000
 2351.3796      34.9067      57.8127     246.3092     442.9929     217.8841       4.5896     216.0000       0.1356       0.0649       0.0308       6.5002      72.9225     256.6232      23.6948      49.9441       0.0941       0.1067       0.1540       3.6369    2599.1013      20.0219       4.5000    3829.0000
 2351.5320      36.2261      59.2229     183.1776     152.4430     164.9444       6.0626     216.0000       0.1287       0.0574       0.0231       6.6019      67.2776     242.1100       3.0546      49.9441       0.0845       0.0957       0.1422       3.4239    2611.8215     103.5350       3.8125    3844.0000
 2351.6844      32.1790      47.6365     191.9951     204.7275     172.7814       5.7877     216.0000       0.1409       0.0706       0.0368       6.8496      68.4957     254.3904      12.2380      49.9441       0.0894       0.1015       0.1483       3.6192    2589.2539     103.9005       6.3125    3803.0000
 2351.8368      30.2199      44.0778     177.8638     261.1615     144.1100       6.9391     216.0000       0.1678       0.0996       0.0669       7.1816      72.3130     255.5068      53.8106      49.9441       0.0975       0.1106       0.1581       4.1735    2539.6060      35.2343       4.8750    3805.0000
 2351.9892      35.1034      55.1170     259.4697     249.2179     131.9439       7.5790     216.0000       0.1822       0.1152       0.0830       7.0120      75.0150     256.0650     125.5538      49.9441       0.1174       0.1329       0.1819       4.7687    2513.0146      12.6829       5.2500    3797.0000
 2352.1416      44.2002      81.2159     421.8507     269.3105     230.4249       4.3398     216.0000       0.1614       0.0928       0.0598       6.7948      76.4361     259.4142     187.7289      49.9441       0.1384       0.1563       0.2067       4.9984    2551.3877      10.6694       1.6875    3806.0000
 2352.2940      52.4086     125.2415    1186.4156     167.7847     141.0228       7.0911     216.0000       0.1351       0.0643       0.0303       6.6496      78.1105     254.1113     199.5871      49.9441       0.1482       0.1672       0.2181       4.8670    2599.9736      15.3618       3.0625    3818.0000
 2352.4464      57.9966     146.3899     863.0646     175.6102     105.3418       9.4929     216.0000       0.1215       0.0496       0.0150       6.6572      74.3915     262.7634     164.4294      49.9441       0.1103       0.1250       0.1735       4.5757    2625.1729      39.8143       4.0000    3813.0000
 2352.5988      58.8272     156.3867     343.8097     102.6429      89.2536      11.2040     216.0000       0.1307       0.0595       0.0253       6.5180      75.0005     261.0888     118.9961      49.9441       0.0845       0.0958       0.1423       4.3514    2608.2129      47.4025       3.6250    3807.0000
 2352.7512      55.1061     128.6409     241.1996     111.7306      83.5884      11.9634     216.0000       0.1495       0.0798       0.0464       6.7046      73.1232     257.1814      91.7451      49.9441       0.0945       0.1073       0.1545       4.2601    2573.4714      50.7010       4.9375    3779.0000
 2352.9036      49.8029      99.5359     178.9494     115.0648      66.7868      14.9730     216.0000       0.1633       0.0947       0.0618       6.8111      75.7579     276.7184      77.5135      49.9441       0.0882       0.1001       0.1468       4.2637    2547.9827      23.0272       4.3125    3781.0000
 2353.0560      47.7290      76.0900     127.0274     116.1828      53.4722      18.7013     216.0000       0.1589       0.0900       0.0569       6.7287      75.3518     260.8097      76.6766      49.9441       0.1292       0.1461       0.1958       4.3180    2556.1160      22.2712       5.8125    3752.0000
 2353.2084      54.4982      80.8876     149.2583     127.9385      60.4401      16.5453     216.0000       0.1544       0.0852       0.0520       6.4006      73.9748     271.1364      78.8684      49.9441       0.1427       0.1612       0.2117       4.4093    2564.2681      21.1466       4.6250    3842.0000
 2353.3608      58.9244     115.3144     223.6650     163.0255      76.1585      13.1305     216.0000       0.1527       0.0833       0.0499       6.6441      76.6284     267.5081      94.0850      49.9441       0.1024       0.1159       0.1641       4.5850    2567.5825      41.0097       5.6250    3957.0000
 2353.5132      56.3975     129.5491     199.8767     135.8588     117.9355       8.4792     216.0000       0.1666       0.0984       0.0656       6.5407      71.7561     259.4142     117.1763      49.9441       0.0945       0.1070       0.1545       4.8392    2541.7468      16.2284       4.2500    3963.0000
 2353.6656      49.0240      98.7843     186.0612     115.5578     113.4880       8.8115     216.0000       0.1798       0.1126       0.0804       6.4539      70.6969     254.9486     139.7963      49.9441       0.1130       0.1279       0.1768       5.0718    2517.4023       8.0239       4.6875    4052.0000
 2353.8180      42.0853      53.9186     108.8025      66.6088     129.8915       7.6987     216.0000       0.1744       0.1068       0.0743       6.4570      73.5444     263.3217     149.1191      49.9441       0.1660       0.1869       0.2387       5.0937    2527.3674       6.6300       4.5000    3976.0000
 2353.9704      52.1664      55.9431     100.7029      70.7356     176.3227       5.6714     216.0000       0.1499       0.0803       0.0468       6.4109      76.8413     276.1603     132.6907      49.9441       0.2027       0.2270       0.2801       4.8694    2572.7134       7.4852       3.7500    3879.0000
 2354.1228      54.1293     100.9910      99.7085     127.1319     224.6704       4.4510     216.0000       0.1247       0.0531       0.0186       6.7189      76.3179     270.8573     105.3503      49.9441       0.1130       0.1279       0.1768       4.5595    2619.2749      14.0959       4.8125    3792.0000
 2354.2752      39.5657      63.7080     112.9260     132.8245     213.8190       4.6769     216.0000       0.1424       0.0721       0.0384       6.6584      70.4195     247.1338      80.2011      49.9441       0.0573       0.0646       0.1084       4.4787    2586.6318      30.6153       4.1250    3746.0000
 2354.4276      25.7895      35.3680      51.5049     151.7340     190.0697       5.2612     216.0000       0.1794       0.1122       0.0800       6.4512      66.4324     236.5280      96.1969      49.9441       0.0690       0.0782       0.1230       4.7778    2518.0559      13.4913       5.3125    3808.0000
 2354.5800      18.9523      20.6140      28.5681     134.2091     127.6140       7.8361     216.0000       0.1987       0.1331       0.1015       6.1146      74.3709     242.6682     156.9610      49.9441       0.1009       0.1144       0.1622       5.2906    2482.4719       8.7480       0.4375    3847.0000
 2354.7324      18.9227      17.2523      27.6836     138.5823     101.9322       9.8104     216.0000       0.2025       0.1372       0.1059       6.0591      79.0490     260.2515     224.5634      49.9441       0.1642       0.1849       0.2367       5.7142    2475.3164       7.1793       5.1875    3920.0000
 2354.8848      28.0501      28.5403      69.0513     158.4019     177.2010       5.6433     216.0000       0.2000       0.1345       0.1030       6.3144      86.2904     272.8111     264.5052      49.9441       0.2236       0.2509       0.3038       5.8625    2480.0283       6.2144       0.0000    3909.0000
 2355.0372      63.3554      55.3856      88.2617     174.1055     199.3102       5.0173     216.0000       0.1984       0.1328       0.1012       6.5324      80.9054     296.8137     259.2313      49.9441       0.2653       0.2972       0.3495       5.7420    2482.9827       7.2071       2.3750    3849.0000
 2355.1896      89.6594     112.1923     612.0009      98.5709     225.4639       4.4353     216.0000       0.2092       0.1444       0.1133       6.7105      82.4790     262.7634     222.1520      49.9441       0.1733       0.1956       0.2475       5.4909    2463.0544       8.1287       2.8125    3896.0000
 2355.3420      99.9125     147.7295    1403.5115     164.0887     348.4540       2.8698     216.0000       0.2330       0.1702       0.1400       6.7585      79.8349     265.5544     172.4658      49.9441       0.1062       0.1202       0.1688       5.2330    2418.9465       7.9473       5.1875    3872.0000
 2355.4944      93.4209     182.8797     492.9799     137.7881     225.1554       4.4414     216.0000       0.2381       0.1757       0.1458       6.4206      78.3638     248.2502     136.3325      49.9441       0.1491       0.1683       0.2191       4.9983    2409.4851       7.3701       2.9375    3858.0000
 2355.6468      82.8029     201.9072     269.1040     148.8154     104.1589       9.6007     216.0000       0.2097       0.1450       0.1139       5.9621      67.6375     258.0187     123.4472      49.9441       0.1009       0.1146       0.1622       4.7942    2462.0479       9.2723       4.1875    3840.0000
 2355.7992      62.5019     136.1211     177.9615     141.6151      92.6815      10.7896     216.0000       0.1857       0.1191       0.0870       6.1307      63.5696     249.3666     129.7548      49.9441       0.0536       0.0603       0.1037       4.7205    2506.4143      19.9224       4.1250    3816.0000
 2355.9516      49.6094     117.3429     121.5982      98.3950      71.6778      13.9513     216.0000       0.1852       0.1185       0.0864       6.3667      68.4396     246.0174     154.0654      49.9441       0.0828       0.0940       0.1401       4.8213    2507.3733      23.4811       5.2500    3866.0000
 2356.1040      50.2187      68.0497     103.8889      88.3804      59.3908      16.8376     216.0000       0.1806       0.1135       0.0812       6.4716      80.8467     235.9698     209.8112      49.9441       0.1278       0.1445       0.1944       5.0431    2515.9812      14.3057       5.5000    3932.0000
 2356.2564      54.2156      70.2662     124.6042     101.7890      77.4241      12.9159     216.0000       0.1646       0.0963       0.0634       6.0122      87.3554     247.1338     243.9294      49.9441       0.1657       0.1866       0.2384       5.1745    2545.4028      12.1042       2.2500    3990.0000
 2356.4088      59.3537      62.5788     128.9623     111.7148      76.6680      13.0433     216.0000       0.1449       0.0749       0.0413       5.6926      84.1594     265.5544     248.6033      49.9441       0.1752       0.1972       0.2493       5.1647    2581.8552      11.2491       2.0000    4036.0000
 2356.5612      51.3698      66.7822     117.3704     111.7410      87.2256      11.4645     216.0000       0.1289       0.0576       0.0234       5.6770      79.6364     266.1126     222.6045      49.9441       0.1467       0.1656       0.2165       5.0559    2611.4663      14.6849       2.8750    3984.0000
 2356.7136      56.1629      70.8980     119.4091     119.4882     101.6900       9.8338     216.0000       0.1213       0.0494       0.0148       5.9491      72.7210     252.1576     201.0403      49.9441       0.1209       0.1368       0.1862       4.9877    2625.5281      23.0692       5.1875    3914.0000
 2356.8660      42.8935      81.9627     133.6689     143.3189     101.8996       9.8136     216.0000       0.1321       0.0611       0.0269       6.3201      71.9490     246.5756     204.3340      49.9441       0.0866       0.0980       0.1449       5.1061    2605.5701      36.0704       2.4375    3877.0000
 2357.0184      38.2440     101.0818     111.0448     159.9808     138.0082       7.2459     216.0000       0.1900       0.1236       0.0918       6.7412      70.5735     255.5068     217.7901      49.9441       0.0831       0.0939       0.1407       5.4431    2498.5598      16.6019       3.4375    3897.0000
 2357.1708      30.2009      64.0195     146.4662     154.7984     112.7898       8.8661     216.0000       0.2715       0.2118       0.1832       6.7735      77.0822     263.0425     217.5484      49.9441       0.1356       0.1532       0.2036       5.8545    2347.7407       5.7143       0.0000    3928.0000
 2357.3232      21.8131      25.2031      36.9692      66.8314      62.9976      15.8736     216.0000       0.2866       0.2282       0.2001       6.5073      84.3506     276.7184     208.2043      49.9441       0.2000       0.2243       0.2772       5.9719    2319.7651       4.0556       0.0000    3934.0000
 2357.4756      39.3212      34.4991      49.7025      70.6221      50.5797      19.7708     216.0000       0.2484       0.1869       0.1573       5.9455      85.9291     302.3957     167.9714      49.9441       0.2121       0.2374       0.2906       5.6560    2390.4038       4.3956       0.0000    3904.0000
 2357.6280      54.5931     104.3285     121.6947     177.1129     147.8485       6.7637     216.0000       0.1896       0.1233       0.0914       5.5429      81.0476     259.9724     140.1110      49.9441       0.2163       0.2419       0.2952       5.0767    2499.1719       8.1232      -0.2500    3843.0000
 2357.7804      87.0487     129.6654     256.3040     329.3706     245.0196       4.0813     216.0000       0.1742       0.1066       0.0741       5.3128      69.7160     242.6682     122.6106      49.9441       0.1458       0.1646       0.2152       4.6428    2527.7134      13.8090      -1.6875    3894.0000
 2357.9328     113.1212     272.7130    1438.1284    1255.1240    1075.9807       0.9294     216.0000       0.1688       0.1007       0.0680       5.6153      60.9864     246.0174     143.7037      49.9441       0.0529       0.0604       0.1028       4.5144    2537.7959      27.4493      -4.8750    3797.0000
 2358.0852      82.9776     477.0557    1056.5732     619.1811     688.7903       1.4518     216.0000       0.1530       0.0836       0.0503       5.7830      52.7311     246.8547     179.8780      49.9441       0.0344       0.0400       0.0792       4.5932    2566.9941      29.0564      -4.0000    3837.0000
 2358.2376      85.5767     385.1699     558.6281     383.3068     280.1172       3.5699     216.0000       0.1412       0.0709       0.0371       5.7446      52.4908     248.2502     207.4263      49.9441       0.0452       0.0533       0.0932       4.7051    2588.7708      37.7972      -5.4375    3856.0000
 2358.3900      84.5144     368.4399     409.4180     469.1972     184.4943       5.4202     216.0000       0.1354       0.0646       0.0306       5.6194      52.2878     240.1563     220.1979      49.9441       0.0562       0.0660       0.1072       4.7650    2599.5520      49.2297      -5.7500    3862.0000
 2358.5424      77.3289     281.2369     395.6926     535.1403     150.4932       6.6448     216.0000       0.1374       0.0667       0.0328       5.5412      56.2718     243.5055     217.0706      49.9441       0.0553       0.0648       0.1061       4.7619    2595.8728      69.1920      -7.7500    3873.0000
 2358.6948      76.0720     212.9543     423.6790     360.9212     130.5468       7.6601     216.0000       0.1393       0.0688       0.0350       5.8251      54.6815     244.9010     215.7676      49.9441       0.0526       0.0616       0.1026       4.7436    2592.3201      62.9292      -6.1875    3845.0000
 2358.8472      79.3558     154.7893     335.5544     291.4757     115.9554       8.6240     216.0000       0.1380       0.0674       0.0335       5.9583      51.8393     240.4354     214.5386      49.9441       0.0579       0.0677       0.1093       4.7215    2594.7717      55.3076      -6.3750    3846.0000
 2358.9996      85.1779     128.5628     325.3025     262.8366     130.1219       7.6851     216.0000       0.1304       0.0592       0.0250       6.2844      48.3515     243.2264     221.8938      49.9441       0.0618       0.0722       0.1142       4.7150    2608.7639      55.5321      -6.8125    3864.0000
 2359.1520      88.8657     130.5312     357.7359     250.3764     165.9283       6.0267     216.0000       0.1270       0.0556       0.0212       6.7772      47.9447     243.7846     223.4738      49.9441       0.0526       0.0615       0.1026       4.7116    2614.9736      64.4931      -7.2500    3835.0000
 2359.3044      97.9562     147.8423     339.2673     224.9821     161.6269       6.1871     216.0000       0.1271       0.0556       0.0212       6.4218      51.8358     248.8084     224.8924      49.9441       0.0481       0.0567       0.0970       4.7111    2614.9490      74.5277      -6.1250    3869.0000
 2359.4568     109.2202     160.0546     315.3557     178.8038     169.2974       5.9068     216.0000       0.1282       0.0568       0.0225       5.9200      53.2569     238.4817     221.3676      49.9441       0.0586       0.0686       0.1103       4.7247    2612.8521      88.9857      -8.6250    3816.0000
 2359.6092     116.4132     267.9717     266.1674     218.0179     174.5193       5.7300     216.0000       0.1193       0.0472       0.0126       5.2124      52.3686     238.7608     212.3105      49.9441       0.0574       0.0672       0.1087       4.7231    2629.2170      88.4427      -9.7500    3835.0000
 2359.7616      84.3077     391.0142     227.3235     168.9536     140.8490       7.0998     216.0000       0.1099       0.0371       0.0021       4.9335      53.5528     240.4354     205.3733      49.9441       0.0526       0.0613       0.1026       4.7562    2646.6150      99.0309      -8.1875    3894.0000
 2359.9140      63.3878     212.6455     161.8464     144.5117     124.3945       8.0389     216.0000       0.1109       0.0381       0.0031       4.9898      57.8161     239.3190     194.6178      49.9441       0.0522       0.0612       0.1021       4.8418    2644.8606     114.3596      -9.1875    3920.0000
 2360.0664      61.8558     183.3016     151.6319     152.1278     109.2883       9.1501     216.0000       0.1405       0.0701       0.0363       5.5182      61.3487     243.2264     193.2929      49.9441       0.0480       0.0556       0.0967       5.0405    2590.0444      81.4730      -8.2500    3971.0000
 2360.2188      49.6019     143.6962     150.6733     166.7046     116.1306       8.6110     216.0000       0.2246       0.1611       0.1306       5.2753      65.8595     242.6682     177.4402      49.9441       0.0659       0.0757       0.1192       5.3504    2434.4836      22.3030      -8.5000    4036.0000
 2360.3712      42.5965     140.6711     220.1512     227.6347     174.3374       5.7360     216.0000       0.3211       0.2655       0.2388       5.7006      68.2506     238.2026     160.3501      49.9441       0.0923       0.1049       0.1518       5.6213    2255.9663       5.1940      -8.1875    3995.0000
 2360.5236      46.8505      98.8689     115.7015     168.8065     146.5090       6.8255     216.0000       0.3504       0.2972       0.2717       5.7052      74.5559     248.8084     144.8171      49.9441       0.1554       0.1751       0.2263       5.5900    2201.7314       3.4051      -8.3125    3904.0000
 2360.6760      44.2312      71.1432     108.9982     181.5582     187.3955       5.3363     216.0000       0.2880       0.2297       0.2017       5.8254      78.0136     243.7846     130.6729      49.9441       0.2486       0.2759       0.3298       5.1234    2317.2190       3.6704      -8.1875    3852.0000
 2360.8284      75.1463      88.3199     197.5604     246.2124     285.1679       3.5067     216.0000       0.2135       0.1491       0.1182       5.5152      72.1712     260.2515     102.2933      49.9441       0.0906       0.1039       0.1496       4.5410    2455.0098       7.9356      -8.6875    3831.0000
 2360.9808      85.4602     147.9742     222.2975     257.2303     367.5151       2.7210     216.0000       0.1734       0.1057       0.0732       5.4510      59.9405     259.4142     108.5246      49.9441       0.0245       0.0282       0.0662       4.3577    2529.1948      30.1931      -7.6250    3914.0000
 2361.1332      94.7118     161.8172     697.6575     613.0989    1740.1787       0.5747     216.0000       0.1660       0.0977       0.0649       5.6819      54.5527     240.4354     155.2708      49.9441       0.0352       0.0408       0.0803       4.6602    2542.9668     102.2695      -7.3125    3932.0000
 2361.2856      67.8089     208.7862     243.5570     191.8693     451.5276       2.2147     216.0000       0.1430       0.0729       0.0391       5.5095      61.2522     247.1338     252.1954      49.9441       0.0575       0.0663       0.1087       5.1595    2585.4150     147.3379      -6.1250    3910.0000
 2361.4380      68.8967     248.5949     263.9258     176.9993     147.4878       6.7802     216.0000       0.1605       0.0918       0.0588       5.2105      72.4660     243.2264     305.9127      49.9441       0.0697       0.0798       0.1239       5.5457    2552.9978      66.4730      -5.1250    3934.0000
 2361.5904      47.6106     340.9771     176.2390     127.7475     102.7619       9.7312     216.0000       0.2564       0.1955       0.1662       5.3622      80.2945     254.9486     277.7834      49.9441       0.1147       0.1302       0.1787       5.8772    2375.7317       9.9204      -3.8125    3863.0000
 2361.7428      44.2300     179.8453     147.5001     106.5829      73.6931      13.5698     216.0000       0.3320       0.2773       0.2510       5.3973      75.8281     265.5544     213.2716      49.9441       0.2082       0.2328       0.2860       6.0149    2235.7725       4.6930      -3.3125    3867.0000
 2361.8952      48.9566     133.0012     136.2259     101.7175      64.3142      15.5487     216.0000       0.3182       0.2623       0.2355       5.4835      75.9833     240.4354     158.4282      49.9441       0.1829       0.2072       0.2587       5.8424    2261.4214       4.0269      -4.1250    3861.0000
 2362.0476      54.4542      96.7520     129.3819     108.6207      68.6797      14.5603     216.0000       0.2436       0.1817       0.1519       5.5152      69.6780     248.8084     151.8273      49.9441       0.1748       0.1994       0.2500       5.5250    2399.3635       6.7119      -4.1875    3836.0000
 2362.2000      63.2895     148.6767     117.5226     127.8242      84.8851      11.7806     216.0000       0.2318       0.1689       0.1386       5.5864      73.3498     268.9037     159.0416      49.9441       0.1778       0.2024       0.2533       5.4343    2421.2476      12.6411      -4.8125    3865.0000
 2362.3524      42.7344      71.5159     145.2875     108.1337      85.6091      11.6810     216.0000       0.3228       0.2673       0.2407       5.4658      74.6185     249.3666     150.9235      49.9441       0.1447       0.1646       0.2149       5.7310    2252.8965       5.7389      -3.6875    3858.0000
 2362.5048      28.0900      29.6587      46.2642     104.4701      97.8084      10.2241     216.0000       0.3485       0.2952       0.2695       5.5765      78.2796     265.5544     168.0958      49.9441       0.2276       0.2546       0.3079       5.8824    2205.2737       3.8093      -5.1250    3855.0000
 2362.6572      62.4929      50.9881      97.0874     175.9545     157.4773       6.3501     216.0000       0.2980       0.2405       0.2129       4.9968      77.8560     287.8825     166.9607      49.9441       0.2038       0.2281       0.2808       5.6055    2298.7178       4.2263      -3.6250    3911.0000
 2362.8096      81.6528      98.2561     162.2391     243.2797     234.2604       4.2688     216.0000       0.1903       0.1240       0.0921       4.3277      71.3090     310.7687     143.3420      49.9441       0.0694       0.0792       0.1236       4.8878    2498.0276       8.1201      -9.6875    3839.0000
 2362.9620     119.3791     150.2503     551.2076     923.7328    1039.7168       0.9618     216.0000       0.1349       0.0640       0.0300       4.4556      67.0377     272.8111      75.3159      49.9441       0.0455       0.0520       0.0934       4.1432    2600.4817      19.5369      -5.9375    3842.0000
 2363.1144      92.6869     262.5562    1591.4988    1336.8593    1856.5834       0.5386     216.0000       0.1196       0.0475       0.0129       4.6803      68.0025     261.3680      21.1825      49.9441       0.0713       0.0816       0.1259       3.6422    2628.7024      43.8244      -7.5625    3846.0000
 2363.2668      91.8032     283.9899     746.9517     540.7992     580.5842       1.7224     216.0000       0.1230       0.0512       0.0167       4.8127      69.4647     259.1351       0.7415      49.9441       0.0833       0.0956       0.1408       3.4418    2622.4104     133.8192      -7.5000    3839.0000
 2363.4192      82.7867     258.7002     378.8938     366.5708     233.6850       4.2793     216.0000       0.1256       0.0540       0.0196       4.8626      69.2613     250.2039      -2.5992      49.9441       0.0770       0.0881       0.1330       3.4105    2617.7139     167.1889      -8.9375    3915.0000
 2363.5716      76.7005     206.4377     306.7248     376.4834     160.3667       6.2357     216.0000       0.1200       0.0479       0.0133       5.2201      62.0030     251.5994      -4.1699      49.9441       0.0834       0.0954       0.1409       3.4081    2628.0818     170.3833      -9.7500    3909.0000
 2363.7240      76.9447     152.3857     289.4520     286.8177     117.4606       8.5135     216.0000       0.1134       0.0408       0.0060       5.6556      60.1348     254.3904      -9.3379      49.9441       0.0923       0.1054       0.1518       3.3884    2640.1531     165.1284      -9.7500    3943.0000
 2363.8764      81.1284     115.4844     212.6735     228.4898      94.5786      10.5732     216.0000       0.1103       0.0374       0.0024       5.6848      62.9823     243.2264      -7.9737      49.9441       0.0862       0.0981       0.1443       3.3744    2646.0317     155.9065      -9.7500    3963.0000
 2364.0288      84.7815     100.7871     220.3736     204.4410      96.9343      10.3163     216.0000       0.1216       0.0497       0.0152       5.1602      69.8798     233.1788      -6.2294      49.9441       0.0853       0.0971       0.1432       3.4133    2624.9790      97.4411      -9.7500    3872.0000
 2364.1812     101.0555     114.5341     280.6831     188.9765     123.8851       8.0720     216.0000       0.1368       0.0661       0.0322       4.7613      70.5276     246.0174      -7.0899      49.9441       0.0915       0.1046       0.1507       3.4438    2596.9492      73.9538      -9.7500    3873.0000
 2364.3336     121.1680     142.6212     328.9931     169.6136     129.8740       7.6998     216.0000       0.1625       0.0939       0.0610       4.4283      62.7985     248.8084      -8.8503      49.9441       0.0754       0.0865       0.1310       3.5090    2549.4048      74.2910      -9.9375    3905.0000
 2364.4860     166.4871     205.6020     460.8272     219.3133     207.5778       4.8175     216.0000       0.1826       0.1157       0.0836       3.8553      57.5252     238.2026      -9.1662      49.9441       0.0730       0.0842       0.1281       3.5326    2512.1079      25.0695     -11.7500    3899.0000
 2364.6384     132.9793     202.6915     752.3541     144.0462     165.3333       6.0484     216.0000       0.1842       0.1174       0.0853       4.1473      55.4563     246.2965      10.1848      49.9441       0.0571       0.0660       0.1083       3.6493    2509.2534      25.2011      -9.7500    3899.0000
 2364.7908      97.4589     190.1577     317.8509     143.1626      96.3607      10.3777     216.0000       0.1778       0.1105       0.0781       4.6617      56.8800     247.4129      30.8235      49.9441       0.0516       0.0595       0.1012       3.7916    2521.0967      23.4014     -12.0000    3900.0000
 2364.9432      69.0362     149.0072     340.8622     147.3366      85.7627      11.6601     216.0000       0.1659       0.0976       0.0648       5.3077      58.9497     247.6920      58.7468      49.9441       0.0664       0.0756       0.1198       4.0144    2543.1523      31.0446     -11.3750    3889.0000
 2365.0956      55.2532     117.1100     264.6114     164.3066      71.6918      13.9486     216.0000       0.1731       0.1054       0.0729       5.6183      60.1678     248.2502      79.1969      49.9441       0.1173       0.1329       0.1819       4.2593    2529.7944      22.2347     -12.8125    3886.0000
 2365.2480      44.1886      96.1189     221.6104     123.1497      55.1463      18.1336     216.0000       0.1935       0.1275       0.0958       5.4541      59.1207     249.9248     105.9504      49.9441       0.1455       0.1642       0.2149       4.5968    2491.9624      12.0598     -13.6875    3858.0000
 2365.4004      37.3768      83.8528     209.6636     129.7231      51.6166      19.3736     216.0000       0.2197       0.1558       0.1251       4.6561      59.0812     247.1338     137.5055      49.9441       0.1298       0.1469       0.1966       4.9935    2443.6440       8.3397     -13.7500    3862.0000
 2365.5528      30.4299      68.4915     165.5364     147.2726      64.8670      15.4162     216.0000       0.2304       0.1674       0.1371       4.2426      62.7355     249.9248     169.5378      49.9441       0.1006       0.1143       0.1618       5.3130    2423.7666       7.4042     -13.7500    3872.0000
 2365.7052      25.3528      66.2701     121.3013     131.3267      59.9317      16.6857     216.0000       0.2281       0.1649       0.1345       4.5269      69.8844     260.5306     179.5685      49.9441       0.1160       0.1315       0.1803       5.4959    2428.0193       8.8080     -12.9375    3839.0000
 2365.8576      21.0379      50.5362      88.5411     117.3325      67.4677      14.8219     216.0000       0.2276       0.1643       0.1339       5.4817      71.1443     268.6245     146.7316      49.9441       0.1242       0.1404       0.1900       5.5247    2429.0313       8.9328     -13.4375    3867.0000
 2366.0100      22.9737      51.0642      75.5499      95.5357      57.3932      17.4237     216.0000       0.2253       0.1619       0.1314       5.6783      72.9715     271.9737     107.6910      49.9441       0.1371       0.1553       0.2057       5.5016    2433.1877       7.4939     -15.5625    3885.0000
 2366.1624      21.1242      55.0601      57.3021      75.7961      63.3169      15.7936     216.0000       0.3154       0.2594       0.2325       5.3270      74.1424     288.4407      54.6896      49.9441       0.1428       0.1629       0.2129       5.7980    2266.4270       6.0964     -15.1875    3893.0000
 2366.3148      15.7714      39.6752      43.9133      56.3886      52.3311      19.1091     216.0000       0.4188       0.3712       0.3484       5.5070      77.9734     285.6496      40.6511      49.9441       0.2558       0.2933       0.3410       6.2799    2075.1782       3.1234     -14.3750    3868.0000
 2366.4672       9.8247      14.4067      22.0518      36.8314      37.1662      26.9061     216.0000       0.4630       0.4190       0.3979       3.9191      74.1161     258.8560      77.8173      49.9441       0.4485       0.5099       0.5420       6.6164    1993.5194       2.5232     -15.2500    3862.0000
 2366.6196       7.1985       8.7395      12.5221      18.3684      18.3780      54.4129     216.0000       0.3656       0.3137       0.2887       2.4382      72.9452     304.6285     174.6389      49.9441       0.5091       0.5778       0.6022       6.5072    2173.6172       2.6927     -17.5000    3836.0000
 2366.7720       9.2773      13.4148      20.8536      22.3220      33.1575      30.1591     216.0000       0.2292       0.1661       0.1357       2.6710      68.7074     305.1867     269.3119      49.9441       0.3381       0.3864       0.4290       6.1492    2426.0212       4.2171     -18.9375    3864.0000
 2366.9244      14.9472      26.8498      43.9621      52.9343      61.5975      16.2344     216.0000       0.1618       0.0932       0.0602       3.3498      67.8953     276.1603     301.5492      49.9441       0.3378       0.3824       0.4279       5.9407    2550.6787       5.5303     -19.5625    3824.0000
 2367.0768      22.7560      47.4503      65.2410      71.8658      89.0413      11.2307     216.0000       0.1450       0.0750       0.0413       4.2205      61.7577     287.8825     297.9050      49.9441       0.2598       0.2938       0.3444       5.8513    2581.8188       6.9513     -19.5625    3848.0000
 2367.2292      28.9660      85.6381     318.7386     382.3531     701.6895       1.4251     216.0000       0.1528       0.0834       0.0501       4.5136      60.7546     294.5809     291.3420      49.9441       0.1429       0.1621       0.2126       5.8863    2567.3406      10.7634     -19.7500    3902.0000
 2367.3816      34.4668     149.3551    1928.4442    1950.0000    1950.0000       0.5000     216.0000       0.1620       0.0934       0.0604       5.4442      67.2511     300.1629     295.0041      49.9441       0.1076       0.1219       0.1706       5.9394    2550.2607      15.7952     -19.5625    3893.0000
 2367.5340      37.7411     189.1474    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.1738       0.1061       0.0736       5.1076      69.5242     282.0214     299.5005      49.9441       0.1108       0.1254       0.1742       5.9803    2528.4998      16.8675     -21.3125    3879.0000
 2367.6864      37.5468     161.4770    1950.0000    1950.0000    1950.0000       0.5000     216.0000       0.1843       0.1175       0.0854       5.2436      73.7816     272.8111     295.3641      49.9441       0.1634       0.1842       0.2359       5.9542    2509.0752      10.3871     -21.3125    3896.0000
 2367.8388      41.1359     109.5358     909.2692    1043.3080    1200.8237       0.8328     216.0000       0.2081       0.1433       0.1121       4.8742      71.7045     285.3705     260.4106      49.9441       0.1940       0.2177       0.2704       5.8781    2464.9644       7.2528     -21.3750    3810.0000
 2367.9912      46.3779      58.3332     124.4373     159.1689     146.7961       6.8122     216.0000       0.1910       0.1248       0.0930       4.5238      77.8064     280.0677     222.3706      49.9441       0.1434       0.1619       0.2126       5.6559    2496.6289       5.5817     -21.8125    3843.0000
 2368.1436      30.0494      34.8057      92.4208     118.3056     105.9692       9.4367     216.0000       0.1664       0.0981       0.0653       4.1491      75.3656     281.1841     165.3159      49.9441       0.0498       0.0555       0.0989       5.3140    2542.1938       7.4714     -23.3125    3828.0000
 2368.2960      37.4855      29.4140      45.4525      57.1955      51.6495      19.3613     216.0000       0.1550       0.0859       0.0526       3.4937      74.4151     259.4142     117.2166      49.9441       0.0804       0.0910       0.1372       5.0498    2563.1885      12.8593     -24.5625    3871.0000
 2368.4484      39.9287      36.6401      33.7311      67.5843      38.0409      26.2875     216.0000       0.1702       0.1023       0.0696       3.6397      75.0252     292.9063     103.5848      49.9441       0.1540       0.1739       0.2247       5.1195    2535.1238      23.0801     -25.5625    3899.0000
 2368.6008      37.3272      49.2577      78.6506      95.1923      90.0406      11.1061     216.0000       0.2250       0.1615       0.1310       3.7836      77.8728     291.2317     104.9495      49.9441       0.1065       0.1212       0.1688       5.4912    2433.8210      13.2996     -26.1875    3936.0000
 2368.7532      44.6885      65.7929      59.6278      75.8125      69.2871      14.4327     216.0000       0.2785       0.2194       0.1910       4.0412      78.8234     318.0253     108.5367      49.9441       0.0885       0.1008       0.1471       5.8915    2334.7727       6.4099     -27.5625    3900.0000
 2368.9056      37.9359      84.9345     161.7213     152.3517     159.7830       6.2585     216.0000       0.3242       0.2688       0.2422       4.3007      82.8913     282.8586      74.8603      49.9441       0.1172       0.1326       0.1818       6.0179    2250.3013       4.4807     -29.3125    3908.0000
 2369.0580      79.1730      98.5869     160.8401     126.2187     102.8853       9.7196     216.0000       0.3314       0.2767       0.2503       3.9521      87.0824     293.4644      31.3699      49.9441       0.1339       0.1514       0.2017       6.0027    2236.9233       3.9437     -29.3125    3923.0000
 2369.2104      73.6152      49.4468      66.9377      55.5219      57.7802      17.3070     216.0000       0.2999       0.2425       0.2150       4.0303      91.1974     303.5121       4.9524      49.9441       0.1625       0.1837       0.2351       5.8543    2295.2615       4.5691     -29.3125    3916.0000
 2369.3628      27.8852      19.4594      25.7965      18.2515      13.0251      76.7748     216.0000       0.2712       0.2115       0.1829       4.2471      82.1932     305.1867      -8.6000      49.9441       0.2358       0.2633       0.3168       5.5567    2348.2742       6.0602     -29.3125    3856.0000
 2369.5152      34.5893      16.8759      23.1133      14.5962      13.6382      73.3233     216.0000       0.2419       0.1799       0.1500       4.5863      76.1271     321.0954      24.4234      49.9441       0.1195       0.1352       0.1846       5.3574    2402.4407      10.1653     -29.3125    3913.0000
 2369.6676      50.1083      38.9307      73.7615      57.0752      38.9438      25.6780     216.0000       0.2211       0.1573       0.1267       3.9132      73.8861     340.3533      86.5393      49.9441       0.0746       0.0844       0.1301       5.3921    2440.9348      12.6569     -29.3125    3925.0000
 2369.8200      48.1316      48.6675      97.5744      63.3859      50.7707      19.6964     216.0000       0.1931       0.1271       0.0953       3.4588      74.4677     307.4195     158.9203      49.9441       0.1014       0.1150       0.1627       5.6819    2492.7112      12.3158     -29.3125    3854.0000
 2369.9724      36.6799      43.6466     118.2496      88.5125      54.9527      18.1975     216.0000       0.1560       0.0869       0.0537       2.3115      79.9491     286.2079     202.1194      49.9441       0.1163       0.1318       0.1806       5.8313    2561.3936      11.1985     -28.6250    3868.0000
 2370.1248      22.1390      32.3552      47.8769      42.8687      26.6798      37.4815     216.0000       0.1659       0.0977       0.0649       3.2226      80.5582     299.0465     192.8506      49.9441       0.0979       0.1111       0.1586       5.8550    2542.9966      17.7075     -27.1875    3841.0000
 2370.2772      16.1914      19.4314      30.2341      29.1927      13.3814      74.7303     216.0000       0.2056       0.1406       0.1093       4.5907      81.2416     286.7661     174.6230      49.9441       0.0969       0.1097       0.1576       5.9143    2469.6047      10.1034     -26.0000    3849.0000
 2370.4296      18.1442      24.6804      42.8395      62.5453      16.8656      59.2923     216.0000       0.2452       0.1834       0.1537       5.0874      82.6627     318.0253     168.3578      49.9441       0.1458       0.1653       0.2159       5.9841    2396.4048       6.6313     -24.5625    3910.0000
 2370.5820      32.8376      53.5212      69.9576      72.5268      56.0594      17.8382     216.0000       0.2409       0.1788       0.1489       4.9189      79.4499     359.3322     183.8937      49.9441       0.3169       0.3549       0.4049       5.9830    2404.3081       5.4276     -23.5625    3926.0000
 2370.7344      37.6370      55.8295      68.3827      76.4847      61.4084      16.2844     216.0000       0.2413       0.1792       0.1494       4.7241      79.9921     376.0782     190.5353      49.9441       0.2989       0.3383       0.3866       5.9727    2403.5537       6.6098     -26.8750    3895.0000
 2370.8868      42.1329      59.0641      56.2756      63.4141      64.5753      15.4858     216.0000       0.2537       0.1926       0.1633       3.9680      75.3174     350.4009     194.5457      49.9441       0.2367       0.2721       0.3201       6.0463    2380.6060       6.2037     -29.3125    3860.0000
 2371.0392      17.1008      34.1110      43.9430      47.9850      60.5056      16.5274     216.0000       0.3029       0.2459       0.2184       3.1829      75.4981     343.1443     177.6259      49.9441       0.3210       0.3642       0.4103       6.2361    2289.5737       4.9090     -29.0625    3851.0000
 2371.1916      12.3388      13.4638      18.2259      21.7342      37.5006      26.6663     216.0000       0.3194       0.2637       0.2369       3.3256      76.0860     386.1258     180.9936      49.9441       0.3059       0.3496       0.3949       6.3575    2259.0713       4.0218     -29.3125    3911.0000
 2371.3440      13.0769      13.1687      15.6052      24.9339      44.2105      22.6191     216.0000       0.3239       0.2686       0.2420       3.8377      69.6232     388.9168     187.8302      49.9441       0.3419       0.3875       0.4323       6.3895    2250.7642       4.1757     -29.3125    3960.0000
 2371.4964      21.7419      22.2240      27.5832      38.8509      62.3114      16.0484     216.0000       0.2724       0.2129       0.1842       4.7111      66.0199     354.8666     215.2667      49.9441       0.2820       0.3156       0.3675       6.2304    2345.9956       5.2906     -31.8750    4039.0000
 2371.6488      41.5430      63.6074      55.7807      69.5109      92.3949      10.8231     216.0000       0.2176       0.1535       0.1228       4.8333      63.9472     282.8586     232.2409      49.9441       0.1286       0.1457       0.1957       6.0132    2447.4575       7.4730     -31.4375    4068.0000
 2371.8012      50.1012     109.6656      86.6977     107.2414     142.7960       7.0030     216.0000       0.2076       0.1427       0.1116       4.4210      68.3308     330.8639     214.4906      49.9441       0.0855       0.0966       0.1437       5.8679    2465.9260       8.4649     -32.1250    4038.0000
 2371.9536      47.0954     177.3658    1334.2468     832.4189     321.8483       3.1071     216.0000       0.2334       0.1707       0.1405       4.1927      72.4346     349.2846     188.7209      49.9441       0.1545       0.1747       0.2259       5.8550    2418.1726       7.6396     -32.4375    3903.0000
 2372.1060      41.1837     170.9770    1950.0000     361.2967     189.7764       5.2694     216.0000       0.2770       0.2178       0.1894       3.3696      77.4339     326.9565     166.7044      49.9441       0.2361       0.2659       0.3180       5.9086    2337.5481       6.9190     -32.5000    4001.0000
 2372.2584      32.7216     109.0486     530.1010     161.8585     291.1010       3.4352     216.0000       0.2841       0.2255       0.1973       3.4607      79.9178     333.0967     172.6971      49.9441       0.2075       0.2339       0.2861       5.8829    2324.4170       7.2319     -34.9375    4080.0000
 2372.4108      26.5899      69.5492     165.8394     223.5513     477.4531       2.0944     216.0000       0.2668       0.2067       0.1779       3.5081      81.6273     339.7951     192.0056      49.9441       0.1824       0.2066       0.2581       5.8000    2356.4993       7.1820     -35.8125    4030.0000
 2372.5632      23.8563      36.8268     109.3205     298.0351     336.6920       2.9701     216.0000       0.2498       0.1884       0.1589       3.3920      75.2861     342.5862     193.9130      49.9441       0.1786       0.2030       0.2540       5.7053    2387.7832       6.1121     -38.9375    3977.0000
 2372.7156      20.6490      25.0806      71.9272     317.9372     484.6100       2.0635     216.0000       0.2198       0.1559       0.1252       3.4696      71.1763     347.8890     190.1608      49.9441       0.2185       0.2468       0.2987       5.5857    2443.4263       6.2270     -36.9375    3855.0000
 2372.8680      23.1440      25.7985      79.6845     408.7391     686.5369       1.4566     216.0000       0.1873       0.1207       0.0888       4.2076      69.7531     356.5412     189.9621      49.9441       0.2072       0.2343       0.2861       5.4804    2503.5500       8.4518     -39.0625    3814.0000
 2373.0204      43.8614      34.8666     120.9486     537.4870     753.5286       1.3271     216.0000       0.1875       0.1210       0.0890       4.4278      70.8913     400.6390     186.0063      49.9441       0.1539       0.1736       0.2249       5.4967    2503.0901      17.1242     -39.0625    3845.0000
 2373.1728      45.1022      49.0185     228.3580     947.8820     825.6427       1.2112     216.0000       0.2127       0.1482       0.1172       4.5462      69.4279     372.7290     189.9798      49.9441       0.0905       0.1029       0.1495       5.6637    2456.5972      21.6177     -42.8125    3909.0000
 2373.3252      49.9302      65.7621    1302.9470    1950.0000    1950.0000       0.5048     216.0000       0.2333       0.1705       0.1403       3.8971      61.1356     348.1682     208.2374      49.9441       0.0716       0.0828       0.1264       5.8875    2418.4351      16.8492     -44.5000    4056.0000
 2373.4776      46.7712      74.1788     351.8169    1043.3696     413.6287       2.4176     216.0000       0.2146       0.1503       0.1194       3.5809      59.6722     322.7700     248.6522      49.9441       0.0561       0.0653       0.1070       6.0020    2453.0430      14.4470     -43.1875    4166.0000
 2373.6300      37.7832      91.0061     183.0716     310.5588     142.3306       7.0259     216.0000       0.1858       0.1191       0.0871       3.6911      62.4363     325.2819     294.2400      49.9441       0.0478       0.0562       0.0966       6.0371    2506.2937      15.5983     -40.9375    4207.0000
 2373.7824      33.5987      49.7924      96.8485     200.6260      87.1825      11.4702     216.0000       0.1677       0.0996       0.0669       1.0679      61.7614     321.9327     328.4741      49.9441       0.0500       0.0587       0.0994       6.0311    2539.6780      20.7700     -40.5000    4136.0000
 2373.9348      58.7189      83.6959      53.1383      97.0274      45.7090      21.8776     216.0000       0.1632       0.0947       0.0618       3.3567      62.4118     302.9539     346.1056      49.9441       0.0551       0.0641       0.1057       6.0377    2548.0220      22.1487     -41.0625    3968.0000
 2374.0872      48.6845      78.1349     235.3336     161.2365     132.1711       7.5660     216.0000       0.1614       0.0927       0.0598       3.8779      58.5095     307.4195     332.4731      49.9441       0.0651       0.0756       0.1183       6.0188    2551.4087      22.8459     -39.8125    3968.0000
 2374.2396      66.9340     128.4902     217.8566      88.6461     106.0158       9.4326     216.0000       0.1342       0.0633       0.0293       4.2391      58.0225     300.7211     313.0636      49.9441       0.0554       0.0644       0.1062       5.9131    2601.7288      22.3911     -39.0625    3949.0000
 2374.3920      55.3947      78.2373     136.7403      56.5046      58.9332      16.9684     216.0000       0.1227       0.0508       0.0163       4.7946      54.1202     299.0465     284.9233      49.9441       0.0526       0.0610       0.1026       5.8243    2623.0720      29.5828     -38.7500    3919.0000
 2374.5444      55.9050      89.8231     127.0134      47.5695      43.4558      23.0119     216.0000       0.1289       0.0576       0.0233       4.7364      56.7217     283.4169     273.8297      49.9441       0.0587       0.0676       0.1102       5.8285    2611.5232      31.9711     -38.3125    3912.0000
 2374.6968      66.2820      92.5967      74.2072      38.4923      32.6068      30.6684     216.0000       0.1674       0.0993       0.0665       4.5520      61.4608     296.2555     268.8491      49.9441       0.0763       0.0870       0.1321       6.0265    2540.2354      13.9308     -35.1250    3873.0000
 2374.8492      61.3121      77.1142      90.7929      52.7883      40.0803      24.9499     216.0000       0.2097       0.1450       0.1140       3.4156      67.9645     273.9275     242.9016      49.9441       0.1342       0.1517       0.2018       6.2353    2461.9717       6.9434     -33.1250    3859.0000
 2375.0016     112.9486      63.9246     112.2472      74.2237      55.5050      18.0164     216.0000       0.2033       0.1381       0.1068       3.5986      70.0459     286.7661     227.0563      49.9441       0.1722       0.1937       0.2457       6.2678    2473.8416       5.8985     -32.1250    3842.0000
 2375.1540     238.2494     137.2365      97.8926      76.6870      48.8766      20.4597     216.0000       0.2260       0.1626       0.1322       3.3399      76.7122     307.4195     173.4188      49.9441       0.1091       0.1235       0.1722       6.1724    2431.8916       6.7126     -31.0625    3865.0000
 2375.3064     134.5026     100.8536     167.7794      94.1187      59.0414      16.9373     216.0000       0.2024       0.1371       0.1057       3.0133      78.1756     314.1179     175.6759      49.9441       0.1495       0.1687       0.2197       6.0565    2475.5427       9.1943     -29.3125    4007.0000
 2375.4588     124.3272      47.3373      49.9879      45.8573      36.3989      27.4733     216.0000       0.2322       0.1694       0.1392       3.4222      81.4599     343.4234     167.1560      49.9441       0.1722       0.1938       0.2458       6.1116    2420.3616       8.7212     -29.2500    4171.0000
 2375.6112     120.8714      66.2524      85.0371      43.8367      31.7974      31.4492     216.0000       0.2745       0.2151       0.1865       4.0284      81.6225     316.3507     173.1195      49.9441       0.1543       0.1744       0.2256       6.3371    2342.2590       6.6730     -26.1250    4242.0000
 2375.7636     216.0803     145.5728      70.7470      69.7982      47.1932      21.1895     216.0000       0.3364       0.2820       0.2559       4.6782      83.5736     335.0504     169.5051      49.9441       0.1349       0.1526       0.2030       6.6108    2227.6963       4.3485     -24.4375    4176.0000
 2375.9160      95.9143      71.3272      81.8205      78.5137      54.9670      18.1927     216.0000       0.3716       0.3201       0.2954       4.7303      80.1591     343.7026     162.3194      49.9441       0.1261       0.1428       0.1926       6.7867    2162.5688       3.3279     -23.8750    4113.0000
 2376.0684      38.3269      49.4632      59.0565      73.5561      57.3257      17.4442     216.0000       0.3722       0.3208       0.2961       4.4872      81.4599     372.7290     149.7807      49.9441       0.1269       0.1438       0.1937       6.7479    2161.3733       2.9034     -24.1250    4024.0000
 2376.2208      21.5863      16.0925      15.8438      15.2851      14.3800      69.5413     216.0000       0.3754       0.3243       0.2997       4.0056      81.5123     390.5914     121.8414      49.9441       0.1958       0.2212       0.2732       6.5816    2155.4370       2.7414     -25.1875    3999.0000
 2376.3732      47.7989      35.0897      42.4660      50.7216      31.4446      31.8020     216.0000       0.3773       0.3263       0.3018       4.3466      85.2520     397.8480     104.5706      49.9441       0.2725       0.3047       0.3571       6.4017    2152.0063       2.7305     -24.7500    3921.0000
 2376.5256     113.2802      71.2637      81.9373      71.4411      58.4105      17.1202     216.0000       0.3485       0.2951       0.2695       3.7881      84.6016     398.9644     125.7226      49.9441       0.2280       0.2571       0.3091       6.2828    2205.3518       3.1964     -25.0625    3942.0000
 2376.6780     355.1465     188.2229     299.6011     234.6357     185.8441       5.3809     216.0000       0.3089       0.2523       0.2251       3.4046      77.5576     399.5226     160.6412      49.9441       0.1603       0.1827       0.2332       6.2319    2278.5867       3.8223     -23.8750    3935.0000
 2376.8304     587.6104     316.3854    1664.1899     228.8686    1558.1812       0.6418     216.0000       0.2418       0.1798       0.1499       3.2388      76.4195     357.0994     222.2173      49.9441       0.1788       0.2038       0.2545       6.1737    2402.5950       5.6200     -24.0000    3995.0000
 2376.9828     291.9992     237.3024    1950.0000     305.3064    1950.0000       0.5000     216.0000       0.2331       0.1704       0.1402       3.2492      75.7280     338.6787     245.2047      49.9441       0.2214       0.2505       0.3021       6.1644    2418.6973       7.2991     -24.7500    3983.0000
 2377.1352     174.4721     152.9074    1180.7919     688.5745    1420.4976       0.7040     216.0000       0.2384       0.1760       0.1461       3.8816      78.1669     387.8004     268.9099      49.9441       0.2301       0.2573       0.3106       6.1820    2408.9634      11.7206     -25.5000    3974.0000
 2377.2876     100.1432      98.1321     365.6777     623.2799    1125.8842       0.8882     216.0000       0.2601       0.1995       0.1704       4.5286      72.8013     314.3970     272.4791      49.9441       0.1547       0.1744       0.2257       6.2117    2368.8398      13.8483     -26.1250    3961.0000
 2377.4400      66.0474      58.5796     269.3342     946.4214    1589.5244       0.6291     216.0000       0.2434       0.1815       0.1517       4.5921      66.5082     304.0703     285.2988      49.9441       0.0792       0.0898       0.1357       6.1506    2399.6868      15.6814     -27.3750    4043.0000
 2377.5924      54.8237      43.7212     175.4269    1021.7335    1289.1422       0.7757     216.0000       0.2269       0.1637       0.1332       4.4888      61.0534     309.6523     275.4979      49.9441       0.0712       0.0810       0.1258       6.0297    2430.1582      16.7978     -27.9375    3961.0000
 2377.7448      40.1613      33.2494     125.8994     705.0041     754.1437       1.3260     216.0000       0.2102       0.1455       0.1144       3.5063      61.0966     318.8626     263.7882      49.9441       0.0885       0.1009       0.1471       5.9027    2461.1963      17.7161     -28.0625    3969.0000
 2377.8972      42.0792      36.4351     153.2533     369.4291     385.7411       2.5924     216.0000       0.1945       0.1286       0.0969       2.9830      59.4637     320.2581     266.6733      49.9441       0.0888       0.1010       0.1475       5.8287    2490.1384      21.5447     -28.5000    3992.0000
 2378.0496      53.1762      48.3210     160.8222     187.6168     198.1678       5.0462     216.0000       0.2152       0.1509       0.1200       3.6186      63.7804     321.9327     248.7755      49.9441       0.0924       0.1050       0.1519       5.8547    2451.9216      22.1049     -29.3125    3999.0000
 2378.2020      51.3534      52.1656     137.0953     105.8178     109.8293       9.1050     216.0000       0.2554       0.1945       0.1652       3.2026      64.5168     322.4909     203.2225      49.9441       0.0969       0.1101       0.1573       5.8871    2377.4487       9.7393     -29.3125    4035.0000
 2378.3544      44.8384      54.7713     115.0165      71.4468      69.9431      14.2973     216.0000       0.2763       0.2170       0.1886       3.7644      72.4839     305.7449     141.9535      49.9441       0.1018       0.1157       0.1633       5.7566    2338.8923       6.6322     -29.3125    4044.0000
 2378.5068      45.4134      78.9188     176.1133      93.0111      69.3515      14.4193     216.0000       0.2384       0.1760       0.1461       3.9379      75.2480     315.7925     116.6699      49.9441       0.1116       0.1266       0.1750       5.4114    2408.9934       6.1288     -30.8125    4037.0000
 2378.6592      52.3885     125.5663     124.4497      53.7142      47.4293      21.0840     216.0000       0.1982       0.1326       0.1011       4.0105      76.4195     305.4658     118.1793      49.9441       0.1201       0.1360       0.1852       5.1099    2483.2380       9.1914     -31.3750    4231.0000
 2378.8116      52.0247     195.2239     136.1515      54.2482      43.4819      22.9981     216.0000       0.1869       0.1203       0.0883       3.8545      74.9561     298.4883     133.3322      49.9441       0.1006       0.1139       0.1620       5.0637    2504.2397      10.3997     -33.0625    4226.0000
 2378.9640      37.9762     276.9424     103.2394      56.3707      39.2167      25.4994     216.0000       0.1880       0.1215       0.0896       3.5542      78.0454     318.5835     162.8094      49.9441       0.1092       0.1236       0.1724       5.2726    2502.2124      11.3428     -33.0625    4174.0000
 2379.1164      62.9577    1231.6121     195.9716      83.6858      45.4667      21.9941     216.0000       0.1900       0.1237       0.0918       3.2372      80.6469     303.2330     193.3756      49.9441       0.1903       0.2143       0.2666       5.5387    2498.5317      10.8386     -33.5625    4080.0000
 2379.2688      73.6162     415.8033     288.6130     106.8713      49.9816      20.0073     216.0000       0.1670       0.0989       0.0661       3.3813      79.9966     320.8163     251.4169      49.9441       0.2475       0.2759       0.3295       5.7531    2540.9592      11.1729     -33.1875    3936.0000
 2379.4212      94.4172     167.8805     214.1141     144.7096      45.2872      22.0813     216.0000       0.1519       0.0825       0.0491       3.3809      78.8584     320.2581     298.1539      49.9441       0.1447       0.1639       0.2146       5.8902    2568.9651      11.3552     -33.5000    3912.0000
 2379.5736     119.2451     104.6891     214.4868     227.7160      43.1671      23.1658     216.0000       0.1575       0.0885       0.0554       3.8705      75.9371     321.0954     311.1544      49.9441       0.1445       0.1640       0.2145       5.9580    2558.6304       7.7589     -34.5000    3875.0000
 2379.7260     160.0521     133.2183     329.2896     302.4054      46.7018      21.4125     216.0000       0.1689       0.1008       0.0681       3.4916      72.5905     325.2819     305.4257      49.9441       0.2143       0.2421       0.2940       5.9670    2537.6262       7.2598     -36.1250    3918.0000
 2379.8784     221.9616     154.9427     336.8821     319.2264     107.5308       9.2997     216.0000       0.1773       0.1100       0.0776       3.4064      66.0756     319.1417     302.8758      49.9441       0.1781       0.2007       0.2528       5.9490    2521.9700       9.2306     -33.9375    4039.0000
 2380.0308     146.5125     144.2430     881.4989     754.0347     155.6692       6.4239     216.0000       0.1864       0.1198       0.0878       3.8053      63.7939     292.6272     309.5529      49.9441       0.0942       0.1067       0.1542       5.9712    2505.0945      19.4350     -30.9375    4064.0000
 2380.1832      86.2833      94.1130     154.8126     137.6809     110.6363       9.0386     216.0000       0.2004       0.1349       0.1035       4.1670      67.7909     291.2317     302.7701      49.9441       0.0521       0.0587       0.1018       6.0173    2479.2512      12.9806     -36.8750    3997.0000
 2380.3356      82.4234      77.6119      96.3335      84.1547     116.0939       8.6137     216.0000       0.2106       0.1460       0.1149       3.9890      73.4529     275.6021     276.1057      49.9441       0.0958       0.1089       0.1560       5.9970    2460.3962       9.0309     -29.7500    3947.0000
 2380.4880      78.4555      47.0854      51.7523      44.9264      67.6968      14.7717     216.0000       0.1990       0.1334       0.1019       3.8185      82.5582     280.0677     247.7770      49.9441       0.1545       0.1742       0.2253       5.8087    2481.8496       8.9070     -34.5000    3966.0000
 2380.6404      76.3808      92.5400      96.6142      61.6747     190.9428       5.2372     216.0000       0.1786       0.1113       0.0790       3.0724      86.2979     295.6973     210.3186      49.9441       0.1714       0.1928       0.2448       5.4581    2519.6284      10.4327     -31.8125    3834.0000
 2380.7928      71.8960      78.8567      64.4205      75.9010      93.8961      10.6501     216.0000       0.1641       0.0957       0.0628       2.0809      86.1355     296.8137     155.9336      49.9441       0.1772       0.1992       0.2515       5.0254    2546.3699      14.4072     -31.1250    3885.0000
 2380.9452      43.9685      70.2175      44.3730      55.7242      76.9182      13.0008     216.0000       0.1554       0.0863       0.0530       2.6005      80.4447     325.2819     107.4641      49.9441       0.1022       0.1157       0.1638       4.6525    2562.5032      16.3837     -30.6250    3895.0000
 2381.0976      25.0020      49.2995      34.5028      39.9441      48.8996      20.4501     216.0000       0.1785       0.1113       0.0790       2.7974      74.4287     272.2528      80.0233      49.9441       0.0897       0.1016       0.1487       4.5824    2519.7319      36.5536     -30.2500    4013.0000
 2381.2500      29.6907      45.4781      38.2027      42.5339      49.6149      20.1553     216.0000       0.2015       0.1361       0.1047       4.1905      71.5416     267.7872     105.3486      49.9441       0.0719       0.0813       0.1268       4.8392    2477.2947      29.8924     -29.5625    4032.0000
 2381.4024      70.6530      74.2150      86.2051      66.7145      75.7007      13.2099     216.0000       0.2074       0.1425       0.1113       3.9319      77.7202     262.2052     157.7511      49.9441       0.0901       0.1019       0.1492       5.2432    2466.3606      10.6229     -31.1875    4040.0000
 2381.5548      66.8281      49.8930      65.7857      62.5384      69.2677      14.4367     216.0000       0.1941       0.1281       0.0964       4.0965      83.8988     286.4870     191.2007      49.9441       0.1900       0.2136       0.2661       5.4778    2490.9099       8.0753     -32.8125    4011.0000
 2381.7072      55.5545      38.9217      75.0163      68.5275      73.7687      13.5559     216.0000       0.1936       0.1276       0.0959       3.6344      87.9637     314.1179     184.6190      49.9441       0.2396       0.2678       0.3211       5.4765    2491.7830       7.1685     -33.0625    3940.0000
 2381.8596      44.6542      26.6643      49.2088      38.0557      32.9034      30.3920     216.0000       0.2015       0.1361       0.1047       3.4384      83.5736     311.3269     155.6451      49.9441       0.2363       0.2643       0.3175       5.3103    2477.2471       7.1614     -36.6875    3837.0000
 2382.0120      83.9691      39.9334      81.5269      36.5597      35.5169      28.1556     216.0000       0.2097       0.1450       0.1139       3.2531      79.6325     313.0015     121.0399      49.9441       0.1454       0.1642       0.2150       5.0380    2462.0374       6.3788     -36.3750    3950.0000
 2382.1644     138.2563      66.9871     171.0049     141.7127     112.8234       8.8634     216.0000       0.1783       0.1110       0.0787       3.4293      79.3073     326.1192     108.7852      49.9441       0.0754       0.0851       0.1311       4.7389    2520.1260       8.4173     -35.3125    4024.0000
 2382.3168     277.7601     132.2454     757.4313     338.1174     293.7125       3.4047     216.0000       0.1565       0.0874       0.0542       3.3646      78.8195     342.3071     105.3123      49.9441       0.0784       0.0892       0.1347       4.5506    2560.5334      18.7607     -33.5625    4073.0000
 2382.4692     207.8843     215.0061    1950.0000    1618.2273     255.9517       3.9070     216.0000       0.1532       0.0839       0.0506       3.4632      77.5207     279.5095     124.9049      49.9441       0.0959       0.1092       0.1561       4.5877    2566.5779      27.6833     -31.6875    4307.0000
 2382.6216     129.8967     258.1007    1501.4865    1315.4773     121.9356       8.2010     216.0000       0.1531       0.0838       0.0505       3.5708      77.1955     270.2991     174.3896      49.9441       0.1114       0.1270       0.1747       4.7832    2566.7266      30.5583     -31.0625    4272.0000
 2382.7740      98.2645     233.4580     448.7570     330.0987     142.5934       7.0129     216.0000       0.1804       0.1133       0.0811       3.5461      76.3825     281.4631     198.1917      49.9441       0.0893       0.1023       0.1481       5.0275    2516.1790      24.8673     -31.0000    4248.0000
 2382.9264      75.8595     169.0529     293.2744     224.3574      82.7330      12.0871     216.0000       0.1957       0.1299       0.0983       3.7041      78.6958     267.2290     207.8698      49.9441       0.0731       0.0838       0.1282       5.2059    2487.8762      16.6474     -30.4375    4145.0000
 2383.0788      69.8251     120.9098     206.9927     163.6406     112.8242       8.8633     216.0000       0.2333       0.1706       0.1404       2.9442      76.4195     269.4618     177.2959      49.9441       0.0482       0.0552       0.0969       5.3190    2418.3552      10.6970     -30.4375    4094.0000
 2383.2312      54.3027      86.0952     180.0331     151.0145     114.1107       8.7634     216.0000       0.2417       0.1796       0.1497       3.0683      75.6065     277.2766     158.3338      49.9441       0.0660       0.0758       0.1194       5.3267    2402.9199       9.2901     -30.0625    3990.0000
 2383.3836      32.0926      33.2858      53.9665      37.2661      39.6280      25.2347     216.0000       0.2227       0.1590       0.1284       3.1154      73.0050     277.2766     162.5695      49.9441       0.1036       0.1187       0.1654       5.2853    2438.0740      10.7813     -31.8125    3822.0000
 2383.5360      52.5016      35.0894      62.0158      54.3436      58.3673      17.1329     216.0000       0.1839       0.1171       0.0850       3.1399      77.2324     277.2766     188.7000      49.9441       0.1031       0.1175       0.1648       5.2350    2509.8164      15.8451     -36.0000    3887.0000
 2383.6884      65.0275      83.3416     176.6840     142.3270     116.6978       8.5691     216.0000       0.1408       0.0705       0.0367       3.4911      81.7851     278.9513     242.6042      49.9441       0.0746       0.0850       0.1301       5.2439    2589.4885      29.3048     -32.0000    3956.0000
 2383.8408      58.0533      80.5681     190.2541     159.1156     119.2646       8.3847     216.0000       0.1465       0.0766       0.0431       3.0149      83.3722     271.6946     270.4303      49.9441       0.0621       0.0705       0.1144       5.3291    2578.9478      38.3997     -32.0000    4022.0000
 2383.9932      73.6183     125.0493     305.8853     254.6193     150.4941       6.6448     216.0000       0.1710       0.1031       0.0705       3.5268      80.1428     261.0888     273.5736      49.9441       0.0748       0.0853       0.1303       5.3869    2533.6177      16.3318     -33.1250    4139.0000
 2384.1456      81.4273     174.2901     644.4518     278.4112     132.8811       7.5255     216.0000       0.1677       0.0996       0.0668       3.6604      79.9802     273.0901     255.2161      49.9441       0.0976       0.1111       0.1582       5.2737    2539.7468      12.8587     -33.5625    4193.0000
 2384.2980     110.0035     215.1726    1950.0000    1353.6936     229.6114       4.3552     216.0000       0.1392       0.0687       0.0348       3.3811      83.9214     274.2066     226.7857      49.9441       0.1342       0.1518       0.2017       4.9605    2592.5586      14.2811     -32.8125    4239.0000
 2384.4504     139.8787     250.5880    1890.8561    1536.1490     180.9289       5.5270     216.0000       0.1239       0.0522       0.0177       3.5667      84.2240     293.1854     196.9135      49.9441       0.1276       0.1443       0.1941       4.6426    2620.7244      23.5122     -32.8750    4170.0000
 2384.6028     159.5305     225.9224     892.3755     427.1722     259.2823       3.8568     216.0000       0.1261       0.0546       0.0202       3.3020      83.2484     291.2317     176.8117      49.9441       0.1306       0.1477       0.1976       4.4812    2616.6382      26.8985     -32.3125    4006.0000
 2384.7552     156.1069     260.5010     511.1844     265.2218     237.2081       4.2157     216.0000       0.1354       0.0647       0.0306       2.7963      78.8584     286.7661     165.6353      49.9441       0.1217       0.1377       0.1870       4.4978    2599.4409      29.6216     -33.4375    3969.0000
 2384.9076     126.2498     166.2751     291.0273     183.1535     222.8663       4.4870     216.0000       0.1309       0.0597       0.0255       3.0884      76.5466     281.4631     164.7918      49.9441       0.0952       0.1083       0.1553       4.6092    2607.8918      29.9623     -34.1250    3945.0000
 2385.0600      96.2780     216.6354     242.5301     142.0102     249.2487       4.0121     216.0000       0.1543       0.0851       0.0518       3.2040      74.5954     280.6259     168.5634      49.9441       0.0805       0.0917       0.1373       4.8576    2564.4824      35.6655     -32.3750    3907.0000
 2385.2124      94.3510      82.4769     181.9647     109.7769     225.2326       4.4399     216.0000       0.2589       0.1982       0.1691       3.6052      71.5061     274.4857     151.0356      49.9441       0.0648       0.0734       0.1179       5.3740    2371.0237      10.7875     -33.4375    3911.0000
 2385.3648      44.2116      51.5393     156.2407     171.5371     259.2733       3.8569     216.0000       0.3654       0.3135       0.2885       3.6294      70.8567     282.8586     154.5601      49.9441       0.0947       0.1074       0.1547       5.9891    2173.9197       4.1544     -32.3750    3899.0000
 2385.5172      23.7177      43.7482      31.7046      35.8944      39.2614      25.4703     216.0000       0.3772       0.3262       0.3017       3.2204      68.2552     277.8349     204.4687      49.9441       0.1418       0.1602       0.2106       6.3427    2152.2393       3.6248     -32.5000    3974.0000
 2385.6696      23.7352      23.9804      38.5118      69.1231      72.9886      13.7008     216.0000       0.3040       0.2470       0.2196       3.6283      67.1171     291.7899     267.6501      49.9441       0.1589       0.1791       0.2303       6.3125    2287.6721       4.3711     -33.2500    4110.0000
 2385.8220      53.6966      32.0684      83.4873     106.7685     121.8545       8.2065     216.0000       0.2316       0.1687       0.1384       3.3985      68.9228     278.6721     298.4745      49.9441       0.1173       0.1329       0.1818       6.0517    2421.5872       7.2483     -33.0000    4100.0000
 2385.9744      74.4644      51.6041     109.5638     157.6916     167.7730       5.9604     216.0000       0.2265       0.1632       0.1328       2.9803      67.4277     262.7634     265.4526      49.9441       0.1006       0.1140       0.1618       5.8075    2430.9441       6.9841     -33.4375    4086.0000
 2386.1268      95.7661      93.3316     497.3423     902.5189     877.5557       1.1395     216.0000       0.1895       0.1232       0.0913       2.7190      70.3544     275.3229     255.5890      49.9441       0.0945       0.1071       0.1544       5.5424    2499.4016       9.1845     -33.0625    4006.0000
 2386.2792      86.9621     136.5790    1790.2478    1950.0000    1893.2617       0.5282     216.0000       0.1425       0.0723       0.0386       2.7557      72.9732     287.3243     245.7569      49.9441       0.0932       0.1057       0.1528       5.2867    2586.3113      14.8435     -33.5625    3908.0000
 2386.4316      67.7369     161.5518     833.2031     986.2302     775.2991       1.2898     216.0000       0.1072       0.0341      -0.0010       2.4210      79.9543     278.3931     239.8198      49.9441       0.1082       0.1227       0.1709       5.0993    2651.6946      23.5253     -33.5000    3860.0000
 2386.5840      52.8412     158.2812     476.9193     561.4078     503.1923       1.9873     216.0000       0.1130       0.0404       0.0055       2.4546      79.9543     273.9275     224.7000      49.9441       0.0963       0.1094       0.1566       5.0357    2640.9626      26.3328     -33.3750    3904.0000
 2386.7364      45.7903      87.0306     181.8210     193.0571     144.3084       6.9296     216.0000       0.1178       0.0456       0.0109       2.6574      78.3713     276.7184     233.0880      49.9441       0.0876       0.0994       0.1461       5.0561    2631.9897      20.4252     -34.2500    3958.0000
 2386.8888      51.5170     106.3075     306.2848     380.3925     294.7247       3.3930     216.0000       0.1221       0.0502       0.0156       2.5671      73.3732     287.6034     247.4060      49.9441       0.1112       0.1261       0.1745       5.1178    2624.1975      19.7091     -36.5000    4024.0000
 2387.0412      68.1690     156.7708     463.9027     352.4823     286.2348       3.4936     216.0000       0.1225       0.0506       0.0161       2.5290      73.2008     280.3468     264.3659      49.9441       0.1352       0.1528       0.2029       5.1936    2623.4390      18.2050     -36.6250    3990.0000
 2387.1936      83.7691     170.2166     592.0731     402.8313     255.2733       3.9174     216.0000       0.1298       0.0586       0.0244       2.5213      71.6945     276.7184     273.0284      49.9441       0.1178       0.1335       0.1824       5.2613    2609.7795      13.6262     -36.8125    3952.0000
 2387.3460     108.4639     198.8084     782.2525     389.4586     338.2891       2.9561     216.0000       0.1489       0.0792       0.0458       2.4395      70.5563     282.8586     270.5553      49.9441       0.1047       0.1188       0.1668       5.3286    2574.4973      13.1232     -35.1250    3919.0000
 2387.4984     134.0493     300.7361    1824.1720     518.5663     619.9099       1.6131     216.0000       0.1566       0.0876       0.0544       2.2776      69.2591     284.2542     277.9720      49.9441       0.0998       0.1135       0.1608       5.3874    2560.2109      15.7399     -38.3750    3864.0000
 2387.6508     156.0357     386.8315    1950.0000     609.2979     744.5102       1.3432     216.0000       0.1623       0.0937       0.0607       2.0712      71.3728     274.4857     299.0861      49.9441       0.0831       0.0946       0.1405       5.4866    2549.8223      23.6559     -38.3750    3887.0000
 2387.8032     164.6119     395.7435    1950.0000    1317.2365    1016.9453       0.9833     216.0000       0.1807       0.1137       0.0814       2.0175      71.1304     281.7422     315.5401      49.9441       0.0751       0.0857       0.1306       5.6350    2515.6345      22.1038     -36.1250    3947.0000
 2387.9556     157.0562     304.3923    1950.0000    1950.0000     601.4335       1.6627     216.0000       0.2175       0.1535       0.1227       2.0047      74.3885     268.6245     305.1803      49.9441       0.0847       0.0967       0.1425       5.7556    2447.5391      16.0958     -37.3125    3961.0000
 2388.1080     139.7646     205.5710    1613.7496    1568.9065     315.7033       3.1675     216.0000       0.2067       0.1418       0.1106       2.5582      71.4971     276.7184     298.4257      49.9441       0.0989       0.1130       0.1597       5.7012    2467.5796      16.3563     -36.2500    4038.0000
 2388.2604     126.9239     150.7746     725.6159     617.2764     160.4743       6.2315     216.0000       0.1600       0.0912       0.0582       2.6964      73.0067     257.4605     283.1080      49.9441       0.0887       0.1019       0.1474       5.4457    2554.0149      23.8199     -36.6875    3944.0000
 2388.4128      93.6940     104.3391     496.5713     498.7897     117.6647       8.4987     216.0000       0.1038       0.0304      -0.0049       2.0211      64.2265     263.0425     268.2531      49.9441       0.0452       0.0521       0.0931       5.1142    2658.0083      44.7757     -35.8125    3944.0000
 2388.5652      87.0952      93.6835     415.1728     327.2129     135.5250       7.3787     216.0000       0.0970       0.0231      -0.0125       2.1964      60.2889     281.7422     241.0402      49.9441       0.0401       0.0467       0.0866       4.9515    2670.5676      43.4221     -35.7500    3965.0000
 2388.7176     104.5899     113.4445     540.1931     358.7882     215.7655       4.6347     216.0000       0.1041       0.0307      -0.0045       2.0285      54.9128     266.9500     255.8346      49.9441       0.0630       0.0735       0.1157       5.0597    2657.4639      42.6795     -34.6250    3953.0000
 2388.8700     130.2161     158.4467     650.7947     423.5572     243.0934       4.1136     216.0000       0.1199       0.0478       0.0132       2.4786      57.8023     270.0200     302.2280      49.9441       0.0639       0.0740       0.1168       5.3724    2628.2627      41.9170     -34.7500    3888.0000
 2389.0224     148.7639     235.8264    1339.1826     349.8310     549.0954       1.8212     216.0000       0.1574       0.0884       0.0552       2.1542      59.5908     281.7422     339.3328      49.9441       0.0743       0.0854       0.1297       5.7335    2558.8972      13.6775     -32.3125    3855.0000
 2389.1748     149.5785     322.8064     604.3951     357.9500     258.0277       3.8756     216.0000       0.1930       0.1270       0.0952       2.3450      65.9364     269.4618     338.0165      49.9441       0.0988       0.1124       0.1596       5.9464    2492.9128       8.1057     -35.3125    3805.0000
 2389.3272     163.6474     434.1335     690.4874     351.3270     334.0545       2.9935     216.0000       0.1752       0.1076       0.0752       1.6347      69.3399     276.7184     320.5438      49.9441       0.1143       0.1298       0.1782       5.8713    2525.9243       8.1148     -32.0625    3840.0000
 2389.4796     140.2138     569.0080     895.6742     431.7119     222.2782       4.4989     216.0000       0.1341       0.0632       0.0291       2.0797      74.3407     280.9049     284.6217      49.9441       0.1059       0.1201       0.1682       5.5840    2601.9575      14.9140     -31.5000    3920.0000
 2389.6320     131.8246     565.2650     955.7158     625.9524     310.7469       3.2181     216.0000       0.1156       0.0432       0.0084       2.0786      72.6005     285.9287     246.6466      49.9441       0.0824       0.0936       0.1396       5.3070    2636.1318      20.9215     -29.3125    4048.0000
 2389.7844     104.1576     231.1530     425.3701     359.3221     276.6423       3.6148     216.0000       0.1360       0.0652       0.0312       2.1606      72.4862     246.5756     227.9143      49.9441       0.0841       0.0954       0.1417       5.2837    2598.4539      15.2020     -29.3125    4256.0000
 2389.9368      88.1262     128.2329     181.1217     156.2712     124.6436       8.0229     216.0000       0.1554       0.0863       0.0531       1.5749      67.4500     266.1126     250.5124      49.9441       0.0934       0.1065       0.1531       5.4642    2562.4331      14.9201     -29.3125    4152.0000
 2390.0892      73.2245      62.8169      97.9260      80.2569      72.1010      13.8694     216.0000       0.1464       0.0765       0.0429       1.5124      68.7800     271.4155     313.9081      49.9441       0.1059       0.1204       0.1682       5.6960    2579.2495      19.8371     -27.1875    4101.0000
 2390.2416     104.8130      96.7406     203.9457     114.0804     116.8728       8.5563     216.0000       0.1478       0.0780       0.0445       1.7015      72.4088     298.4883     359.6971      49.9441       0.0984       0.1120       0.1591       5.8581    2576.6362      30.8671     -27.6250    3971.0000
 2390.3940     183.0576     163.6330     320.4198     285.3341     222.0026       4.5045     216.0000       0.1781       0.1108       0.0785       1.5616      71.6700     328.6311     342.9313      49.9441       0.0828       0.0945       0.1401       5.9100    2520.4949      18.9648     -29.3125    3889.0000
 2390.5464     255.2237     250.5289    1324.6926     722.3439     680.8531       1.4687     216.0000       0.1757       0.1082       0.0758       2.3073      74.9210     272.8111     291.1696      49.9441       0.0898       0.1024       0.1487       5.7339    2524.9714      11.6774     -29.3125    3956.0000
 2390.6988     264.6879     384.2508    1950.0000    1273.0619     695.1622       1.4385     216.0000       0.1594       0.0906       0.0575       1.8660      68.4635     261.3680     206.7792      49.9441       0.0927       0.1057       0.1522       5.3141    2555.0552      11.7285     -28.0625    3952.0000
 2390.8512     251.3425     539.9015    1950.0000     701.1793     321.6096       3.1094     216.0000       0.1295       0.0582       0.0240       1.6481      68.7928     263.3217     149.7278      49.9441       0.0909       0.1039       0.1500       4.8511    2610.4128      20.2899     -28.3750    3952.0000
 2391.0036     219.8243     686.0447    1432.0282     555.6671     307.0422       3.2569     216.0000       0.1413       0.0710       0.0372       1.2783      67.3339     265.5544     126.3709      49.9441       0.0681       0.0778       0.1219       4.6935    2588.6104      53.6584     -26.2500    3955.0000
 2391.1560     207.1100     753.7280    1560.5183     770.5480     222.8680       4.4870     216.0000       0.1405       0.0701       0.0363       1.3114      68.4965     263.8798     162.9293      49.9441       0.0750       0.0860       0.1306       4.8666    2590.0784      72.1863     -26.5625    3950.0000
 2391.3084     196.2489     817.3381    1554.0785     612.5986     287.1510       3.4825     216.0000       0.1337       0.0628       0.0287       1.5490      72.7262     285.0915     209.1603      49.9441       0.0714       0.0823       0.1261       5.1243    2602.5872      52.6843     -22.3750    3980.0000
 2391.4608     189.7327     780.7113    1581.0594     588.6068     313.9688       3.1850     216.0000       0.1325       0.0615       0.0274       1.6468      68.1419     259.6933     224.4530      49.9441       0.0687       0.0790       0.1227       5.2324    2604.8167      59.7015     -26.6875    3986.0000
 2391.6132     182.5725     698.3721    1543.4247     474.5327     298.5271       3.3498     216.0000       0.1510       0.0815       0.0481       1.5910      72.0391     264.4380     196.3777      49.9441       0.0756       0.0870       0.1313       5.1438    2570.6174      37.9270     -25.5000    3918.0000
 2391.7656     210.7190     816.1368    1174.8644     402.5957     375.6182       2.6623     216.0000       0.1401       0.0697       0.0358       1.6808      67.7013     257.7396     162.9531      49.9441       0.0709       0.0816       0.1255       4.9022    2590.8535      30.8525     -27.0000    3953.0000
 2391.9180     193.2008     930.3659    1603.0812     366.3311     515.6230       1.9394     216.0000       0.1059       0.0327      -0.0025       0.8811      67.7788     247.1338     127.3203      49.9441       0.0757       0.0866       0.1314       4.5034    2654.1377      32.5397     -26.1875    3950.0000
 2392.0704     170.9813     707.1822     846.0418     403.7506     443.9046       2.2527     216.0000       0.0705      -0.0056      -0.0421       1.3099      66.0513     232.6206      87.8394      49.9441       0.0850       0.0973       0.1428       4.0231    2719.5056      64.4475     -22.5000    3950.0000
 2392.2228     145.2439     349.8047     374.6707     198.3165     316.9970       3.1546     216.0000       0.0622      -0.0146      -0.0515       1.1071      59.7316     228.7132      42.6443      49.9441       0.0835       0.0953       0.1410       3.5555    2734.9956     198.4532     -22.3125    4032.0000
 2392.3752     119.9181     226.2486     247.6656     212.5388     259.6900       3.8507     216.0000       0.0603      -0.0167      -0.0536       0.9643      53.0969     235.4116      10.4287      49.9441       0.0833       0.0955       0.1407       3.2167    2738.4814     336.0357     -20.8125    3997.0000
 2392.5276     162.5381     371.1324     395.3173     328.4436     286.5640       3.4896     216.0000       0.0601      -0.0169      -0.0539   -5308.6416      43.7695     237.6444      -3.7804      49.9441       0.0803       0.0918       0.1370       3.0779    2738.9026     341.3315     -21.5000    4069.0000
 2392.6800     159.3898     511.4212     782.3476     546.0612     384.0530       2.6038     216.0000       0.0704      -0.0057      -0.0423    -999.2500      43.7695     228.1550      -4.4987      49.9441       0.0806       0.0918       0.1374       3.1406    2719.8032     874.0562     -19.5625    4062.0000
 2392.8324     170.6466     569.3325    1211.1748     415.2456     361.4641       2.7665     216.0000       0.0823       0.0072      -0.0289    -999.2500      43.7695     228.1550       6.3088      49.9441       0.0853       0.0973       0.1432       3.3796    2697.7307     781.0737     -21.0000    3985.0000
 2392.9848     153.8450     572.0161    1681.7484     560.8450     317.3099       3.1515     216.0000       0.0812       0.0060      -0.0302    -999.2500      43.7695     228.4341      28.5838      49.9441       0.0916       0.1045       0.1509       3.6084    2699.7483     236.1903     -19.6250    3964.0000
 2393.1372     159.6793     432.0735    1140.0248     693.6769     431.0884       2.3197     216.0000       0.0726      -0.0033      -0.0398    -999.2500      43.7695     228.7132      44.9905      49.9441       0.0813       0.0930       0.1383       3.7296    2715.6309     204.9094     -19.5625    3926.0000
 2393.2896     155.5491     355.4525    1081.3302     640.8983     382.6019       2.6137     216.0000       0.0696      -0.0065      -0.0431    -999.2500      43.7695     230.3878      41.8906      49.9441       0.0807       0.0923       0.1375       3.6852    2721.1855     178.2991     -19.5625    3891.0000
 2393.4420     152.4770     313.0753    1093.5730     638.6332     409.8608       2.4399     216.0000       0.0731      -0.0028      -0.0393    -999.2500      43.7695     228.9923      29.5877      49.9441       0.0796       0.0912       0.1362       3.5997    2714.8311     263.7357     -18.6250    3967.0000
 2393.5944     147.4640     304.0721     914.1543     574.1506     390.2204       2.5627     216.0000       0.0745      -0.0012      -0.0376    -999.2500      43.7695     235.4116      23.0117      49.9441       0.0798       0.0913       0.1364       3.5214    2712.1184     255.6634     -17.3125    3999.0000
 2393.7468     151.0798     374.7368     723.8325     398.2051     305.7018       3.2712     216.0000       0.0712      -0.0048      -0.0413    -999.2500      43.7695     244.3428      28.5025      49.9441       0.0836       0.0956       0.1411       3.4673    2718.1997     232.2336     -14.1875    4056.0000
 2393.8992     148.9327     452.8085     925.3735     598.6681     409.0324       2.4448     216.0000       0.0685      -0.0077      -0.0444    -999.2500      43.7695     232.3415      26.6879      49.9441       0.0792       0.0903       0.1357       3.4072    2723.2380     243.6388     -13.6250    4016.0000
 2394.0516     147.7317     621.3937    1358.7565     634.0708     417.3630       2.3960     216.0000       0.0638      -0.0128      -0.0496    -999.2500      43.7695     229.2714      25.4521      49.9441       0.0903       0.1028       0.1493       3.3573    2731.8818     265.4071     -11.3125    3940.0000
 2394.2040     157.1050     723.4011    1950.0000     580.2062     462.2876       2.1632     216.0000       0.0735      -0.0024      -0.0388    -999.2500      43.7695     230.3878      16.2840      49.9441       0.1013       0.1150       0.1626       3.3256    2714.0310     460.7246     -12.2500    3987.0000
 2394.3564     153.1072     546.1328    1950.0000     877.0067     845.9259       1.1821     216.0000       0.0787       0.0032      -0.0330    -999.2500      43.7695     232.6206      16.2601      49.9441       0.1052       0.1193       0.1673       3.2926    2704.4902     373.7841     -11.0000    3931.0000
 2394.5088     162.7164     387.9786    1011.4908     839.7520     591.9197       1.6894     216.0000       0.0862       0.0114      -0.0245    -999.2500      43.7695     234.2952       9.9699      49.9441       0.1025       0.1163       0.1641       3.2258    2690.4753     182.1614     -10.8750    3931.0000
 2394.6612     142.0345     260.7725     613.7489     654.7476     321.7951       3.1076     216.0000       0.0812       0.0060      -0.0301    -999.2500      43.7695     239.8772       4.3561      49.9441       0.1007       0.1143       0.1619       3.1254    2699.6936     197.0880      -9.7500    3938.0000
 2394.8136     146.4003     190.5582     419.0997     420.6057     238.3535       4.1954     216.0000       0.0763       0.0007      -0.0356    -999.2500      43.7695     236.2489      -2.7575      49.9441       0.1016       0.1153       0.1630       3.0116    2708.8101     221.8572      -9.7500    3940.0000
 2394.9660     134.7354     242.4644     419.2090     411.0647     263.3686       3.7970     216.0000       0.0658      -0.0107      -0.0475    -999.2500      43.7695     229.5505      -2.3108      49.9441       0.1032       0.1171       0.1649       3.0195    2728.3557     640.8622      -7.5625    3956.0000
 2395.1184     127.5178     239.6366     354.1327     313.6274     233.2132       4.2879     216.0000       0.0718      -0.0041      -0.0407    -999.2500      43.7695     229.2714      10.1964      49.9441       0.1032       0.1171       0.1650       3.2580    2717.0833     596.8821      -6.3750    4025.0000
 2395.2708     115.5699     273.1984     394.8424     343.7507     299.2466       3.3417     216.0000       0.0796       0.0042      -0.0320    -999.2500      43.7695     229.8296      46.7896      49.9441       0.1031       0.1170       0.1648       3.7659    2702.8171     510.1145      -4.5000    3988.0000
 2395.4232      93.2948     272.4758     358.4875     303.3517     251.7130       3.9728     216.0000       0.0781       0.0026      -0.0336    -999.2500      43.7695     231.5042      96.3230      49.9441       0.1027       0.1165       0.1643       4.3720    2705.4902     481.3900      -3.4375    3956.0000
 2395.5756     121.9054     258.5637     307.4424     299.9139     245.1701       4.0788     216.0000       0.0807       0.0055      -0.0307    -999.2500      43.7695     232.8997     121.7644      49.9441       0.1024       0.1162       0.1639       4.8876    2700.6768     375.8414      -4.0000    3951.0000
 2395.7280     131.8462     289.7071     387.8375     238.6173     212.5789       4.7041     216.0000       0.1021       0.0285      -0.0068    -999.2500      43.7695     232.3415     108.4201      49.9441       0.1025       0.1163       0.1641       5.2322    2661.1890     279.3130      -2.5625    3928.0000
 2395.8804     117.9794     224.8691     240.4044     212.3896     177.6651       5.6286     216.0000       0.1391       0.0686       0.0347    -999.2500      43.7695     225.3640      79.5531      49.9441       0.1042       0.1182       0.1661       5.4453    2592.7439     203.4914       0.0000    3921.0000
 2396.0328      93.2628     181.2926     201.4577     212.1140     165.8842       6.0283     216.0000       0.1520       0.0826       0.0492    -999.2500      43.7695     223.6894      68.8138      49.9441       0.1046       0.1186       0.1666       5.5783    2568.7617     175.1586     -10.2500    3899.0000
 2396.1852      70.8582     140.7106     187.1676     168.5066     133.5291       7.4890     216.0000       0.1510       0.0815       0.0481    -999.2500      43.7695     223.1312      73.6101      49.9441       0.1047       0.1188       0.1668       5.6889    2570.5576     168.7189      -1.0000    3890.0000
 2396.3376      54.9178     124.5902     158.8558     142.1016     118.2417       8.4573     216.0000       0.1489       0.0792       0.0457    -999.2500      43.7695     223.1312      78.5651      49.9441       0.1047       0.1188       0.1668       5.8004    2574.5916     168.3494       0.0000    3927.0000
 2396.4900      45.0385     121.1105     160.1471     172.2028     126.2158       7.9229     216.0000       0.1486       0.0789       0.0454    -999.2500      43.7695     223.1312      85.4363      49.9441       0.1047       0.1188       0.1668       5.9314    2575.0889     168.0631       0.0000    3961.0000
 2396.6424      38.1017     117.6397     155.4961     207.2775     137.6810       7.2632     216.0000       0.1479       0.0781       0.0446    -999.2500      43.7695     223.1312      92.7401      49.9441       0.1047       0.1188       0.1668       6.0846    2576.4575     167.6390      -1.2500    4035.0000
 2396.7948      37.4668     179.9431     244.9602     277.6859     141.4983       7.0672     216.0000       0.1477       0.0779       0.0444    -999.2500      43.7695     223.1312      93.9524      49.9441       0.1047       0.1188       0.1668       6.2722    2576.7502     166.3856       0.0000    4004.0000
 2396.9472      37.5037     249.0280     284.8097     371.2670     192.6424       5.1910     216.0000       0.1538       0.0845       0.0512    -999.2500      43.7695     223.1312      84.0852      49.9441       0.1047       0.1188       0.1668       6.4874    2565.5042     162.4031      -1.3750    3941.0000
 2397.0996      37.2891     632.4888     346.3096     589.5995     340.6073       2.9359     216.0000       0.1584       0.0895       0.0563    -999.2500      43.7695     223.1312      69.1109      49.9441       0.1047       0.1188       0.1668       6.7207    2557.0320     158.0035       0.0000    3950.0000
 2397.2520      38.2509     688.1044     412.4830    1437.1768     378.3446       2.6431     216.0000       0.1839       0.1170       0.0849    -999.2500      43.7695     222.7590      60.5361      49.9441       0.1048       0.1189       0.1669       7.0314    2509.8694     154.1572       0.0000    3938.0000
 2397.4044      38.1593     690.0446     234.0243     634.3163     310.8004       3.2175     216.0000       0.2841       0.2255       0.1973    -999.2500      43.7695     222.5730      53.7169      49.9441       0.1048       0.1189       0.1669       7.4584    2324.4685      16.2386       0.0000    3975.0000
 2397.5568      36.0519     820.3057     218.8573     802.6193     363.3897       2.7519     216.0000       0.4156       0.3678       0.3448    -999.2500      43.7695     222.7590      62.4230      49.9441       0.1048       0.1189       0.1669       8.0066    2081.1208       4.5460       0.0000    3977.0000
 2397.7092      30.9382     743.8182     195.3801     738.7743     396.0288       2.5251     216.0000       0.5144       0.4746       0.4555    -999.2500      43.7695     178.2890      89.2553      49.9441       0.1074       0.1218       0.1700       8.4827    1898.3499       2.6006       2.1250    3944.0000
 2397.8616      25.1213     529.7758     182.0221     685.0008     372.0185       2.6880     216.0000       0.5339       0.4957       0.4774    -999.2500      43.7695     114.0029     122.5520      49.9441       0.1101       0.1248       0.1733       8.8084    1862.3358       2.0931       0.7500    3921.0000
 2398.0140      20.6066     364.4855     173.1030    1246.4078     662.8956       1.5085     216.0000       0.5234       0.4844       0.4656    -999.2500      43.7695     113.7238     142.6399      49.9441       0.1102       0.1248       0.1733       8.9455    1881.7488       2.0925       0.1875    4014.0000
 2398.1664      17.4470     258.0805     168.6150     578.1300     364.7845       2.7413     216.0000       0.5226       0.4835       0.4647    -999.2500      43.7695     113.7238     143.4499      49.9441       0.1102       0.1248       0.1733       9.0020    1883.2794       2.0923       0.0000    3986.0000
 2398.3188      15.4878     190.5835     159.3198     406.7275     245.3858       4.0752     216.0000       0.5231       0.4840       0.4652    -999.2500      43.7695     113.7238     142.5142      49.9441       0.1102       0.1248       0.1733       9.0158    1882.3418       2.0919       0.0000    4044.0000
 2398.4712      14.5274     153.9220     158.6099     352.5554     172.9136       5.7832     216.0000       0.5231       0.4841       0.4653    -999.2500      43.7695     113.7238     142.4150      49.9441       0.1102       0.1248       0.1733       9.0163    1882.2426       2.0917       0.0000    3949.0000
 2398.6236      13.8314     153.7626     162.7840     346.0189     177.6194       5.6300     216.0000       0.5231       0.4841       0.4653    -999.2500      43.7695     113.7238     142.4375      49.9441       0.1102       0.1248       0.1733       9.0162    1882.2650       2.0916       0.0000    3985.0000
 2398.7760      13.4963     152.5192     183.6705     328.1835     176.9079       5.6527     216.0000       0.5231       0.4841       0.4653    -999.2500      43.7695     113.7238     142.4370      49.9441       0.1102       0.1248       0.1733       9.0161    1882.2645       2.0914       0.0000    4030.0000
 2398.9284      13.0063     136.0039     155.4474     278.8632     136.5038       7.3258     216.0000       0.5231       0.4841       0.4653    -999.2500      43.7695     113.7238     142.4348      49.9441       0.1102       0.1248       0.1733       9.0160    1882.2623       2.0912       0.3125    3995.0000
 2399.0808      12.4851     128.1011     135.8243     241.8527     117.3112       8.5243     216.0000       0.5231       0.4841       0.4653    -999.2500      43.7695     113.7238     142.4320      49.9441       0.1102       0.1248       0.1733       9.0158    1882.2595       2.0911       0.0000    3995.0000
 2399.2332      12.0498     114.5282     117.3935     207.3273      97.8096      10.2239     216.0000       0.5231       0.4841       0.4653    -999.2500      43.7695     113.7238     142.4284      49.9441       0.1102       0.1248       0.1733       9.0157    1882.2559       2.0911       0.3750    3971.0000
 2399.3856      11.8518     114.9122     117.0487     240.2997      90.4306      11.0582     216.0000       0.5231       0.4841       0.4653    -999.2500      43.7695     113.7238     142.4239      49.9441       0.1102       0.1248       0.1733       9.0155    1882.2513       2.0912       0.5000    3974.0000
 2399.5380      11.6850     110.8042     101.8393     245.6435      73.6862      13.5711     216.0000       0.5231       0.4841       0.4653    -999.2500      43.7695     113.7238     142.4185      49.9441       0.1102       0.1248       0.1733       9.0152    1882.2460       2.0912       0.6875    3903.0000
 2399.6904      11.6163     119.3283     113.8629     249.8407      75.9337      13.1694     216.0000       0.5231       0.4841       0.4653    -999.2500      43.7695     113.7238     142.4116      49.9441       0.1102       0.1248       0.1733       9.0149    1882.2391       2.0907       0.3750    3945.0000
 2399.8428      11.5291     122.8569     102.7130     228.1597      92.6349      10.7951     216.0000       0.5231       0.4841       0.4653    -999.2500      43.7695     113.7238     142.4035      49.9441       0.1102       0.1248       0.1733       9.0145    1882.2310       2.0902       2.2500    3965.0000
 2399.9952      11.5008     141.0543      83.1333     197.1597     100.0773       9.9923     216.0000       0.5231       0.4841       0.4653    -999.2500      43.7695     113.7238     142.3930      49.9441       0.1102       0.1248       0.1733       9.0140    1882.2205       2.0899       2.4375    4036.0000
 2400.1476      11.4488     146.5316     128.0829     352.0949     205.6008       4.8638     216.0000       0.5231       0.4841       0.4653    -999.2500      43.7695     113.7238     142.3801      49.9441       0.1102       0.1248       0.1733       9.0134    1882.2076       2.0898       1.8750    3968.0000
 2400.3000      11.4603     144.1433     105.1130     346.8843     161.6885       6.1847     216.0000       0.5231       0.4841       0.4653    -999.2500      43.7695     113.7238     142.3643      49.9441       0.1102       0.1248       0.1733       9.0126    1882.1918       2.0898       2.3750    4020.0000
 2400.4524      11.0719     126.4013      74.0068     157.1650     127.7500       7.8278     216.0000       0.5232       0.4841       0.4654    -999.2500      43.7695     113.7238     142.3447      49.9441       0.1102       0.1248       0.1733       9.0117    1882.1722       2.0898       2.6875    3969.0000
 2400.6048      10.4545      98.8702      75.9161     211.4347     177.4773       5.6345     216.0000       0.5232       0.4841       0.4654    -999.2500      43.7695     113.7238     142.3205      49.9441       0.1102       0.1248       0.1733       9.0106    1882.1481       2.0897       3.0625    3974.0000
 2400.7572      10.6037      78.0101      63.4063     229.5891     194.2209       5.1488     216.0000       0.5232       0.4841       0.4654    -999.2500      43.7695     113.7238     142.2905      49.9441       0.1102       0.1248       0.1733       9.0091    1882.1180       2.0896       3.3125    3950.0000
 2400.9096      10.6808      69.7949      76.5685     287.0471     237.5566       4.2095     216.0000       0.5232       0.4842       0.4654    -999.2500      43.7695     113.7238     142.2538      49.9441       0.1102       0.1248       0.1733       9.0074    1882.0813       2.0896       2.2500    3952.0000
 2401.0620      10.6994      72.3683      69.5674     371.6922     269.9157       3.7049     216.0000       0.5232       0.4842       0.4654    -999.2500      43.7695     113.7238     142.2082      49.9441       0.1102       0.1248       0.1733       9.0052    1882.0358       2.0895       2.1875    3904.0000
 2401.2144      10.6399      68.5937      71.4345     440.3739     273.8333       3.6519     216.0000       0.5233       0.4842       0.4655    -999.2500      43.7695     113.7238     142.1517      49.9441       0.1102       0.1248       0.1733       9.0025    1881.9792       2.0892       1.3750    3975.0000
 2401.3668      10.6956      65.1639      74.8391     431.6545     272.2877       3.6726     216.0000       0.5233       0.4843       0.4655    -999.2500      43.7695     113.7238     142.0816      49.9441       0.1102       0.1248       0.1733       8.9992    1881.9092       2.0889       2.0625    3982.0000
 2401.5192      10.7227      64.3517      75.8585     386.9927     263.7720       3.7912     216.0000       0.5233       0.4843       0.4656    -999.2500      43.7695     113.7238     141.9951      49.9441       0.1102       0.1248       0.1733       8.9951    1881.8226       2.0887       0.8750    3957.0000
 2401.6716      10.7401      64.6436      75.9831     343.0890     259.4594       3.8542     216.0000       0.5234       0.4844       0.4656    -999.2500      43.7695     113.7238     141.8878      49.9441       0.1102       0.1248       0.1733       8.9901    1881.7153       2.0886       1.0000    4017.0000
 2401.8240      10.7810      65.2626      76.5616     320.0490     251.5237       3.9758     216.0000       0.5235       0.4845       0.4657    -999.2500      43.7695     113.7238     141.7533      49.9441       0.1102       0.1248       0.1733       8.9838    1881.5826       2.0885       0.0625    4021.0000
 2401.9764      10.8220      66.1173      77.1939     314.7992     246.4298       4.0580     216.0000       0.5236       0.4846       0.4658    -999.2500      43.7695     113.7238     141.5868      49.9441       0.1102       0.1248       0.1733       8.9761    1881.4180       2.0891       0.0000    4060.0000
 2402.1288      10.8327      64.6704      77.0765     321.6290     238.4058       4.1945     216.0000       0.5237       0.4847       0.4659    -999.2500      43.7695     113.7238     141.3820      49.9441       0.1102       0.1248       0.1733       8.9665    1881.2128       2.0904       0.0000    4035.0000
 2402.2812      10.8055      62.7802      75.4288     333.6954     227.0256       4.4048     216.0000       0.5238       0.4848       0.4661    -999.2500      43.7695     113.7238     141.1328      49.9441       0.1102       0.1248       0.1733       8.9547    1880.9615       2.0918       0.0000    3972.0000
 2402.4336      10.8024      60.3162      73.3149     354.6407     214.1884       4.6688     216.0000       0.5240       0.4850       0.4663    -999.2500      43.7695     113.7238     140.8187      49.9441       0.1102       0.1248       0.1733       8.9399    1880.6454       2.0926       0.0000    3937.0000
 2402.5860      10.8186      61.1119      75.2598     380.6264     217.8245       4.5909     216.0000       0.5242       0.4852       0.4665    -999.2500      43.7695     113.7238     140.4262      49.9441       0.1102       0.1248       0.1733       8.9215    1880.2526       2.0928      -0.0625    3810.0000
 2402.7384      10.8287      61.2456      75.1922     395.3564     212.5826       4.7041     216.0000       0.5244       0.4855       0.4668    -999.2500      43.7695     113.7238     139.9635      49.9441       0.1102       0.1248       0.1733       8.8998    1879.7897       2.0929       0.0000    3685.0000
 2402.8908      10.8242      61.1083      75.3291     397.5121     210.8910       4.7418     216.0000       0.5248       0.4859       0.4672    -999.2500      43.7695     113.7238     139.3049      49.9441       0.1102       0.1248       0.1733       8.8689    1879.1306       2.0929       0.0000    3629.0000
 2403.0432      10.8214      61.0201      75.6206     388.3075     209.4703       4.7739     216.0000       0.5252       0.4863       0.4676    -999.2500      43.7695     113.7238     138.6416      49.9441       0.1102       0.1248       0.1733       8.8370    1878.4673       2.0929       0.0000    3529.0000
 2403.1956      10.8215      60.9738      75.4962     374.5801     207.5090       4.8191     216.0000       0.5256       0.4867       0.4681    -999.2500      43.7695     113.7238     137.8604      49.9441       0.1102       0.1248       0.1733       8.7978    1877.6912       2.0929       0.0000    3463.0000
 2403.3480      10.8206      60.9457      75.5230     362.1608     206.1754       4.8502     216.0000       0.5266       0.4878       0.4692    -999.2500      43.7695     113.7238     135.9712      49.9441       0.1102       0.1248       0.1733       8.7072    1875.8557       2.0930       5.6250    3394.0000
 2403.5004      10.8197      60.9702      75.4370     353.4037     205.0238       4.8775     216.0000       0.5264       0.4876       0.4690    -999.2500      43.7695     113.7238     564.6290      49.9441       0.1102       0.1248       0.1733       8.6990    1876.1803       2.0930      -0.3125    3302.0000
 2403.6528      10.8194      60.9444      75.3738     348.0235     204.5987       4.8876     216.0000       0.5272       0.4885       0.4699    -999.2500      43.7695     113.7238    1205.7020      49.9441       0.1102       0.1248       0.1733       8.5915    1874.6399       2.0930       0.0000    3247.0000
 2403.8052      10.8194      60.8994      75.2988     345.4857     204.5632       4.8885     216.0000       0.5293       0.4908       0.4723    -999.2500      43.7695     113.7238    1844.5114      49.9441       0.1102       0.1248       0.1733       8.1299    1870.7870       2.0930       0.0000    3132.0000
 2403.9576      10.8192      60.8307      75.2818     344.8223     204.8044       4.8827     216.0000     541.6757     585.9415     607.2121    -999.2500      43.7695     113.7238 -999250.0000      49.9441       0.1102       0.1248       0.1733    -999.2500 -999250.0000       2.0930      -2.0625    3024.0000
 2404.1100      10.8191      60.7748      75.2781     345.5218     205.0388       4.8771     216.0000     541.6757     585.9415     607.2121    -999.2500      43.7695     113.7238 -999250.0000      49.9441       0.1102       0.1248       0.1733    -999.2500 -999250.0000       2.0930       0.0000    2947.0000
 2404.2624      10.8189      60.7323      75.2891     346.4631     205.4265       4.8679     216.0000     541.6757     585.9415     607.2121    -999.2500      43.7695     113.7238 -999250.0000      49.9441       0.1102       0.1248       0.1733    -999.2500 -999250.0000       2.0930      -0.3750    2841.0000
 2404.4148      10.8188      60.7080      75.2778     347.3386     205.5505       4.8650     216.0000     541.6757     585.9415     607.2121    -999.2500      43.7695     113.7238 -999250.0000      49.9441       0.1102       0.1248       0.1733    -999.2500 -999250.0000       2.0930       0.0000    2669.0000
 2404.5672      10.8184      60.6961      75.2734     348.1808     205.7790       4.8596     216.0000     541.6757     585.9415     607.2121    -999.2500      43.7695     113.7238 -999250.0000      49.9441       0.1102       0.1248       0.1733    -999.2500 -999250.0000       2.0943      -4.4375    2485.0000
 2404.7196      10.8182      60.7024      75.2705     348.9324     205.9527       4.8555     216.0000     541.6757     585.9415     607.2121    -999.2500      43.7695     113.7238 -999250.0000      49.9441       0.1102       0.1248       0.1733    -999.2500 -999250.0000       2.1038       0.0000    2214.0000
 2404.8720      10.8180      60.7198      75.2682     349.4049     206.1569       4.8507     216.0000     541.6757     585.9415     607.2121    -999.2500      43.7695     113.7238 -999250.0000      49.9441       0.1102       0.1248       0.1733    -999.2500 -999250.0000       2.1103       0.0000    2214.0000
